package dev.felnull.otyacraftengine.forge.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.block.IIkisugiVoxelShape;
import dev.felnull.otyacraftengine.client.debug.HighlightVoxelShapeType;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import var;

@Mixin(LevelRenderer.class)
public abstract class LevelRendererMixin {

    @Shadow
    private ClientLevel level;

    @Shadow
    private boolean needsUpdate;

    @Inject(method = "renderHitOutline", at = @At("HEAD"), cancellable = true)
    private void renderHitOutline(PoseStack poseStack, VertexConsumer vertexConsumer, Entity entity, double d, double e, double f, BlockPos blockPos, BlockState blockState, CallbackInfo ci) {
        var shapeType = OtyacraftEngine.CONFIG.highlightVoxelShape;
        if (shapeType != HighlightVoxelShapeType.OFF) {
            var shape = shapeType.getGetter();
            if (shape != null)
                LevelRenderer.m_109654_(poseStack, vertexConsumer, shape.getShape(blockState, level, blockPos, CollisionContext.m_82750_(entity)), (double) blockPos.m_123341_() - d, (double) blockPos.m_123342_() - e, (double) blockPos.m_123343_() - f, 0.0F, 0.0F, 0.0F, 0.4F);
            ci.cancel();
        }
    }

    @Inject(method = "renderShape", at = @At("HEAD"), cancellable = true)
    private static void renderShape(PoseStack poseStack, VertexConsumer vertexConsumer, VoxelShape voxelShape, double x, double y, double z, float r, float g, float b, float a, CallbackInfo ci) {
        if (!OtyacraftEngine.CONFIG.ikisugiVoxelShape) return;
        if (((IIkisugiVoxelShape) voxelShape).getEdges() == null) return;
        ci.cancel();
        var pose = poseStack.m_85850_();
        for (IIkisugiVoxelShape.Edge edge : ((IIkisugiVoxelShape) voxelShape).getEdges()) {
            renderShapeEdge(pose, vertexConsumer, edge.stX(), edge.stY(), edge.stZ(), edge.enX(), edge.enY(), edge.enZ(), x, y, z, r, g, b, a);
        }
    }

    private static void renderShapeEdge(PoseStack.Pose pose, VertexConsumer vertexConsumer, double sx, double sy, double sz, double ex, double ey, double ez, double x, double y, double z, float r, float g, float b, float a) {
        float q = (float) (ex - sx);
        float r2 = (float) (ey - sy);
        float s = (float) (ez - sz);
        float t = Mth.m_14116_(q * q + r2 * r2 + s * s);
        q /= t;
        r2 /= t;
        s /= t;
        vertexConsumer.m_85982_(pose.m_85861_(), (float) (sx + x), (float) (sy + y), (float) (sz + z)).m_85950_(r, g, b, a).m_85977_(pose.m_85864_(), q, r2, s).m_5752_();
        vertexConsumer.m_85982_(pose.m_85861_(), (float) (ex + x), (float) (ey + y), (float) (ez + z)).m_85950_(r, g, b, a).m_85977_(pose.m_85864_(), q, r2, s).m_5752_();
    }
}
