/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import dev.felnull.otyacraftengine.client.gui.TextureSpecifyLocation;
import dev.felnull.otyacraftengine.client.util.OETextureUtil;
import dev.felnull.otyacraftengine.libs.dev.felnull.fnjl.util.FNColorUtil;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class OERenderUtil {
    private static final Minecraft mc = Minecraft.m_91087_();
    public static final float MIN_BREADTH = 0.001f;

    public static void drawFill(@NotNull PoseStack poseStack, float x, float y, float w, float h, int color) {
        OERenderUtil.innerFill(poseStack.m_85850_().m_85861_(), x, y, w, h, color);
    }

    private static void innerFill(Matrix4f matrix4f, float i, float j, float k, float l, int m) {
        float n;
        if (i < k) {
            n = i;
            i = k;
            k = n;
        }
        if (j < l) {
            n = j;
            j = l;
            l = n;
        }
        float f = (float)(m >> 24 & 0xFF) / 255.0f;
        float g = (float)(m >> 16 & 0xFF) / 255.0f;
        float h = (float)(m >> 8 & 0xFF) / 255.0f;
        float o = (float)(m & 0xFF) / 255.0f;
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_85982_(matrix4f, i, l, 0.0f).m_85950_(g, h, o, f).m_5752_();
        bufferBuilder.m_85982_(matrix4f, k, l, 0.0f).m_85950_(g, h, o, f).m_5752_();
        bufferBuilder.m_85982_(matrix4f, k, j, 0.0f).m_85950_(g, h, o, f).m_5752_();
        bufferBuilder.m_85982_(matrix4f, i, j, 0.0f).m_85950_(g, h, o, f).m_5752_();
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    public static void renderCenterTextSprite(PoseStack poseStack, MultiBufferSource multiBufferSource, Component text, float x, float y, float z, float size, float textX, float textY, int color, int combinedLightIn) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, (double)z);
        poseStack.m_85841_(0.010416667f * size, -0.010416667f * size, 0.010416667f * size);
        Font font = OERenderUtil.mc.f_91062_;
        float f = (float)(-OERenderUtil.mc.f_91062_.m_92852_((FormattedText)text)) / 2.0f + textX;
        Objects.requireNonNull(OERenderUtil.mc.f_91062_);
        font.m_92841_(text, f, (float)(-9) + textY, color, false, poseStack.m_85850_().m_85861_(), multiBufferSource, false, 0, combinedLightIn);
        poseStack.m_85849_();
    }

    public static void renderCenterTextSprite(PoseStack poseStack, MultiBufferSource multiBufferSource, Component text, float x, float y, float z, float size, float textX, float textY, int combinedLightIn) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, (double)z);
        poseStack.m_85841_(0.010416667f * size, -0.010416667f * size, 0.010416667f * size);
        Font font = OERenderUtil.mc.f_91062_;
        float f = (float)(-OERenderUtil.mc.f_91062_.m_92852_((FormattedText)text)) / 2.0f + textX;
        Objects.requireNonNull(OERenderUtil.mc.f_91062_);
        font.m_92841_(text, f, (float)(-9) + textY, 0, false, poseStack.m_85850_().m_85861_(), multiBufferSource, false, 0, combinedLightIn);
        poseStack.m_85849_();
    }

    public static void renderTextSprite(PoseStack poseStack, MultiBufferSource multiBufferSource, Component text, float x, float y, float z, float size, float textX, float textY, int color, int combinedLightIn) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, (double)z);
        poseStack.m_85841_(0.010416667f * size, -0.010416667f * size, 0.010416667f * size);
        Font font = OERenderUtil.mc.f_91062_;
        Objects.requireNonNull(OERenderUtil.mc.f_91062_);
        font.m_92841_(text, textX, (float)(-9) + textY, color, false, poseStack.m_85850_().m_85861_(), multiBufferSource, false, 0, combinedLightIn);
        poseStack.m_85849_();
    }

    public static void renderTextSprite(PoseStack poseStack, MultiBufferSource multiBufferSource, Component text, float x, float y, float z, float size, float textX, float textY, int combinedLightIn) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, (double)z);
        poseStack.m_85841_(0.010416667f * size, -0.010416667f * size, 0.010416667f * size);
        Font font = OERenderUtil.mc.f_91062_;
        Objects.requireNonNull(OERenderUtil.mc.f_91062_);
        font.m_92841_(text, textX, (float)(-9) + textY, 0, false, poseStack.m_85850_().m_85861_(), multiBufferSource, false, 0, combinedLightIn);
        poseStack.m_85849_();
    }

    public static void drawFixedWidthText(PoseStack poseStack, Component text, float x, float y, int color, float width) {
        int size = OERenderUtil.mc.f_91062_.m_92852_((FormattedText)text);
        poseStack.m_85836_();
        if ((float)size > width) {
            float scale = width / (float)size;
            x /= scale;
            y /= scale;
            OERenderUtil.poseScaleAll(poseStack, scale);
        }
        OERenderUtil.mc.f_91062_.m_92889_(poseStack, text, x, y, color);
        poseStack.m_85849_();
    }

    public static void drawFixedWidthText(PoseStack poseStack, String text, float x, float y, int color, float width) {
        int size = OERenderUtil.mc.f_91062_.m_92895_(text);
        poseStack.m_85836_();
        if ((float)size > width) {
            float scale = width / (float)size;
            x /= scale;
            y /= scale;
            OERenderUtil.poseScaleAll(poseStack, scale);
        }
        OERenderUtil.mc.f_91062_.m_92883_(poseStack, text, x, y, color);
        poseStack.m_85849_();
    }

    public static void drawCenterText(PoseStack poseStack, Component text, float x, float y, int color) {
        OERenderUtil.mc.f_91062_.m_92889_(poseStack, text, x - (float)OERenderUtil.mc.f_91062_.m_92852_((FormattedText)text) / 2.0f, y, color);
    }

    public static void drawCenterText(PoseStack poseStack, String str, float x, float y, int color) {
        OERenderUtil.mc.f_91062_.m_92883_(poseStack, str, x - (float)OERenderUtil.mc.f_91062_.m_92895_(str) / 2.0f, y, color);
    }

    public static void drawPlayerFace(PoseStack poseStack, UUID uuid, float x, float y) {
        OERenderUtil.drawPlayerFace(poseStack, uuid, x, y, 8.0f);
    }

    public static void drawPlayerFace(PoseStack poseStack, UUID uuid, float x, float y, float size) {
        poseStack.m_85836_();
        float sc = size / 8.0f;
        ResourceLocation plskin = OETextureUtil.getPlayerSkinTexture(uuid);
        OERenderUtil.drawTexture(plskin, poseStack, x, y, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc);
        OERenderUtil.drawTexture(plskin, poseStack, x, y, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc);
        poseStack.m_85849_();
    }

    public static void drawPlayerFace(PoseStack poseStack, String name, float x, float y) {
        OERenderUtil.drawPlayerFace(poseStack, name, x, y, 8.0f);
    }

    public static void drawPlayerFace(PoseStack poseStack, String name, float x, float y, float size) {
        poseStack.m_85836_();
        float sc = size / 8.0f;
        ResourceLocation plskin = OETextureUtil.getPlayerSkinTexture(name);
        OERenderUtil.drawTexture(plskin, poseStack, x, y, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc);
        OERenderUtil.drawTexture(plskin, poseStack, x, y, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc);
        poseStack.m_85849_();
    }

    public static void drawTexture(ResourceLocation location, PoseStack poseStack, float x, float y, float textureStartX, float textureStartY, float textureFinishWidth, float textureFinishHeight) {
        OERenderUtil.drawTexture(location, poseStack, x, y, textureStartX, textureStartY, textureFinishWidth, textureFinishHeight, 256.0f, 256.0f);
    }

    public static void drawTexture(PoseStack poseStack, float x, float y, TextureSpecifyLocation texture) {
        OERenderUtil.drawTexture(texture.location(), poseStack, x, y, texture.x(), texture.y(), texture.width(), texture.height(), texture.sizeWidth(), texture.sizeHeight());
    }

    public static void drawTexture(ResourceLocation location, PoseStack poseStack, float x, float y, float textureStartX, float textureStartY, float textureFinishWidth, float textureFinishHeight, float textureSizeX, float textureSizeY) {
        poseStack.m_85836_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)location);
        OERenderUtil.fBlit(poseStack, x, y, textureStartX, textureStartY, textureFinishWidth, textureFinishHeight, textureSizeX, textureSizeY);
        poseStack.m_85849_();
    }

    public static void drawColorTexture(ResourceLocation location, PoseStack poseStack, float x, float y, float textureStartX, float textureStartY, float textureFinishWidth, float textureFinishHeight, int color) {
        OERenderUtil.drawColorTexture(location, poseStack, x, y, textureStartX, textureStartY, textureFinishWidth, textureFinishHeight, 256.0f, 256.0f, color);
    }

    public static void drawColorTexture(ResourceLocation location, PoseStack poseStack, float x, float y, float textureStartX, float textureStartY, float textureFinishWidth, float textureFinishHeight, float textureSizeX, float textureSizeY, int color) {
        float r = (float)FNColorUtil.getRed(color) / 255.0f;
        float g = (float)FNColorUtil.getGreen(color) / 255.0f;
        float b = (float)FNColorUtil.getBlue(color) / 255.0f;
        float a = (float)FNColorUtil.getAlpha(color) / 255.0f;
        poseStack.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
        RenderSystem.m_157456_((int)0, (ResourceLocation)location);
        OERenderUtil.fBlit(poseStack, x, y, textureStartX, textureStartY, textureFinishWidth, textureFinishHeight, textureSizeX, textureSizeY);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
        poseStack.m_85849_();
    }

    private static void fBlit(PoseStack poseStack, float ix, float iy, float tsx, float tsy, float tw, float th, float tssx, float tssy) {
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        float x = ix;
        float y = ix + tw;
        float w = iy;
        float h = iy + th;
        float u1 = tsx / tssx;
        float u2 = (tsx + tw) / tssx;
        float v1 = tsy / tssy;
        float v2 = (tsy + th) / tssy;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_85982_(matrix4f, x, h, 0.0f).m_7421_(u1, v2).m_5752_();
        bufferBuilder.m_85982_(matrix4f, y, h, 0.0f).m_7421_(u2, v2).m_5752_();
        bufferBuilder.m_85982_(matrix4f, y, w, 0.0f).m_7421_(u2, v1).m_5752_();
        bufferBuilder.m_85982_(matrix4f, x, w, 0.0f).m_7421_(u1, v1).m_5752_();
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
    }

    public static void poseTrans16(PoseStack poseStack, double x, double y, double z) {
        float pix = 0.0625f;
        poseStack.m_85837_((double)pix * x, (double)pix * y, (double)pix * z);
    }

    public static void poseScaleAll(PoseStack poseStack, float scale) {
        poseStack.m_85841_(scale, scale, scale);
    }

    public static void poseRotateAll(PoseStack poseStack, float x, float y, float z) {
        OERenderUtil.poseRotateX(poseStack, x);
        OERenderUtil.poseRotateY(poseStack, y);
        OERenderUtil.poseRotateZ(poseStack, z);
    }

    public static void poseRotateX(PoseStack poseStack, float angle) {
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(angle));
    }

    public static void poseRotateY(PoseStack poseStack, float angle) {
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(angle));
    }

    public static void poseRotateZ(PoseStack poseStack, float angle) {
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(angle));
    }

    public static void poseRotateHorizontalState(PoseStack poseStack, BlockState state, int roted) {
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        OERenderUtil.poseRotateDirection(poseStack, direction, roted);
    }

    public static void poseRotateDirection(PoseStack poseStack, Direction direction, int roted) {
        for (int i = 0; i < roted; ++i) {
            direction = direction.m_122427_();
        }
        if (direction == Direction.WEST) {
            OERenderUtil.poseRotateY(poseStack, 180.0f);
            poseStack.m_85837_(-1.0, 0.0, -1.0);
        } else if (direction == Direction.NORTH) {
            OERenderUtil.poseRotateY(poseStack, 90.0f);
            poseStack.m_85837_(-1.0, 0.0, 0.0);
        } else if (direction == Direction.SOUTH) {
            OERenderUtil.poseRotateY(poseStack, 270.0f);
            poseStack.m_85837_(0.0, 0.0, -1.0);
        }
    }

    public static void renderPlayerFaceSprite(PoseStack poseStack, MultiBufferSource multiBufferSource, UUID uuid, float x, float y, float z, float pitch, float yaw, float roll, float size, int combinedLightIn, int combinedOverlayIn) {
        float sc = size / 8.0f;
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(uuid), poseStack, multiBufferSource, x, y, z, pitch, yaw, roll, size, size, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(uuid), poseStack, multiBufferSource, x, y, z + 1.0E-5f, pitch, yaw, roll, size, size, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
    }

    public static void renderPlayerFaceSprite(PoseStack poseStack, MultiBufferSource multiBufferSource, String name, float x, float y, float z, float pitch, float yaw, float roll, float size, int combinedLightIn, int combinedOverlayIn) {
        float sc = size / 8.0f;
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(name), poseStack, multiBufferSource, x, y, z, pitch, yaw, roll, size, size, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(name), poseStack, multiBufferSource, x, y, z + 1.0E-5f, pitch, yaw, roll, size, size, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
    }

    public static void renderPlayerFaceSpriteSides(PoseStack poseStack, MultiBufferSource multiBufferSource, UUID uuid, float x, float y, float z, float pitch, float yaw, float roll, float size, int combinedLightIn, int combinedOverlayIn) {
        float sc = size / 8.0f;
        OERenderUtil.renderTextureSpriteSides(OETextureUtil.getPlayerSkinTexture(uuid), poseStack, multiBufferSource, x, y, z, pitch, yaw, roll, size, size, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(uuid), poseStack, multiBufferSource, x, y, z + 1.0E-5f, pitch, yaw, roll, size, size, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(uuid), poseStack, multiBufferSource, x + 1.0f, y, z - 2.0E-5f, pitch, yaw + 180.0f, roll, size, size, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
    }

    public static void renderPlayerFaceSpriteSides(PoseStack poseStack, MultiBufferSource multiBufferSource, String name, float x, float y, float z, float pitch, float yaw, float roll, float size, int combinedLightIn, int combinedOverlayIn) {
        float sc = size / 8.0f;
        OERenderUtil.renderTextureSpriteSides(OETextureUtil.getPlayerSkinTexture(name), poseStack, multiBufferSource, x, y, z, pitch, yaw, roll, size, size, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(name), poseStack, multiBufferSource, x, y, z + 1.0E-5f, pitch, yaw, roll, size, size, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(name), poseStack, multiBufferSource, x + 1.0f, y, z - 2.0E-5f, pitch, yaw + 180.0f, roll, size, size, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
    }

    public static void renderTextureSprite(ResourceLocation location, PoseStack poseStack, MultiBufferSource multiBufferSource, float x, float y, float z, float pitch, float yaw, float roll, float w, float h, float texStartX, float texStartY, float texFinishX, float texFinishY, float texSizeW, float texSizeH, int combinedLightIn, int combinedOverlayIn) {
        OERenderUtil.renderColorTextureSprite(location, poseStack, multiBufferSource, x, y, z, 1.0f, 1.0f, 1.0f, 1.0f, pitch, yaw, roll, w, h, texStartX, texStartY, texFinishX, texFinishY, texSizeW, texSizeH, combinedLightIn, combinedOverlayIn);
    }

    public static void renderColorTextureSprite(ResourceLocation location, PoseStack poseStack, MultiBufferSource multiBufferSource, float x, float y, float z, float r, float g, float b, float a, float pitch, float yaw, float roll, float w, float h, float texStartX, float texStartY, float texFinishX, float texFinishY, float texSizeW, float texSizeH, int combinedLightIn, int combinedOverlayIn) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, (double)z);
        OERenderUtil.poseRotateY(poseStack, yaw);
        OERenderUtil.poseRotateX(poseStack, pitch);
        OERenderUtil.poseRotateZ(poseStack, roll);
        VertexConsumer vc = multiBufferSource.m_6299_(RenderType.m_110497_((ResourceLocation)location));
        float wst = texStartX / texSizeW;
        float wft = texFinishX / texSizeW + wst;
        float hst = texStartY / texSizeH;
        float hft = texFinishY / texSizeH + hst;
        PoseStack.Pose pose = poseStack.m_85850_();
        OERenderUtil.vertex(vc, pose, 0.0f, 0.0f, 0.0f, wst, hft, r, g, b, a, combinedOverlayIn, combinedLightIn);
        OERenderUtil.vertex(vc, pose, w, 0.0f, 0.0f, wft, hft, r, g, b, a, combinedOverlayIn, combinedLightIn);
        OERenderUtil.vertex(vc, pose, w, h, 0.0f, wft, hst, r, g, b, a, combinedOverlayIn, combinedLightIn);
        OERenderUtil.vertex(vc, pose, 0.0f, h, 0.0f, wst, hst, r, g, b, a, combinedOverlayIn, combinedLightIn);
        poseStack.m_85849_();
    }

    public static void renderTextureSpriteSides(ResourceLocation location, PoseStack poseStack, MultiBufferSource multiBufferSource, float x, float y, float z, float pitch, float yaw, float roll, float w, float h, float texStartX, float texStartY, float texFinishX, float texFinishY, float texSizeW, float texSizeH, int combinedLightIn, int combinedOverlayIn) {
        OERenderUtil.renderTextureSprite(location, poseStack, multiBufferSource, x, y, z, pitch, yaw, roll, w, h, texStartX, texStartY, texFinishX, texFinishY, texSizeW, texSizeH, combinedLightIn, combinedOverlayIn);
        OERenderUtil.renderTextureSprite(location, poseStack, multiBufferSource, x + 1.0f, y, z - 1.0E-5f, pitch, yaw + 180.0f, roll, w, h, texStartX, texStartY, texFinishX, texFinishY, texSizeW, texSizeH, combinedLightIn, combinedOverlayIn);
    }

    private static void vertex(VertexConsumer builder, PoseStack.Pose pose, float x, float y, float z, float u, float v, float r, float g, float b, float a, int combinedOverlayIn, int combinedLightIn) {
        builder.m_85982_(pose.m_85861_(), x, y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_86008_(combinedOverlayIn).m_85969_(combinedLightIn).m_85977_(pose.m_85864_(), 0.0f, 0.0f, 0.0f).m_5752_();
    }

    public static void renderModel(PoseStack poseStack, VertexConsumer vertexConsumer, @NotNull BakedModel bakedModel, int combinedLight, int combinedOverlay) {
        Objects.requireNonNull(bakedModel);
        ModelBlockRenderer bmr = mc.m_91289_().m_110937_();
        bmr.m_111067_(poseStack.m_85850_(), vertexConsumer, null, bakedModel, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay);
    }

    public static void renderModel(PoseStack poseStack, VertexConsumer vertexConsumer, @NotNull BakedModel bakedModel, int combinedLight, int combinedOverlay, int color) {
        Objects.requireNonNull(bakedModel);
        ModelBlockRenderer bmr = mc.m_91289_().m_110937_();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        bmr.m_111067_(poseStack.m_85850_(), vertexConsumer, null, bakedModel, r, g, b, combinedLight, combinedOverlay);
    }

    public static float getPartialTicks() {
        return mc.m_91104_() ? OERenderUtil.mc.f_91013_ : mc.m_91296_();
    }

    public static void renderPlayerArm(PoseStack poseStack, MultiBufferSource multiBufferSource, HumanoidArm arm, int light) {
        boolean bl = arm != HumanoidArm.LEFT;
        PlayerRenderer pr = (PlayerRenderer)mc.m_91290_().m_114382_((Entity)OERenderUtil.mc.f_91074_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)OERenderUtil.mc.f_91074_.m_108560_());
        if (bl) {
            pr.m_117770_(poseStack, multiBufferSource, light, (AbstractClientPlayer)OERenderUtil.mc.f_91074_);
        } else {
            pr.m_117813_(poseStack, multiBufferSource, light, (AbstractClientPlayer)OERenderUtil.mc.f_91074_);
        }
    }

    public static void posePlayerArm(PoseStack poseStack, HumanoidArm arm, float swingProgress, float equipProgress) {
        boolean bl = arm != HumanoidArm.LEFT;
        float h = bl ? 1.0f : -1.0f;
        float j = Mth.m_14116_((float)swingProgress);
        float k = -0.3f * Mth.m_14031_((float)(j * (float)Math.PI));
        float l = 0.4f * Mth.m_14031_((float)(j * ((float)Math.PI * 2)));
        float m = -0.4f * Mth.m_14031_((float)(swingProgress * (float)Math.PI));
        poseStack.m_85837_((double)(h * (k + 0.64000005f)), (double)(l + -0.6f + equipProgress * -0.6f), (double)(m + -0.71999997f));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(h * 45.0f));
        float n = Mth.m_14031_((float)(swingProgress * swingProgress * (float)Math.PI));
        float o = Mth.m_14031_((float)(j * (float)Math.PI));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(h * o * 70.0f));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(h * n * -20.0f));
        poseStack.m_85837_((double)(h * -1.0f), (double)3.6f, 3.5);
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(h * 120.0f));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(200.0f));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(h * -135.0f));
        poseStack.m_85837_((double)(h * 5.6f), 0.0, 0.0);
    }

    public static void renderHandItem(PoseStack poseStack, MultiBufferSource multiBufferSource, HumanoidArm arm, ItemStack stack, int light) {
        boolean handFlg = arm == HumanoidArm.RIGHT;
        mc.m_91292_().m_109322_((LivingEntity)OERenderUtil.mc.f_91074_, stack, handFlg ? ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !handFlg, poseStack, multiBufferSource, light);
    }

    public static void poseHandItem(PoseStack poseStack, HumanoidArm arm, float swingProgress, float equipProgress) {
        boolean handFlg = arm == HumanoidArm.RIGHT;
        float s = -0.4f * Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * (float)Math.PI));
        float r = 0.2f * Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * ((float)Math.PI * 2)));
        float l = -0.2f * Mth.m_14031_((float)(swingProgress * (float)Math.PI));
        int t = handFlg ? 1 : -1;
        poseStack.m_85837_((double)((float)t * s), (double)r, (double)l);
        poseStack.m_85837_((double)((float)t * 0.56f), (double)(-0.52f + equipProgress * -0.6f), (double)-0.72f);
        float g = Mth.m_14031_((float)(swingProgress * swingProgress * (float)Math.PI));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)t * (45.0f + g * -20.0f)));
        float h = Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * (float)Math.PI));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_((float)t * h * -20.0f));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(h * -80.0f));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)t * -45.0f));
    }

    public static float getParSecond(long loopTime) {
        return (float)(System.currentTimeMillis() % loopTime) / (float)loopTime;
    }

    public static String getWidthString(String text, float maxWidth, String exit) {
        int wh = OERenderUtil.mc.f_91062_.m_92895_(text);
        if (maxWidth >= (float)wh) {
            return text;
        }
        int exwh = OERenderUtil.mc.f_91062_.m_92895_(exit);
        StringBuilder sb = new StringBuilder();
        for (char c : text.toCharArray()) {
            sb.append(c);
            if ((float)OERenderUtil.mc.f_91062_.m_92895_(sb.toString()) > maxWidth - (float)exwh) break;
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(exit);
        return sb.toString();
    }
}

