/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.platform.Platform;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.client.loader.PlayerInfoManager;
import dev.felnull.otyacraftengine.client.loader.URLTextureManager;
import dev.felnull.otyacraftengine.client.renderer.GuiDebugRenderer;
import dev.felnull.otyacraftengine.client.util.ClientUtilInit;
import dev.felnull.otyacraftengine.util.OEItemUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;

public class ClientHandler {
    public static void init() {
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(ClientHandler::onQuit);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(ClientHandler::onJoin);
        ClientTooltipEvent.ITEM.register(ClientHandler::onTooltip);
        ClientGuiEvent.RENDER_POST.register(ClientHandler::onRenderGui);
    }

    private static void onRenderGui(Screen screen, PoseStack posestack, int mouseX, int mouseY, float delta) {
        if (!OtyacraftEngine.CONFIG.showWidgetData) {
            return;
        }
        GuiDebugRenderer.onScreenRender(screen, posestack, mouseX, mouseY, delta);
    }

    private static void onJoin(LocalPlayer localPlayer) {
        ClientHandler.onReset();
    }

    private static void onQuit(LocalPlayer localPlayer) {
        ClientHandler.onReset();
    }

    private static void onReset() {
        ClientUtilInit.clear();
        PlayerInfoManager.getInstance().reload();
        URLTextureManager.getInstance().reload();
    }

    private static void onTooltip(ItemStack itemStack, List<Component> list, TooltipFlag tooltipFlag) {
        if (itemStack.m_41619_()) {
            return;
        }
        if (OtyacraftEngine.CONFIG.showTagTooltip) {
            List<ResourceLocation> itemTags = itemStack.m_204131_().map(TagKey::f_203868_).toList();
            Item item = itemStack.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                List<ResourceLocation> blockTags = blockItem.m_40614_().m_204297_().m_203616_().map(TagKey::f_203868_).toList();
                HashSet<ResourceLocation> bothTags = new HashSet<ResourceLocation>();
                boolean firstItem = false;
                boolean firstBlock = false;
                for (ResourceLocation tag : itemTags) {
                    if (!blockTags.contains(tag)) {
                        if (!firstItem) {
                            list.add((Component)new TextComponent("Item tags").m_130940_(ChatFormatting.AQUA));
                            firstItem = true;
                        }
                        list.add((Component)new TextComponent(" - " + tag));
                        continue;
                    }
                    bothTags.add(tag);
                }
                Iterator<Object> iterator = blockTags.iterator();
                while (iterator.hasNext()) {
                    ResourceLocation blockTag = (ResourceLocation)iterator.next();
                    if (!itemTags.contains(blockTag)) {
                        if (!firstBlock) {
                            list.add((Component)new TextComponent("Block tags").m_130940_(ChatFormatting.AQUA));
                            firstBlock = true;
                        }
                        list.add((Component)new TextComponent(" - " + blockTag));
                        continue;
                    }
                    bothTags.add(blockTag);
                }
                if (!bothTags.isEmpty()) {
                    list.add((Component)new TextComponent("Both tags").m_130940_(ChatFormatting.AQUA));
                    for (ResourceLocation tag : bothTags) {
                        list.add((Component)new TextComponent(" - " + tag));
                    }
                }
            } else if (!itemTags.isEmpty()) {
                list.add((Component)new TextComponent("Item tags").m_130940_(ChatFormatting.AQUA));
                for (ResourceLocation tag : itemTags) {
                    list.add((Component)new TextComponent(" - " + tag));
                }
            }
            Set<EntityType<?>> entityTypes = ClientHandler.getEntityTypesByItem(itemStack);
            HashSet entityTypeTags = new HashSet();
            entityTypes.forEach(n -> entityTypeTags.addAll(n.m_204041_().m_203616_().map(TagKey::f_203868_).toList()));
            if (!entityTypeTags.isEmpty()) {
                list.add((Component)new TextComponent("Entity tags").m_130940_(ChatFormatting.AQUA));
                for (ResourceLocation tag : entityTypeTags) {
                    list.add((Component)new TextComponent(" - " + tag));
                }
            }
        }
        if (OtyacraftEngine.CONFIG.showModNameTooltip) {
            ResourceLocation modid = Registry.f_122827_.m_7981_((Object)itemStack.m_41720_());
            list.add((Component)new TextComponent(Platform.getMod((String)modid.m_135827_()).getName()).m_130940_(ChatFormatting.DARK_GREEN));
        }
    }

    private static Set<EntityType<?>> getEntityTypesByItem(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof SpawnEggItem) {
            SpawnEggItem spawnEggItem = (SpawnEggItem)item;
            return Set.of(spawnEggItem.m_43228_(stack.m_41783_()));
        }
        if (item instanceof MobBucketItem) {
            MobBucketItem mobBucketItem = (MobBucketItem)item;
            return Set.of(OEItemUtil.getMobBucketEntity(mobBucketItem));
        }
        return Set.of();
    }
}

