/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.motion;

import dev.felnull.otyacraftengine.client.motion.Motion;
import dev.felnull.otyacraftengine.client.motion.MotionLoader;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionManager
extends SimplePreparableReloadListener<MotionLoader> {
    private static MotionManager INSTANCE;
    private Map<ResourceLocation, Motion> motions;

    public MotionManager() {
        INSTANCE = this;
    }

    public static MotionManager getInstance() {
        return INSTANCE;
    }

    protected MotionLoader prepare(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        return new MotionLoader(resourceManager, profilerFiller);
    }

    protected void apply(@NotNull MotionLoader loader, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        this.motions = loader.getMotions();
    }

    @Nullable
    public Map<ResourceLocation, Motion> getMotions() {
        return this.motions;
    }

    @Nullable
    public Motion getMotion(ResourceLocation location) {
        if (this.motions == null) {
            return null;
        }
        return this.motions.get(location);
    }
}

