/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.gui.screen.debug;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import dev.felnull.otyacraftengine.client.debug.MotionDebug;
import dev.felnull.otyacraftengine.client.debug.socket.SocketDebugService;
import dev.felnull.otyacraftengine.client.gui.components.BetterEditBox;
import dev.felnull.otyacraftengine.client.gui.components.FixedListWidget;
import dev.felnull.otyacraftengine.client.gui.components.SwitchButton;
import dev.felnull.otyacraftengine.client.gui.screen.OEBaseScreen;
import dev.felnull.otyacraftengine.client.motion.Motion;
import dev.felnull.otyacraftengine.client.motion.MotionPoint;
import dev.felnull.otyacraftengine.client.motion.MotionRotation;
import dev.felnull.otyacraftengine.client.util.OEClientUtil;
import dev.felnull.otyacraftengine.mixin.client.ScreenAccessor;
import dev.felnull.otyacraftengine.util.OEPaths;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionDebugScreen
extends OEBaseScreen {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final SimpleDateFormat saveDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private static final Vector3f lastSocketRotation = new Vector3f();
    private static boolean enableVisible = true;
    public static boolean pause;
    private static boolean socketRotationFixX;
    private static boolean socketRotationFixY;
    private static boolean socketRotationFixZ;
    private static boolean enableEdit;
    private Button editTypeButton;
    private SwitchButton enableEditSwitch;
    private BetterEditBox xEditBox;
    private BetterEditBox yEditBox;
    private BetterEditBox zEditBox;
    private MotionListWidget motionListWidget;
    private Button startButton;
    private Button stopButton;
    private BetterEditBox motionSpeedEditBox;
    private BetterEditBox ratioEditBox;

    public MotionDebugScreen(@Nullable Screen parent) {
        super((Component)new TextComponent("Motion Debug"), parent);
    }

    protected void m_7856_() {
        super.m_7856_();
        Button vib = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 13, 3, 10, 10, (Component)new TextComponent("I"), n -> {
            ScreenAccessor accessor = (ScreenAccessor)((Object)this);
            enableVisible = !enableVisible;
            accessor.getRenderables().forEach(m -> {
                if (m == n) {
                    return;
                }
                if (m instanceof AbstractWidget) {
                    AbstractWidget w = (AbstractWidget)m;
                    w.f_93624_ = enableVisible;
                }
            });
        }));
        Objects.requireNonNull(MotionDebugScreen.mc.f_91062_);
        int st = 3 + 9 * 6 + 2;
        SwitchButton etsw = (SwitchButton)this.m_142416_((GuiEventListener)new SwitchButton(3, st, (Component)new TextComponent("Enable temporary Motion"), n -> this.getMotionDebug().setEnableTemporary(n.isEnable()), true));
        etsw.setEnable(this.getMotionDebug().isEnableTemporary());
        this.xEditBox = (BetterEditBox)this.m_142416_((GuiEventListener)new BetterEditBox(123, st, 50, 12, this.xEditBox, (Component)new TextComponent("x")));
        this.yEditBox = (BetterEditBox)this.m_142416_((GuiEventListener)new BetterEditBox(176, st, 50, 12, this.yEditBox, (Component)new TextComponent("y")));
        this.zEditBox = (BetterEditBox)this.m_142416_((GuiEventListener)new BetterEditBox(229, st, 50, 12, this.zEditBox, (Component)new TextComponent("z")));
        Predicate<String> fpr = n -> {
            try {
                Float.parseFloat(n);
                return true;
            }
            catch (Exception exception) {
                return n.isEmpty();
            }
        };
        this.xEditBox.m_94153_(fpr);
        this.yEditBox.m_94153_(fpr);
        this.zEditBox.m_94153_(fpr);
        this.m_142416_((GuiEventListener)new Button(123, st + 15, 50, 20, (Component)new TextComponent("Input"), n -> {
            Vector3f cm = this.getMotion();
            this.xEditBox.m_94144_(String.valueOf(cm.m_122239_()));
            this.yEditBox.m_94144_(String.valueOf(cm.m_122260_()));
            this.zEditBox.m_94144_(String.valueOf(cm.m_122269_()));
        }));
        this.m_142416_((GuiEventListener)new Button(176, st + 15, 50, 20, (Component)new TextComponent("Output"), n -> {
            if (!(this.xEditBox.m_94155_().isEmpty() || this.yEditBox.m_94155_().isEmpty() || this.zEditBox.m_94155_().isEmpty())) {
                try {
                    float x = Float.parseFloat(this.xEditBox.m_94155_());
                    float y = Float.parseFloat(this.yEditBox.m_94155_());
                    float z = Float.parseFloat(this.zEditBox.m_94155_());
                    this.setMotion(x, y, z);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }));
        this.m_142416_((GuiEventListener)new Button(229, st + 15, 50, 20, (Component)new TextComponent("Copy"), n -> {
            if (!(this.xEditBox.m_94155_().isEmpty() || this.yEditBox.m_94155_().isEmpty() || this.zEditBox.m_94155_().isEmpty())) {
                MotionDebugScreen.mc.f_91068_.m_90911_(String.format("%sf, %sf, %sf", this.xEditBox.m_94155_(), this.yEditBox.m_94155_(), this.zEditBox.m_94155_()));
            }
        }));
        this.m_142416_((GuiEventListener)new Button(123, st + 15 + 23, 50, 20, (Component)new TextComponent("All Copy"), n -> {
            MotionPoint p = this.getMotionDebug().createPoint();
            Vector3f pos = p.getPosition();
            MotionRotation rot = p.getRotation();
            Vector3f ang = rot.angle();
            Vector3f ori = rot.origin();
            Triple<Boolean, Boolean, Boolean> res = rot.reset();
            MotionDebugScreen.mc.f_91068_.m_90911_(String.format("%sf, %sf, %sf, %sf, %sf, %sf, %sf, %sf, %sf, %s, %s, %s", Float.valueOf(pos.m_122239_()), Float.valueOf(pos.m_122260_()), Float.valueOf(pos.m_122269_()), Float.valueOf(ang.m_122239_()), Float.valueOf(ang.m_122260_()), Float.valueOf(ang.m_122269_()), Float.valueOf(ori.m_122239_()), Float.valueOf(ori.m_122260_()), Float.valueOf(ori.m_122269_()), res.getLeft(), res.getMiddle(), res.getLeft()));
        }));
        this.motionListWidget = (MotionListWidget)this.m_142416_((GuiEventListener)new MotionListWidget(this.f_96543_ - 3 - 120, st - 20, 120, 50, 5, this.getMotionDebug().getPoints(), (widget, item) -> {
            MotionPoint e = (MotionPoint)this.motionListWidget.getSelectedEntry();
            if (e != null) {
                this.getMotionDebug().setPoint(e);
            }
        }, this.motionListWidget));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 3 - 120, st + 50 + 3 - 20, 27, 20, (Component)new TextComponent("Add"), n -> {
            MotionPoint ne = this.getMotionDebug().createPoint();
            this.getMotionDebug().getPoints().add(ne);
            this.motionListWidget.setSelectedEntry(this.getMotionDebug().getPoints().size() - 1);
            this.getMotionDebug().setRotationReset(false, false, false);
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 3 - 120 + 30, st + 50 + 3 - 20, 27, 20, (Component)new TextComponent("Del"), n -> {
            MotionPoint e = (MotionPoint)this.motionListWidget.getSelectedEntry();
            if (e != null) {
                int num = this.motionListWidget.getSelectedEntryIndex();
                this.getMotionDebug().getPoints().remove(num);
                this.motionListWidget.setSelectedEntry(num - 1);
            }
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 3 - 120 + 60, st + 50 + 3 - 20, 27, 20, (Component)new TextComponent("Set"), n -> {
            int num = this.motionListWidget.getSelectedEntryIndex();
            this.getMotionDebug().getPoints().set(num, this.getMotionDebug().createPoint());
            this.motionListWidget.setSelectedEntry(num);
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 3 - 120 + 90, st + 50 + 3 - 20, 27, 20, (Component)new TextComponent("Inj"), n -> {
            MotionPoint e = (MotionPoint)this.motionListWidget.getSelectedEntry();
            if (e != null) {
                MotionPoint ne = this.getMotionDebug().createPoint();
                int ei = this.motionListWidget.getSelectedEntryIndex();
                if (ei - 1 >= this.getMotionDebug().getPoints().size()) {
                    this.getMotionDebug().getPoints().add(ne);
                    this.motionListWidget.setSelectedEntry(this.getMotionDebug().getPoints().size() - 1);
                } else {
                    this.getMotionDebug().getPoints().add(ei + 1, ne);
                    this.motionListWidget.setSelectedEntry(ei + 1);
                }
                this.getMotionDebug().setRotationReset(false, false, false);
            }
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 3 - 120, st + 50 + 3 - 20 + 23, 27, 20, (Component)new TextComponent("Output"), n -> {
            if (this.getMotionDebug().getPoints().isEmpty()) {
                return;
            }
            Path pt = OEPaths.getClientOEFolderPath().resolve("debug").resolve("motion");
            pt.toFile().mkdirs();
            Motion motion = this.getMotionDebug().createMotion();
            JsonObject jo = motion.toJson();
            try (FileWriter writer = new FileWriter(pt.resolve(saveDateFormat.format(new Date()) + ".json").toFile());){
                GSON.toJson((JsonElement)jo, (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 3 - 120 + 30, st + 50 + 3 - 20 + 23, 27, 20, (Component)new TextComponent("Input"), n -> {
            File[] files = OEClientUtil.openFileChooser(null, OEPaths.getClientOEFolderPath(), null, false);
            this.loadJson(files);
        }));
        this.startButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 3 - 120 + 60, st + 50 + 3 - 20 + 23, 27, 20, (Component)new TextComponent("Start"), n -> {
            n.f_93623_ = false;
            this.stopButton.f_93623_ = true;
            try {
                String str = this.motionSpeedEditBox.m_94155_();
                long val = str.isEmpty() ? 3000L : Math.max(Long.parseLong(str), 1L);
                this.getMotionDebug().startMotion(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }));
        this.startButton.f_93623_ = !this.getMotionDebug().isMotionPlaying();
        this.stopButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 3 - 120 + 90, st + 50 + 3 - 20 + 23, 27, 20, (Component)new TextComponent("Stop"), n -> {
            n.f_93623_ = false;
            this.startButton.f_93623_ = true;
            this.getMotionDebug().stopMotion();
        }));
        this.stopButton.f_93623_ = this.getMotionDebug().isMotionPlaying();
        this.motionSpeedEditBox = (BetterEditBox)this.m_142416_((GuiEventListener)new BetterEditBox(this.f_96543_ - 3 - 120, st + 50 + 3 - 20 + 23 + 23, 120, 12, this.motionSpeedEditBox, (Component)new TextComponent("Motion Speed")));
        this.motionSpeedEditBox.m_94153_(fpr);
        this.ratioEditBox = (BetterEditBox)this.m_142416_((GuiEventListener)new BetterEditBox(this.f_96543_ - 3 - 120, st + 50 + 3 - 20 + 23 + 23 + 20, 50, 12, this.ratioEditBox, (Component)new TextComponent("Ratio")));
        this.ratioEditBox.m_94153_(fpr);
        this.ratioEditBox.m_94144_(String.valueOf(this.getMotionDebug().getRatio()));
        this.ratioEditBox.m_94151_(n -> {
            try {
                float r = this.ratioEditBox.m_94155_().isEmpty() ? 1.0f : Float.parseFloat(this.ratioEditBox.m_94155_());
                this.getMotionDebug().setRatio(r);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        SwitchButton tsw = (SwitchButton)this.m_142416_((GuiEventListener)new SwitchButton(3, st += 17, (Component)new TextComponent("Edit temporary Motion"), n -> this.getMotionDebug().setEditTemporary(n.isEnable()), true));
        tsw.setEnable(this.getMotionDebug().isEditTemporary());
        this.editTypeButton = (Button)this.m_142416_((GuiEventListener)new Button(3, st += 15, 120, 20, (Component)new TextComponent(this.getMotionDebug().getEditType().name()), n -> this.setNextEditType()));
        this.m_142416_((GuiEventListener)new Button(3, st += 24, 120, 20, (Component)new TextComponent("Reset"), n -> this.getMotionDebug().reset()));
        this.enableEditSwitch = (SwitchButton)this.m_142416_((GuiEventListener)new SwitchButton(3, st += 24, (Component)new TextComponent("Enable Edit"), n -> {
            enableEdit = n.isEnable();
        }, true));
        this.enableEditSwitch.setEnable(enableEdit);
        SwitchButton srswfx = (SwitchButton)this.m_142416_((GuiEventListener)new SwitchButton(3, st += 17, (Component)new TextComponent("Socket Rotation Fix X"), n -> {
            socketRotationFixX = n.isEnable();
        }, true));
        srswfx.setEnable(socketRotationFixX);
        SwitchButton srswfy = (SwitchButton)this.m_142416_((GuiEventListener)new SwitchButton(3, st += 17, (Component)new TextComponent("Socket Rotation Fix Y"), n -> {
            socketRotationFixY = n.isEnable();
        }, true));
        srswfy.setEnable(socketRotationFixY);
        SwitchButton srswfz = (SwitchButton)this.m_142416_((GuiEventListener)new SwitchButton(3, st += 17, (Component)new TextComponent("Socket Rotation Fix Z"), n -> {
            socketRotationFixZ = n.isEnable();
        }, true));
        srswfz.setEnable(socketRotationFixZ);
        this.m_142416_((GuiEventListener)new Button(3, st += 15, 40, 20, (Component)new TextComponent("Reset X"), n -> {
            Triple<Boolean, Boolean, Boolean> o = this.getMotionDebug().getRotation().reset();
            this.getMotionDebug().setRotationReset(true, (Boolean)o.getMiddle(), (Boolean)o.getRight());
            Vector3f oa = this.getMotionDebug().getRotation().angle();
            this.getMotionDebug().setRotationAngle(new Vector3f(oa.m_122239_() % 360.0f, oa.m_122260_(), oa.m_122269_()));
        }));
        this.m_142416_((GuiEventListener)new Button(46, st, 40, 20, (Component)new TextComponent("Reset Y"), n -> {
            Triple<Boolean, Boolean, Boolean> o = this.getMotionDebug().getRotation().reset();
            this.getMotionDebug().setRotationReset((Boolean)o.getLeft(), true, (Boolean)o.getRight());
            Vector3f oa = this.getMotionDebug().getRotation().angle();
            this.getMotionDebug().setRotationAngle(new Vector3f(oa.m_122239_(), oa.m_122260_() % 360.0f, oa.m_122269_()));
        }));
        this.m_142416_((GuiEventListener)new Button(89, st, 40, 20, (Component)new TextComponent("Reset Z"), n -> {
            Triple<Boolean, Boolean, Boolean> o = this.getMotionDebug().getRotation().reset();
            this.getMotionDebug().setRotationReset((Boolean)o.getLeft(), (Boolean)o.getMiddle(), true);
            Vector3f oa = this.getMotionDebug().getRotation().angle();
            this.getMotionDebug().setRotationAngle(new Vector3f(oa.m_122239_(), oa.m_122260_(), oa.m_122269_() % 360.0f));
        }));
        SwitchButton fosw = (SwitchButton)this.m_142416_((GuiEventListener)new SwitchButton(3, st += 24, (Component)new TextComponent("Fix Origin"), n -> this.getMotionDebug().setFixOrigin(n.isEnable()), true));
        fosw.setEnable(this.getMotionDebug().isFixOrigin());
        SwitchButton sosw = (SwitchButton)this.m_142416_((GuiEventListener)new SwitchButton(3, st += 17, (Component)new TextComponent("Show Origin"), n -> this.getMotionDebug().setShowOrigin(n.isEnable()), true));
        sosw.setEnable(this.getMotionDebug().isShowOrigin());
        ScreenAccessor sca = (ScreenAccessor)((Object)this);
        sca.getRenderables().forEach(n -> {
            if (n == vib) {
                return;
            }
            if (n instanceof AbstractWidget) {
                AbstractWidget w = (AbstractWidget)n;
                w.f_93624_ = enableVisible;
            }
        });
    }

    protected void loadJson(File[] files) {
        if (files == null || files.length != 1) {
            return;
        }
        File fil = files[0];
        JsonObject jo = null;
        try (FileReader reader = new FileReader(fil);){
            jo = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (jo == null) {
            return;
        }
        this.getMotionDebug().setMotion(Motion.of(jo));
        this.motionListWidget.setSelectedEntry(0);
    }

    public void setNextEditType() {
        MotionDebug.EditType et = this.getMotionDebug().getEditType();
        this.getMotionDebug().setEditType(MotionDebug.EditType.values()[(et.ordinal() + 1) % MotionDebug.EditType.values().length]);
        this.editTypeButton.m_93666_((Component)new TextComponent(this.getMotionDebug().getEditType().name()));
    }

    public boolean m_7933_(int i, int j, int k) {
        if (i == 82) {
            this.setNextEditType();
            return true;
        }
        if (i == 87) {
            enableEdit = !enableEdit;
            this.enableEditSwitch.setEnable(enableEdit);
            return true;
        }
        if (enableEdit) {
            boolean sflg = OEClientUtil.isKeyInput(MotionDebugScreen.mc.f_91066_.f_92090_);
            if (i == 263) {
                this.addMotion(0.0f, -1.0f, 0.0f);
                return true;
            }
            if (i == 262) {
                this.addMotion(0.0f, 1.0f, 0.0f);
                return true;
            }
            if (i == 265) {
                if (sflg) {
                    this.addMotion(0.0f, 0.0f, -1.0f);
                } else {
                    this.addMotion(-1.0f, 0.0f, 0.0f);
                }
                return true;
            }
            if (i == 264) {
                if (sflg) {
                    this.addMotion(0.0f, 0.0f, 1.0f);
                } else {
                    this.addMotion(1.0f, 0.0f, 0.0f);
                }
                return true;
            }
        }
        return super.m_7933_(i, j, k);
    }

    public void m_6305_(@NotNull PoseStack poseStack, int x, int y, float f) {
        if (enableVisible) {
            this.m_7333_(poseStack);
        }
        super.m_6305_(poseStack, x, y, f);
        this.drawTextBase(poseStack, MotionDebugScreen.mc.f_90977_, 3, 3, 0xFFFFFF);
        String string = "Motion Point - " + MotionDebugScreen.createMotionText(this.getMotionDebug().getPosition(), this.getMotionDebug().getRotation().angle(), this.getMotionDebug().getRotation().origin());
        Objects.requireNonNull(MotionDebugScreen.mc.f_91062_);
        this.drawTextBase(poseStack, string, 3, 3 + 9, 0xFFFFFF);
        Triple<Boolean, Boolean, Boolean> reset = this.getMotionDebug().getRotation().reset();
        String string2 = String.format("Reset: [X: %s, Y: %s, Z: %s]", (Boolean)reset.getLeft() != false ? "T" : "F", (Boolean)reset.getMiddle() != false ? "T" : "F", (Boolean)reset.getRight() != false ? "T" : "F");
        Objects.requireNonNull(MotionDebugScreen.mc.f_91062_);
        this.drawTextBase(poseStack, string2, 3, 3 + 9 * 2, 0xFFFFFF);
        String string3 = "Temporary - " + MotionDebugScreen.createMotionText(this.getMotionDebug().getTemporaryPosition(), this.getMotionDebug().getTemporaryRotation().angle(), this.getMotionDebug().getTemporaryRotation().origin());
        Objects.requireNonNull(MotionDebugScreen.mc.f_91062_);
        this.drawTextBase(poseStack, string3, 3, 3 + 9 * 3, 0xFFFFFF);
        String string4 = "Sensitivity: " + this.getMotionDebug().getSensitivity();
        Objects.requireNonNull(MotionDebugScreen.mc.f_91062_);
        this.drawTextBase(poseStack, string4, 3, 3 + 9 * 4, 0xFFFFFF);
        Vector3f spos = SocketDebugService.getPosition(f);
        Vector3f srot = SocketDebugService.getAngele(f);
        String string5 = !SocketDebugService.isConnected() ? "Socket - Not connected" : String.format("Socket - Pos: [X: %s  Y: %s  Z: %s], Rot: [X: %s, Y: %s, Z: %s]", (int)spos.m_122239_(), (int)spos.m_122260_(), (int)spos.m_122269_(), (int)srot.m_122239_(), (int)srot.m_122260_(), (int)srot.m_122269_());
        Objects.requireNonNull(MotionDebugScreen.mc.f_91062_);
        this.drawTextBase(poseStack, string5, 3, 3 + 9 * 5, 0xFFFFFF);
    }

    public void m_96624_() {
        super.m_96624_();
        if (!enableEdit) {
            return;
        }
        Vector3f sr = SocketDebugService.getAngele(0.0f);
        Vector3f sa = new Vector3f(lastSocketRotation.m_122239_() - sr.m_122239_(), lastSocketRotation.m_122260_() - sr.m_122260_(), lastSocketRotation.m_122269_() - sr.m_122269_());
        float vx = 0.0f;
        float vy = 0.0f;
        float vz = 0.0f;
        if (!socketRotationFixX) {
            vx = sa.m_122260_();
        }
        if (!socketRotationFixY) {
            vy = -sa.m_122239_();
        }
        if (!socketRotationFixZ) {
            vz = sa.m_122269_();
        }
        this.getMotionDebug().addRotationAngle(vx, vy, vz);
        lastSocketRotation.m_122245_(sr.m_122239_(), sr.m_122260_(), sr.m_122269_());
    }

    public boolean m_7979_(double d, double e, int i, double f, double g) {
        if (!this.isHoveredWidget((float)d, (float)e) && enableEdit) {
            boolean l;
            boolean bl = l = i == 0;
            if (l) {
                this.addMotion((float)g, (float)f, 0.0f);
            } else {
                this.addMotion(0.0f, (float)f, (float)g);
            }
        }
        return super.m_7979_(d, e, i, f, g);
    }

    public boolean m_6050_(double x, double y, double f) {
        if (!this.isHoveredWidget((float)x, (float)y)) {
            float v = this.getMotionDebug().getSensitivity();
            if (OEClientUtil.isKeyInput(MotionDebugScreen.mc.f_91066_.f_92090_)) {
                f *= (double)0.1f;
            }
            v = (float)((double)v + f * (double)0.1f);
            this.getMotionDebug().setSensitivity(Math.max(v, 0.0f));
        }
        return super.m_6050_(x, y, f);
    }

    private boolean isHoveredWidget(float x, float y) {
        ScreenAccessor sa = (ScreenAccessor)((Object)this);
        return sa.getRenderables().stream().filter(n -> n instanceof AbstractWidget).map(n -> (AbstractWidget)n).filter(n -> x >= (float)n.f_93620_ && y >= (float)n.f_93621_ && x < (float)(n.f_93620_ + n.m_5711_()) && (double)y < (double)(n.f_93621_ + n.m_93694_())).anyMatch(n -> true);
    }

    private void setMotion(float x, float y, float z) {
        switch (this.getMotionDebug().getEditType()) {
            case POSITION: {
                this.getMotionDebug().setPosition(new Vector3f(x, y, z));
                break;
            }
            case ROTATION: {
                this.getMotionDebug().setRotationAngle(new Vector3f(x, y, z));
                break;
            }
            case ROTATION_ORIGIN: {
                this.getMotionDebug().setRotationOrigin(new Vector3f(x, y, z));
            }
        }
    }

    private Vector3f getMotion() {
        return switch (this.getMotionDebug().getEditType()) {
            default -> throw new IncompatibleClassChangeError();
            case MotionDebug.EditType.POSITION -> this.getMotionDebug().getPosition();
            case MotionDebug.EditType.ROTATION -> this.getMotionDebug().getRotation().angle();
            case MotionDebug.EditType.ROTATION_ORIGIN -> this.getMotionDebug().getRotation().origin();
        };
    }

    private void addMotion(float x, float y, float z) {
        float sc = this.getMotionDebug().getSensitivity();
        x *= sc;
        y *= sc;
        z *= sc;
        if (this.getMotionDebug().isEditTemporary()) {
            switch (this.getMotionDebug().getEditType()) {
                case POSITION: {
                    this.getMotionDebug().addTemporaryPosition(y * 0.05f, -x * 0.05f, z * 0.05f);
                    break;
                }
                case ROTATION: {
                    this.getMotionDebug().addTemporaryRotationAngle(-x, -y, -z);
                    break;
                }
                case ROTATION_ORIGIN: {
                    this.getMotionDebug().addRotationOrigin(y * 0.05f, -x * 0.05f, z * 0.05f);
                }
            }
        } else {
            switch (this.getMotionDebug().getEditType()) {
                case POSITION: {
                    this.getMotionDebug().addPosition(y * 0.05f, -x * 0.05f, z * 0.05f);
                    break;
                }
                case ROTATION: {
                    this.getMotionDebug().addRotationAngle(-x, -y, -z);
                    break;
                }
                case ROTATION_ORIGIN: {
                    this.getMotionDebug().addRotationOrigin(y * 0.05f, -x * 0.05f, z * 0.05f);
                }
            }
        }
    }

    private MotionDebug getMotionDebug() {
        return MotionDebug.getInstance();
    }

    private static String createMotionText(Vector3f pos, Vector3f angle, Vector3f origin) {
        return String.format("Pos: [X: %s  Y: %s  Z: %s], Angle: [X: %s, Y: %s, Z: %s], Origin: [X: %s, Y: %s, Z: %s]", Float.valueOf(pos.m_122239_()), Float.valueOf(pos.m_122260_()), Float.valueOf(pos.m_122269_()), Float.valueOf(angle.m_122239_()), Float.valueOf(angle.m_122260_()), Float.valueOf(angle.m_122269_()), Float.valueOf(origin.m_122239_()), Float.valueOf(origin.m_122260_()), Float.valueOf(origin.m_122269_()));
    }

    public boolean m_7043_() {
        return pause;
    }

    static {
        socketRotationFixX = true;
        socketRotationFixY = true;
        socketRotationFixZ = true;
        enableEdit = true;
    }

    private static class MotionListWidget
    extends FixedListWidget<MotionPoint> {
        public MotionListWidget(int x, int y, int width, int height, int entryShowCount, @NotNull List<MotionPoint> entryList, @Nullable FixedListWidget.PressEntry<MotionPoint> onPressEntry, MotionListWidget old) {
            super(x, y, width, height, (Component)new TextComponent("Motion List"), entryShowCount, entryList, MotionPoint::getText, onPressEntry, true, old);
        }
    }
}

