package dev.felnull.otyacraftengine.client.motion;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;

public record MotionPose(Vector3f position, MotionRotation rotation) {
    public void pose(PoseStack stack) {
        pose(stack, false);
    }

    public void pose(PoseStack stack, boolean revers) {
        float r = revers ? -1f : 1f;
        stack.translate(r * position.x(), position.y(), position.z());
        rotation.pose(stack, revers);
    }
}
