/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.motion;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import dev.felnull.otyacraftengine.client.motion.MotionPose;
import dev.felnull.otyacraftengine.client.motion.MotionRotation;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class MotionPoint {
    private final Vector3f position;
    private final MotionRotation rotation;
    private final float ratio;

    public MotionPoint(float px, float py, float pz, float ax, float ay, float az, float ox, float oy, float oz, boolean rx, boolean ry, boolean rz) {
        this(new Vector3f(px, py, pz), new MotionRotation(ax, ay, az, ox, oy, oz, rx, ry, rz));
    }

    public MotionPoint(Vector3f position, MotionRotation rotation) {
        this(position, rotation, 1.0f);
    }

    public MotionPoint(Vector3f position, MotionRotation rotation, float ratio) {
        this.position = position;
        this.rotation = rotation;
        this.ratio = ratio;
    }

    public static MotionPoint of(JsonObject jo) {
        JsonArray pos = jo.getAsJsonArray("pos");
        JsonElement jr = jo.get("rat");
        float rat = 1.0f;
        if (jr != null) {
            rat = jr.getAsFloat();
        }
        return new MotionPoint(new Vector3f(pos.get(0).getAsFloat(), pos.get(1).getAsFloat(), pos.get(2).getAsFloat()), MotionRotation.of(jo.getAsJsonObject("rot")), rat);
    }

    public JsonObject toJson() {
        JsonObject jo = new JsonObject();
        JsonArray p = new JsonArray();
        p.add((Number)Float.valueOf(this.position.m_122239_()));
        p.add((Number)Float.valueOf(this.position.m_122260_()));
        p.add((Number)Float.valueOf(this.position.m_122269_()));
        jo.add("pos", (JsonElement)p);
        jo.add("rot", (JsonElement)this.rotation.toJson());
        if (this.ratio != 1.0f) {
            jo.addProperty("rat", (Number)Float.valueOf(this.ratio));
        }
        return jo;
    }

    public MotionRotation getRotation() {
        return this.rotation;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public float getRatio() {
        return this.ratio;
    }

    public Component getText() {
        return new TextComponent(String.format("%s [%s,%s,%s] [%s,%s,%s]", Float.valueOf(this.ratio), Float.valueOf(this.position.m_122239_()), Float.valueOf(this.position.m_122260_()), Float.valueOf(this.position.m_122269_()), Float.valueOf(this.rotation.angle().m_122239_()), Float.valueOf(this.rotation.angle().m_122260_()), Float.valueOf(this.rotation.angle().m_122269_())));
    }

    public MotionPose getPose() {
        return new MotionPose(new Vector3f(this.position.m_122239_(), this.position.m_122260_(), this.position.m_122269_()), this.rotation);
    }

    public String toString() {
        return "MotionPoint{position=" + this.position + ", rotation=" + this.rotation + ", ratio=" + this.ratio + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MotionPoint that = (MotionPoint)o;
        return Float.compare(that.ratio, this.ratio) == 0 && Objects.equals(this.position, that.position) && Objects.equals(this.rotation, that.rotation);
    }

    public int hashCode() {
        return Objects.hash(this.position, this.rotation, Float.valueOf(this.ratio));
    }
}

