/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.block;

import dev.felnull.otyacraftengine.blockentity.ItemDroppedBlockEntity;
import dev.felnull.otyacraftengine.blockentity.OEBaseContainerBlockEntity;
import dev.felnull.otyacraftengine.util.OEMenuUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class OEBaseEntityBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final ResourceLocation CONTENTS = new ResourceLocation("contents");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private boolean analogOutput;

    protected OEBaseEntityBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (itemStack.m_41788_() && (blockEntity = level.m_7702_(blockPos)) instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity container = (BaseContainerBlockEntity)blockEntity;
            container.m_58638_(itemStack.m_41786_());
        }
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (!blockState.m_60713_(blockState2.m_60734_())) {
            BlockEntity be = level.m_7702_(blockPos);
            if (level instanceof ServerLevel) {
                if (be instanceof ItemDroppedBlockEntity) {
                    ItemDroppedBlockEntity itemDroppedBlock = (ItemDroppedBlockEntity)be;
                    if (!itemDroppedBlock.isRetainDrop()) {
                        Containers.m_19010_((Level)level, (BlockPos)blockPos, itemDroppedBlock.getDroppedItems());
                    }
                } else if (be instanceof Container) {
                    Container container = (Container)be;
                    Containers.m_19002_((Level)level, (BlockPos)blockPos, (Container)container);
                }
            }
            if (be instanceof Container && this.analogOutput) {
                level.m_46717_(blockPos, (Block)this);
            }
        }
        super.m_6810_(blockState, level, blockPos, blockState2, bl);
    }

    public void m_5707_(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        ItemDroppedBlockEntity itemDroppedBlock;
        BlockEntity be = level.m_7702_(blockPos);
        if (be instanceof ItemDroppedBlockEntity && (itemDroppedBlock = (ItemDroppedBlockEntity)be).isRetainDrop() && !level.f_46443_ && player.m_7500_() && !itemDroppedBlock.isRetainEmpty()) {
            BaseContainerBlockEntity named;
            ItemStack itemStack = itemDroppedBlock.createRetainDropItem();
            if (be instanceof BaseContainerBlockEntity && (named = (BaseContainerBlockEntity)be).m_8077_()) {
                itemStack.m_41714_(named.m_7770_());
            }
            ItemEntity itemEntity = new ItemEntity(level, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, itemStack);
            itemEntity.m_32060_();
            level.m_7967_((Entity)itemEntity);
        }
        super.m_5707_(level, blockPos, blockState, player);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        this.openContainer(level, blockPos, (ServerPlayer)player, blockState, blockHitResult.m_82434_());
        return InteractionResult.CONSUME;
    }

    protected void openContainer(Level level, BlockPos blockPos, ServerPlayer player, BlockState blockState, Direction direction) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof OEBaseContainerBlockEntity) {
            OEBaseContainerBlockEntity oeBaseContainerBlock = (OEBaseContainerBlockEntity)blockEntity;
            OEMenuUtil.openBlockMenu(player, (MenuProvider)oeBaseContainerBlock, blockPos, oeBaseContainerBlock.m_6643_());
        }
    }

    public boolean m_7278_(BlockState blockState) {
        return this.analogOutput;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos blockPos) {
        if (!this.analogOutput) {
            return super.m_6782_(blockState, level, blockPos);
        }
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(blockPos));
    }

    public void setAnalogOutput(boolean enable) {
        this.analogOutput = enable;
    }

    public boolean m_7420_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) == false;
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        FluidState fluidState = blockPlaceContext.m_43725_().m_6425_(blockPlaceContext.m_8083_());
        return (BlockState)super.m_5573_(blockPlaceContext).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public List<ItemStack> m_7381_(BlockState blockState, LootContext.Builder builder) {
        ItemDroppedBlockEntity icbe;
        BlockEntity blockEntity = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (blockEntity instanceof ItemDroppedBlockEntity && (icbe = (ItemDroppedBlockEntity)blockEntity).isRetainDrop()) {
            return List.of(icbe.createRetainDropItem());
        }
        return super.m_7381_(blockState, builder);
    }
}

