package dev.felnull.otyacraftengine.block;

import dev.felnull.otyacraftengine.blockentity.ItemDroppedBlockEntity;
import dev.felnull.otyacraftengine.blockentity.OEBaseContainerBlockEntity;
import dev.felnull.otyacraftengine.util.OEMenuUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.List;

public abstract class OEBaseEntityBlock extends BaseEntityBlock implements SimpleWaterloggedBlock {
    public static final ResourceLocation CONTENTS = new ResourceLocation("contents");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private boolean analogOutput;

    protected OEBaseEntityBlock(Properties properties) {
        super(properties);
        this.m_49959_(this.f_49792_.m_61090_().m_61124_(WATERLOGGED, false));
    }

    @Override
    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        if (itemStack.m_41788_()) {
            if (level.m_7702_(blockPos) instanceof BaseContainerBlockEntity container) {
                container.m_58638_(itemStack.m_41786_());
            }
        }
    }

    @Override
    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (!blockState.m_60713_(blockState2.m_60734_())) {
            var be = level.m_7702_(blockPos);
            if (level instanceof ServerLevel) {
                if (be instanceof ItemDroppedBlockEntity itemDroppedBlock) {
                    if (!itemDroppedBlock.isRetainDrop())
                        Containers.m_19010_(level, blockPos, itemDroppedBlock.getDroppedItems());
                } else if (be instanceof Container container) {
                    Containers.m_19002_(level, blockPos, container);
                }
            }
            if (be instanceof Container && analogOutput)
                level.m_46717_(blockPos, this);

        }
        super.m_6810_(blockState, level, blockPos, blockState2, bl);
    }


    @Override
    public void m_5707_(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        var be = level.m_7702_(blockPos);
        if (be instanceof ItemDroppedBlockEntity itemDroppedBlock && itemDroppedBlock.isRetainDrop()) {
            if (!level.f_46443_ && player.m_7500_() && !itemDroppedBlock.isRetainEmpty()) {
                var itemStack = itemDroppedBlock.createRetainDropItem();

                if (be instanceof BaseContainerBlockEntity named) {
                    if (named.m_8077_())
                        itemStack.setHoverName(named.m_7770_());
                }

                ItemEntity itemEntity = new ItemEntity(level, (double) blockPos.m_123341_() + 0.5D, (double) blockPos.m_123342_() + 0.5D, (double) blockPos.m_123343_() + 0.5D, itemStack);
                itemEntity.m_32060_();
                level.m_7967_(itemEntity);
            }
        }
        super.m_5707_(level, blockPos, blockState, player);
    }

    @Override
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        } else {
            this.openContainer(level, blockPos, (ServerPlayer) player, blockState, blockHitResult.m_82434_());
            return InteractionResult.CONSUME;
        }
    }

    protected void openContainer(Level level, BlockPos blockPos, ServerPlayer player, BlockState blockState, Direction direction) {
        if (level.m_7702_(blockPos) instanceof OEBaseContainerBlockEntity oeBaseContainerBlock)
            OEMenuUtil.openBlockMenu(player, oeBaseContainerBlock, blockPos, oeBaseContainerBlock.m_6643_());
    }

    @Override
    public boolean m_7278_(BlockState blockState) {
        return analogOutput;
    }

    @Override
    public int m_6782_(BlockState blockState, Level level, BlockPos blockPos) {
        if (!analogOutput)
            return super.m_6782_(blockState, level, blockPos);
        return AbstractContainerMenu.m_38918_(level.m_7702_(blockPos));
    }

    public void setAnalogOutput(boolean enable) {
        this.analogOutput = enable;
    }

    @Override
    public boolean m_7420_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return !blockState.m_61143_(WATERLOGGED);
    }

    @Override
    public FluidState m_5888_(BlockState blockState) {
        return blockState.m_61143_(WATERLOGGED) ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    @Override
    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (blockState.m_61143_(WATERLOGGED)) {
            levelAccessor.m_186469_(blockPos, Fluids.f_76193_, Fluids.f_76193_.m_6718_(levelAccessor));
        }
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    @Nullable
    @Override
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        FluidState fluidState = blockPlaceContext.m_43725_().m_6425_(blockPlaceContext.m_8083_());
        return super.m_5573_(blockPlaceContext).m_61124_(WATERLOGGED, fluidState.m_76152_() == Fluids.f_76193_);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(WATERLOGGED);
    }

    @Override
    public List<ItemStack> m_7381_(BlockState blockState, LootContext.Builder builder) {
        BlockEntity blockEntity = builder.m_78982_(LootContextParams.f_81462_);
        if (blockEntity instanceof ItemDroppedBlockEntity icbe && icbe.isRetainDrop())
            return List.of(icbe.createRetainDropItem());
        return super.m_7381_(blockState, builder);
    }
}
