/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.felnull.otyacraftengine.client.debug.MotionDebug;
import dev.felnull.otyacraftengine.client.debug.socket.SocketDebugService;
import dev.felnull.otyacraftengine.client.event.ClientEvent;
import dev.felnull.otyacraftengine.client.event.MoreRenderEvent;
import dev.felnull.otyacraftengine.client.gui.components.FixedButtonsList;
import dev.felnull.otyacraftengine.client.gui.screen.DebugScreen;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import dev.felnull.otyacraftengine.impl.client.OEClientExpectPlatform;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.EnderEyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class TestClientHandler {
    public static final KeyMapping TEST_KEY = new KeyMapping("key.otyacraftengine.test", 74, "key.categories.otyacraftengine");
    private static final Minecraft mc = Minecraft.m_91087_();

    public static void init() {
        ClientRawInputEvent.KEY_PRESSED.register(TestClientHandler::onKeyPressed);
        MoreRenderEvent.RENDER_ITEM_IN_HAND.register(TestClientHandler::onRenderHand);
        ClientEvent.CHANGE_HAND_HEIGHT.register(TestClientHandler::changeHandHeight);
        ClientEvent.POSE_HUMANOID_ARM.register(TestClientHandler::poseHumanoidArm);
        KeyMappingRegistry.register((KeyMapping)TEST_KEY);
        MoreRenderEvent.RENDER_ARM_WITH_ITEM.register(TestClientHandler::renderArmWithItem);
        ClientEvent.INTEGRATED_SERVER_PAUSE.register(TestClientHandler::onIntegratedPauseChange);
        ClientTickEvent.CLIENT_POST.register(TestClientHandler::ontClientTick);
        ClientEvent.HAND_ATTACK.register(TestClientHandler::onHandAttack);
        ClientEvent.EVALUATE_RENDER_HANDS.register(TestClientHandler::onEvaluateRenderHands);
    }

    private static void onEvaluateRenderHands(ClientEvent.HandRenderSelectionWrapper handRenderSelection, LocalPlayer player, ClientEvent.EvaluateRenderHandSetter setter) {
        if (player.m_21205_().m_150930_(Items.f_42545_)) {
            setter.setEvaluate(ClientEvent.HandRenderSelectionWrapper.onlyForHand(InteractionHand.MAIN_HAND));
        }
    }

    private static EventResult onHandAttack(ItemStack itemStack) {
        return EventResult.pass();
    }

    private static void ontClientTick(Minecraft instance) {
        SocketDebugService.tick();
    }

    public static void onIntegratedPauseChange(boolean paused) {
    }

    public static EventResult onKeyPressed(Minecraft client, int keyCode, int scanCode, int action, int modifiers) {
        if (keyCode == OEClientExpectPlatform.getKey(TEST_KEY).m_84873_()) {
            client.m_91152_((Screen)new DebugScreen());
        }
        return EventResult.interruptDefault();
    }

    public static EventResult onRenderHand(PoseStack poseStack, MultiBufferSource multiBufferSource, InteractionHand hand, int packedLight, float partialTicks, float interpolatedPitch, float swingProgress, float equipProgress, ItemStack stack) {
        if (stack.m_41720_() instanceof EnderEyeItem) {
            boolean bl = hand == InteractionHand.MAIN_HAND;
            HumanoidArm arm = bl ? TestClientHandler.mc.f_91074_.m_5737_() : TestClientHandler.mc.f_91074_.m_5737_().m_20828_();
            poseStack.m_85836_();
            MotionDebug.getInstance().onDebug(poseStack, multiBufferSource, 0.5f);
            poseStack.m_85836_();
            OERenderUtil.posePlayerArm(poseStack, arm, swingProgress, equipProgress);
            OERenderUtil.renderPlayerArm(poseStack, multiBufferSource, arm, packedLight);
            poseStack.m_85849_();
            poseStack.m_85836_();
            OERenderUtil.poseHandItem(poseStack, arm, swingProgress, equipProgress);
            OERenderUtil.renderHandItem(poseStack, multiBufferSource, arm, stack, packedLight);
            poseStack.m_85849_();
            poseStack.m_85849_();
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public static EventResult changeHandHeight(InteractionHand hand, ItemStack oldStack, ItemStack newStack) {
        return EventResult.pass();
    }

    public static EventResult poseHumanoidArm(HumanoidArm arm, InteractionHand hand, HumanoidModel<? extends LivingEntity> model, LivingEntity livingEntity) {
        return EventResult.pass();
    }

    public static EventResult renderArmWithItem(ItemInHandLayer<? extends LivingEntity, ? extends EntityModel<?>> layer, LivingEntity livingEntity, ItemStack itemStack, ItemTransforms.TransformType transformType, HumanoidArm humanoidArm, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        return EventResult.pass();
    }

    private record MotionPoint(Vector3f position, Vector3f rotation, Vector3f scale) {
    }

    private static class PointFixedButtonsList
    extends FixedButtonsList<MotionPoint> {
        public PointFixedButtonsList(int x, int y, int w, int h, ResourceLocation resource, int tx, int ty, int tw, int th, int num, Component name, List<MotionPoint> list, Function<MotionPoint, Component> listName, FixedButtonsList.PressEntry<MotionPoint> onPressEntry) {
            super(x, y, w, h, resource, tx, ty, tw, th, num, name, list, listName, onPressEntry);
        }
    }
}

