package dev.felnull.otyacraftengine.client.gui.components;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.otyacraftengine.client.gui.TextureSpecifyLocation;
import dev.felnull.otyacraftengine.client.gui.components.base.OEBaseImageWidget;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;

public class SwitchButton extends OEBaseImageWidget {
    @Nullable
    private final Consumer<SwitchButton> onPress;
    private boolean showLabel;
    private boolean enable;

    public SwitchButton(int x, int y, @NotNull Component message, @Nullable Consumer<SwitchButton> onPress, boolean showLabel) {
        this(x, y, message, onPress, showLabel, new TextureSpecifyLocation(WIDGETS, 40, 0, 40, 34));
    }

    public SwitchButton(int x, int y, @NotNull Component message, @Nullable Consumer<SwitchButton> onPress, boolean showLabel, @NotNull TextureSpecifyLocation texture) {
        super(x, y, 20, 10, "switchButton", message, texture);
        this.onPress = onPress;
        this.showLabel = showLabel;
    }

    @Override
    public void m_6303_(@NotNull PoseStack poseStack, int i, int j, float f) {
        OERenderUtil.drawTexture(texture.location(), poseStack, f_93620_, f_93621_, texture.x() + (this.m_198029_() ? 20 : 0), texture.y() + (this.enable ? 10 : 0), 20, 10, texture.sizeWidth(), texture.sizeHeight());
        OERenderUtil.drawTexture(texture.location(), poseStack, f_93620_ + (this.enable ? (f_93618_ - 8) : 0), f_93621_ - 2, texture.x() + (this.m_198029_() ? 8 : 0), texture.y() + 20, 8, 14, texture.sizeWidth(), texture.sizeHeight());
        this.m_7906_(poseStack, mc, i, j);
        if (this.showLabel)
            drawTextBase(poseStack, this.m_6035_(), this.f_93620_ + 24, this.f_93621_ + (this.f_93619_ - 8) / 2, 14737632 | Mth.m_14167_(this.f_93625_ * 255.0F) << 24);
    }

    @Override
    public void onPress() {
        this.enable = !this.enable;
        if (onPress != null)
            this.onPress.accept(this);
    }

    public boolean isShowLabel() {
        return showLabel;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public boolean isEnable() {
        return enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }
}
