package dev.felnull.otyacraftengine.mixin.client;


import dev.felnull.otyacraftengine.client.event.OEClientEventHooks;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import var;

@Mixin(HumanoidModel.class)
public class HumanoidModelMixin<T extends LivingEntity> {
    @Inject(method = "poseRightArm", at = @At("HEAD"), cancellable = true)
    private void poseRightArm(T livingEntity, CallbackInfo ci) {
        var hand = livingEntity.m_5737_() == HumanoidArm.RIGHT ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        if (!OEClientEventHooks.onPoseHumanoidArm(HumanoidArm.RIGHT, hand, (HumanoidModel<T>) (Object) this, livingEntity))
            ci.cancel();
    }

    @Inject(method = "poseLeftArm", at = @At("HEAD"), cancellable = true)
    private void poseLeftArm(T livingEntity, CallbackInfo ci) {
        var hand = livingEntity.m_5737_() == HumanoidArm.LEFT ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        if (!OEClientEventHooks.onPoseHumanoidArm(HumanoidArm.LEFT, hand, (HumanoidModel<T>) (Object) this, livingEntity))
            ci.cancel();
    }

    @Inject(method = "poseRightArm", at = @At("TAIL"))
    private void poseRightArmPost(T livingEntity, CallbackInfo ci) {
        var hand = livingEntity.m_5737_() == HumanoidArm.RIGHT ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        OEClientEventHooks.onPoseHumanoidArmPost(HumanoidArm.RIGHT, hand, (HumanoidModel<T>) (Object) this, livingEntity);
    }


    @Inject(method = "poseLeftArm", at = @At("TAIL"))
    private void poseLeftArmPost(T livingEntity, CallbackInfo ci) {
        var hand = livingEntity.m_5737_() == HumanoidArm.LEFT ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        OEClientEventHooks.onPoseHumanoidArmPost(HumanoidArm.LEFT, hand, (HumanoidModel<T>) (Object) this, livingEntity);
    }
}

