package dev.felnull.otyacraftengine.util;

import com.google.common.collect.Lists;
import dev.felnull.otyacraftengine.impl.OEExpectPlatform;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.Level;
import var;
import java.util.ArrayList;
import java.util.List;

public class OEItemUtil {
    public static EntityType<?> getMobBucketEntity(MobBucketItem item) {
        return OEExpectPlatform.getMobBucketEntity(item);
    }

    public static ItemStack copyStackSetSize(ItemStack itemStack, int size) {
        if (size == 0)
            return ItemStack.f_41583_;
        ItemStack copy = itemStack.m_41777_();
        copy.m_41764_(size);
        return copy;
    }

    public static ItemStack createPlayerHead(String name) {
        ItemStack playerhead = new ItemStack(Items.f_42680_);
        CompoundTag tag = playerhead.m_41784_();
        tag.m_128359_("SkullOwner", name);
        return playerhead;
    }

    public static ItemStack createMoriMoriHead() {
        return createPlayerHead("MoriMori_0317_jp");
    }

    public static ItemStack createKamesutaHead() {
        return createPlayerHead("kamesuta");
    }

    public static ItemStack createNinHead() {
        return createPlayerHead("nin8995");
    }

    public static ItemStack createMGHead() {
        return createPlayerHead("MultiGamer8853");
    }

    public static ItemStack createMiyabiHead() {
        return createPlayerHead("miyabi0333");
    }

    public static ItemStack createYuuHead() {
        return createPlayerHead("yuu_111");
    }

    public static ItemStack createPlayerHead(Player player) {
        return createPlayerHead(player.m_36316_().getName());
    }

    public static ItemEntity createItemEntity(ItemStack item, Level level, double x, double y, double z) {
        ItemEntity iteme = new ItemEntity(level, x, y, z, item);
        iteme.m_32060_();
        return iteme;
    }

    public static ItemEntity spawnItemEntity(ItemStack item, Level level, double x, double y, double z) {
        ItemEntity entity = createItemEntity(item, level, x, y, z);
        level.m_7967_(entity);
        return entity;
    }

    public static List<ItemStack> divideItemStack(ItemStack stack, int cont) {
        if (stack.m_41619_()) return Lists.newArrayList();
        List<ItemStack> stacks = new ArrayList<>();
        int ct = cont / 64;
        int am = cont - ct * 64;
        for (int i = 0; i < ct; i++) {
            var st = stack.m_41777_();
            st.setCount(64);
            stacks.add(st);
        }
        if (am != 0) {
            var st = stack.m_41777_();
            st.setCount(am);
            stacks.add(st);
        }
        return stacks;
    }
}
