package dev.felnull.otyacraftengine.util;

import com.mojang.math.Vector3f;
import dev.felnull.otyacraftengine.client.motion.MotionRotation;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import var;

public class OEMath {
    public static MotionRotation add(MotionRotation rotation, MotionRotation rotation2) {
        var c = rotation.origin().m_122281_();
        c.add(rotation2.origin());

        var a = rotation.angle().m_122281_();
        a.add(rotation2.angle());

        return new MotionRotation(a, c, Triple.of(false, false, false));
    }

    @NotNull
    public static MotionRotation leap(float delta, @NotNull MotionRotation old, @NotNull MotionRotation current) {
        return new MotionRotation(OEMath.leapAngle(delta, old, current), leap(delta, old.origin(), current.origin()), Triple.of(false, false, false));
    }

    @NotNull
    public static Vector3f leap(float delta, @NotNull Vector3f old, @NotNull Vector3f current) {
        return new Vector3f(Mth.m_14179_(delta, old.m_122239_(), current.m_122239_()), Mth.m_14179_(delta, old.m_122260_(), current.m_122260_()), Mth.m_14179_(delta, old.m_122269_(), current.m_122269_()));
    }

    @NotNull
    public static Vector3f leapAngle(float delta, @NotNull MotionRotation oldRotation, @NotNull MotionRotation currentRotation) {
        return leapAngle(delta, oldRotation.angle(), currentRotation.angle(), currentRotation.reset());
    }

    @NotNull
    public static Vector3f leapAngle(float delta, @NotNull Vector3f oldAngle, @NotNull Vector3f currentAngle, @NotNull Triple<Boolean, Boolean, Boolean> reset) {
        float x = leapAngleValue(delta, oldAngle.m_122239_(), currentAngle.m_122239_(), reset.getLeft());
        float y = leapAngleValue(delta, oldAngle.m_122260_(), currentAngle.m_122260_(), reset.getMiddle());
        float z = leapAngleValue(delta, oldAngle.m_122269_(), currentAngle.m_122269_(), reset.getRight());
        return new Vector3f(x, y, z);
    }

    private static float leapAngleValue(float delta, float old, float current, boolean reset) {
        if (!reset) {
            return Mth.m_14179_(delta, old, current);
        } else {
            return Mth.m_14179_(delta, old, toNoResetAngle(old, current));
        }
    }

    private static float toNoResetAngle(float old, float val) {
        return old - (old % 360) + val;
    }
}
