/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.debug;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.client.model.OETestModels;
import dev.felnull.otyacraftengine.client.motion.Motion;
import dev.felnull.otyacraftengine.client.motion.MotionPoint;
import dev.felnull.otyacraftengine.client.motion.MotionPose;
import dev.felnull.otyacraftengine.client.motion.MotionRotation;
import dev.felnull.otyacraftengine.client.util.OEModelUtil;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;

public class MotionDebug {
    private static final MotionDebug INSTANCE = new MotionDebug();
    private final List<MotionPoint> points = new ArrayList<MotionPoint>();
    private final DebugOption option = new DebugOption();
    private Vector3f position = new Vector3f();
    private MotionRotation rotation = new MotionRotation();
    private float ratio = 1.0f;
    private Vector3f temporaryPosition = new Vector3f();
    private SimpleRotation temporaryRotation = new SimpleRotation();
    private Motion playMotion;
    private long cycleSpeed;

    @NotNull
    public static MotionDebug getInstance() {
        return INSTANCE;
    }

    @NotNull
    public EditType getEditType() {
        return this.option.editType;
    }

    public boolean isFixOrigin() {
        return this.option.fixOrigin;
    }

    public void setFixOrigin(boolean fix) {
        this.option.fixOrigin = fix;
    }

    public boolean isShowOrigin() {
        return this.option.showOrigin;
    }

    public void setShowOrigin(boolean show) {
        this.option.showOrigin = show;
    }

    public boolean isEnableTemporary() {
        return this.option.enableTemporary;
    }

    public boolean isEditTemporary() {
        return this.option.editTemporary;
    }

    public float getSensitivity() {
        return this.option.sensitivity;
    }

    public void setEditType(@NotNull EditType editType) {
        this.option.editType = editType;
    }

    public void setEnableTemporary(boolean enable) {
        this.option.enableTemporary = enable;
    }

    public void setEditTemporary(boolean editTemporary) {
        this.option.editTemporary = editTemporary;
    }

    public void setSensitivity(float sensitivity) {
        this.option.sensitivity = sensitivity;
    }

    public Vector3f getTemporaryPosition() {
        return this.temporaryPosition;
    }

    public SimpleRotation getTemporaryRotation() {
        return this.temporaryRotation;
    }

    public List<MotionPoint> getPoints() {
        return this.points;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public MotionRotation getRotation() {
        return this.rotation;
    }

    public float getRatio() {
        return this.ratio;
    }

    public void setRatio(float ratio) {
        this.ratio = ratio;
    }

    public void setPosition(Vector3f position) {
        this.position = position;
    }

    public void setRotation(MotionRotation rotation) {
        this.rotation = rotation;
    }

    public void setRotationAngle(Vector3f angle) {
        MotionRotation o = this.rotation.copy();
        this.setRotation(new MotionRotation(angle, o.origin(), o.reset()));
    }

    public void setRotationOrigin(Vector3f origin) {
        this.setRotationOrigin(origin, false);
    }

    public void setRotationOrigin(Vector3f origin, boolean force) {
        if (this.isFixOrigin() && !force) {
            return;
        }
        MotionRotation o = this.rotation.copy();
        this.setRotation(new MotionRotation(o.angle(), origin, o.reset()));
    }

    public void setTemporaryPosition(Vector3f temporaryPosition) {
        this.temporaryPosition = temporaryPosition;
    }

    public void setTemporaryRotation(SimpleRotation temporaryRotation) {
        this.temporaryRotation = temporaryRotation;
    }

    public void addPosition(float x, float y, float z) {
        Vector3f o = this.getPosition().m_122281_();
        o.m_122272_(x, y, z);
        this.setPosition(o);
    }

    public void addRotationAngle(float x, float y, float z) {
        Vector3f o = this.getRotation().angle().m_122281_();
        o.m_122272_(x, y, z);
        this.setRotation(new MotionRotation(o, this.getRotation().origin(), this.getRotation().reset()));
    }

    public void setRotationReset(boolean x, boolean y, boolean z) {
        this.setRotation(new MotionRotation(this.getRotation().angle(), this.getRotation().origin(), (Triple<Boolean, Boolean, Boolean>)Triple.of((Object)x, (Object)y, (Object)z)));
    }

    public void addRotationOrigin(float x, float y, float z) {
        if (this.isFixOrigin()) {
            return;
        }
        Vector3f o = this.getRotation().origin().m_122281_();
        o.m_122272_(x, y, z);
        this.setRotation(new MotionRotation(this.getRotation().angle(), o, this.getRotation().reset()));
    }

    public void addTemporaryPosition(float x, float y, float z) {
        Vector3f o = this.getTemporaryPosition().m_122281_();
        o.m_122272_(x, y, z);
        this.setTemporaryPosition(o);
    }

    public void addTemporaryRotationAngle(float x, float y, float z) {
        Vector3f o = this.getTemporaryRotation().angle().m_122281_();
        o.m_122272_(x, y, z);
        this.setTemporaryRotation(new SimpleRotation(o, this.getRotation().origin()));
    }

    public void addTemporaryRotationOrigin(float x, float y, float z) {
        if (this.isFixOrigin()) {
            return;
        }
        Vector3f o = this.getTemporaryRotation().origin().m_122281_();
        o.m_122272_(x, y, z);
        this.setTemporaryRotation(new SimpleRotation(this.getRotation().angle(), o));
    }

    public void reset() {
        if (this.isEditTemporary()) {
            this.setTemporaryPosition(new Vector3f());
            this.setTemporaryRotation(new SimpleRotation());
        } else {
            this.setPosition(new Vector3f());
            Vector3f or = this.getRotation().origin().m_122281_();
            this.setRotation(new MotionRotation());
            if (this.isFixOrigin()) {
                this.setRotationOrigin(or, true);
            }
        }
    }

    public MotionPose getPose() {
        return new MotionPose(this.position, this.rotation);
    }

    public MotionPose getDebugPose() {
        if (this.playMotion == null) {
            return this.getPose();
        }
        return this.playMotion.getPose(OERenderUtil.getParSecond(this.cycleSpeed));
    }

    public void pose(@NotNull PoseStack stack) {
        stack.m_85837_((double)this.position.m_122239_(), (double)this.position.m_122260_(), (double)this.position.m_122269_());
        this.rotation.pose(stack);
        if (this.isEnableTemporary()) {
            stack.m_85837_((double)this.temporaryPosition.m_122239_(), (double)this.temporaryPosition.m_122260_(), (double)this.temporaryPosition.m_122269_());
            this.temporaryRotation.pose(stack);
        }
    }

    public void poseDebug(@NotNull PoseStack stack) {
        if (this.playMotion == null) {
            this.pose(stack);
            return;
        }
        this.playMotion.pose(stack, OERenderUtil.getParSecond(this.cycleSpeed));
        if (this.isEnableTemporary()) {
            stack.m_85837_((double)this.temporaryPosition.m_122239_(), (double)this.temporaryPosition.m_122260_(), (double)this.temporaryPosition.m_122269_());
            this.temporaryRotation.pose(stack);
        }
    }

    public void onDebug(@NotNull PoseStack stack, MultiBufferSource multiBufferSource, float scale) {
        if (!OtyacraftEngine.isTestMode()) {
            return;
        }
        this.poseDebug(stack);
        if (!this.isShowOrigin()) {
            return;
        }
        stack.m_85836_();
        stack.m_85836_();
        stack.m_85837_((double)this.rotation.origin().m_122239_(), (double)this.rotation.origin().m_122260_(), (double)this.rotation.origin().m_122269_());
        OERenderUtil.poseScaleAll(stack, 0.1f * scale);
        OERenderUtil.renderModel(stack, multiBufferSource.m_6299_(Sheets.m_110790_()), OEModelUtil.getModel(OETestModels.XYZ_AXIS), 0xF000F0, OverlayTexture.f_118083_);
        stack.m_85849_();
        stack.m_85836_();
        stack.m_85837_((double)this.rotation.origin().m_122239_(), (double)this.rotation.origin().m_122260_(), (double)this.rotation.origin().m_122269_());
        OERenderUtil.poseScaleAll(stack, scale);
        OERenderUtil.renderModel(stack, multiBufferSource.m_6299_(Sheets.m_110790_()), OEModelUtil.getModel(OETestModels.ORIGIN), 0xF000F0, OverlayTexture.f_118083_);
        stack.m_85849_();
        stack.m_85849_();
    }

    public MotionPoint createPoint() {
        return new MotionPoint(this.getPosition().m_122281_(), this.getRotation().copy(), this.ratio);
    }

    public void setPoint(MotionPoint point) {
        this.setPosition(point.getPosition());
        this.setRotation(point.getRotation());
        this.setRatio(point.getRatio());
    }

    @NotNull
    public Motion createMotion() {
        return new Motion((List<MotionPoint>)ImmutableList.copyOf(this.getPoints()));
    }

    public void setMotion(Motion motion) {
        this.reset();
        this.points.clear();
        this.points.addAll(motion.getPoints());
    }

    public void startMotion(long cycleSpeed) {
        this.playMotion = this.createMotion();
        this.cycleSpeed = cycleSpeed;
    }

    public void stopMotion() {
        this.playMotion = null;
    }

    public boolean isMotionPlaying() {
        return this.playMotion != null;
    }

    private static class DebugOption {
        private boolean enableTemporary;
        private boolean editTemporary;
        @NotNull
        private EditType editType = EditType.POSITION;
        private float sensitivity = 1.0f;
        private boolean fixOrigin = true;
        private boolean showOrigin = true;

        private DebugOption() {
        }
    }

    public record SimpleRotation(Vector3f angle, Vector3f origin) {
        public SimpleRotation() {
            this(new Vector3f(), new Vector3f());
        }

        public void pose(PoseStack poseStack) {
            poseStack.m_85837_((double)this.origin.m_122239_(), (double)this.origin.m_122260_(), (double)this.origin.m_122269_());
            OERenderUtil.poseRotateAll(poseStack, this.angle.m_122239_(), this.angle.m_122260_(), this.angle.m_122269_());
            poseStack.m_85837_((double)(-this.origin.m_122239_()), (double)(-this.origin.m_122260_()), (double)(-this.origin.m_122269_()));
        }
    }

    public static enum EditType {
        POSITION,
        ROTATION,
        ROTATION_ORIGIN;

    }
}

