/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.otyacraftengine.client.gui.TextureSpecifyLocation;
import dev.felnull.otyacraftengine.client.gui.components.base.OEBaseImageWidget;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FixedListWidget<E>
extends OEBaseImageWidget {
    @NotNull
    private List<E> entryList;
    @NotNull
    private final Function<E, Component> entryName;
    @Nullable
    private final PressEntry<E> onPressEntry;
    private final boolean selectable;
    private final int entryShowCount;
    private boolean border;
    private float scrollAmount;
    private boolean canScroll;
    protected boolean isHoveredScrollBar;
    protected int hoveredNumber;
    @Nullable
    protected E selectedEntry;
    protected int selectedEntryIndex = -1;

    public FixedListWidget(int x, int y, int width, int height, @NotNull Component message, int entryShowCount, @NotNull List<E> entryList, @NotNull Function<E, Component> entryName, @Nullable PressEntry<E> onPressEntry, boolean selectable, FixedListWidget<E> old) {
        this(x, y, width, height, message, entryShowCount, entryList, entryName, onPressEntry, selectable, new TextureSpecifyLocation(WIDGETS, 40, 34, 18, 42), old);
    }

    public FixedListWidget(int x, int y, int width, int height, @NotNull Component message, int entryShowCount, @NotNull List<E> entryList, @NotNull Function<E, Component> entryName, @Nullable PressEntry<E> onPressEntry, boolean selectable, @NotNull TextureSpecifyLocation texture, FixedListWidget<E> old) {
        super(x, y, width, height, "fixedListWidget", message, texture);
        this.entryShowCount = entryShowCount;
        this.entryList = entryList;
        this.entryName = entryName;
        this.onPressEntry = onPressEntry;
        this.selectable = selectable;
        this.copyValue(old);
    }

    public void m_6305_(@NotNull PoseStack poseStack, int mx, int my, float parTick) {
        if (this.f_93624_) {
            this.hoveredNumber = (my - this.f_93621_) / this.getIndividualHeight();
            this.isHoveredScrollBar = mx >= this.f_93620_ + this.getIndividualWidth() && my >= this.f_93621_ && mx < this.f_93620_ + this.f_93618_ && my < this.f_93621_ + this.f_93619_;
        }
        super.m_6305_(poseStack, mx, my, parTick);
    }

    public void m_6303_(@NotNull PoseStack poseStack, int mx, int my, float parTick) {
        int cn;
        for (int i = 0; i < this.entryShowCount && (cn = this.getCurrentFirstEntryIndex() + i) < this.entryList.size() && cn >= 0; ++i) {
            E e = this.entryList.get(cn);
            this.renderOneButton(poseStack, e, cn, i, this.f_93620_, this.f_93621_ + this.getIndividualHeight() * i, mx, my, parTick, this.selectedEntry == this.entryList.get(cn));
        }
        this.renderScrollbar(poseStack, this.f_93620_ + this.getIndividualWidth(), this.f_93621_, 9, this.f_93619_);
    }

    protected void renderScrollbar(PoseStack poseStack, int x, int y, int w, int h) {
        boolean hv = this.isScrollBarHovered() || this.m_93696_();
        OERenderUtil.drawTexture(this.texture.location(), poseStack, x, y, this.texture.x() + (hv ? 9 : 0), this.texture.y(), 9.0f, 3.0f, this.texture.sizeWidth(), this.texture.sizeHeight());
        int bsct = (this.f_93619_ - 6) / 16;
        for (int i = 0; i < bsct; ++i) {
            OERenderUtil.drawTexture(this.texture.location(), poseStack, x, y + 3 + i * 16, this.texture.x() + (hv ? 9 : 0), this.texture.y() + 3, 9.0f, 16.0f, this.texture.sizeWidth(), this.texture.sizeHeight());
        }
        int bsam = (this.f_93619_ - 6) % 16;
        OERenderUtil.drawTexture(this.texture.location(), poseStack, x, y + 3 + bsct * 16, this.texture.x() + (hv ? 9 : 0), this.texture.y() + 3, 9.0f, bsam, this.texture.sizeWidth(), this.texture.sizeHeight());
        OERenderUtil.drawTexture(this.texture.location(), poseStack, x, y + this.f_93619_ - 3, this.texture.x() + (hv ? 9 : 0), this.texture.y() + 19, 9.0f, 3.0f, this.texture.sizeWidth(), this.texture.sizeHeight());
        int barHeight = this.getBarHeight();
        float barY = (float)(this.f_93619_ - 2 - barHeight) * this.scrollAmount;
        OERenderUtil.drawTexture(this.texture.location(), poseStack, x + 1, (float)(y + 1) + barY, this.texture.x() + (hv ? 7 : 0), this.texture.y() + 22, 7.0f, 3.0f, this.texture.sizeWidth(), this.texture.sizeHeight());
        int ssct = (barHeight - 6) / 14;
        for (int i = 0; i < ssct; ++i) {
            OERenderUtil.drawTexture(this.texture.location(), poseStack, x + 1, (float)(y + 4 + i * 14) + barY, this.texture.x() + (hv ? 7 : 0), this.texture.y() + 25, 7.0f, 14.0f, this.texture.sizeWidth(), this.texture.sizeHeight());
        }
        int ssam = (barHeight - 6) % 14;
        OERenderUtil.drawTexture(this.texture.location(), poseStack, x + 1, (float)(y + 4 + ssct * 14) + barY, this.texture.x() + (hv ? 7 : 0), this.texture.y() + 25, 7.0f, ssam, this.texture.sizeWidth(), this.texture.sizeHeight());
        OERenderUtil.drawTexture(this.texture.location(), poseStack, x + 1, (float)(y + 1 + barHeight - 3) + barY, this.texture.x() + (hv ? 7 : 0), this.texture.y() + 39, 7.0f, 3.0f, this.texture.sizeWidth(), this.texture.sizeHeight());
    }

    protected void renderOneButton(PoseStack poseStack, E item, int lnum, int bnum, int x, int y, int mx, int my, float parTick, boolean selected) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93617_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        int k = this.m_7202_(this.isEntryHovered(bnum));
        if (selected) {
            k = 0;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        this.m_93228_(poseStack, x, y, 0, 46 + k * 20, this.getIndividualWidth() / 2, this.getIndividualHeight());
        this.m_93228_(poseStack, x + this.getIndividualWidth() / 2, y, 200 - this.getIndividualWidth() / 2, 46 + k * 20, this.getIndividualWidth() / 2, this.getIndividualHeight());
        this.m_7906_(poseStack, mc, mx, my);
        int l = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
        FixedListWidget.m_93215_((PoseStack)poseStack, (Font)FixedListWidget.mc.f_91062_, (Component)this.getMessage(lnum), (int)(this.f_93620_ + this.getIndividualWidth() / 2), (int)(y + (this.getIndividualHeight() - 8) / 2), (int)(l | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
    }

    @Override
    public void onPress() {
    }

    public void m_7435_(@NotNull SoundManager soundManager) {
        boolean nflg;
        boolean flg = this.isEntryHovered(this.hoveredNumber);
        boolean bl = nflg = this.entryList.size() > this.hoveredNumber;
        if (!flg || nflg) {
            super.m_7435_(soundManager);
        }
    }

    @Override
    public void m_5716_(double mx, double my) {
        this.onPress((int)((my - (double)this.f_93621_) / (double)this.getIndividualHeight()));
        super.m_5716_(mx, my);
    }

    public boolean m_7979_(double mx, double my, int i, double f, double g) {
        this.scroll(my);
        return super.m_7979_(mx, my, i, f, g);
    }

    public boolean m_6375_(double mx, double my, int i) {
        this.canScroll = this.isScrollBarHovered();
        this.scroll(my);
        return super.m_6375_(mx, my, i);
    }

    public boolean m_6050_(double d, double e, double f) {
        this.setScrollAmount(this.getScrollAmount() - (float)f * ((float)this.entryShowCount / (float)this.f_93619_));
        return true;
    }

    @Override
    public boolean m_7933_(int i, int j, int k) {
        if (this.f_93623_ && this.f_93624_ && this.m_198029_()) {
            if (i == 265) {
                this.setScrollAmount(this.getScrollAmount() - 0.3f * ((float)this.entryShowCount / (float)this.f_93619_));
                return true;
            }
            if (i == 264) {
                this.setScrollAmount(this.getScrollAmount() + 0.3f * ((float)this.entryShowCount / (float)this.f_93619_));
                return true;
            }
        }
        return false;
    }

    public void onPress(int num) {
        int cn = this.getCurrentFirstEntryIndex() + num;
        if (cn < this.entryList.size() && this.isEntryHovered(num)) {
            E e = this.entryList.get(cn);
            if (this.selectable) {
                this.selectedEntry = e;
                this.selectedEntryIndex = cn;
            }
            if (this.onPressEntry != null) {
                this.onPressEntry.onPressEntry(this, e);
            }
        }
    }

    public void setSelectedEntry(int index) {
        if (index >= 0 && index < this.entryList.size()) {
            this.selectedEntry = this.entryList.get(index);
            this.selectedEntryIndex = index;
        } else {
            this.selectedEntry = null;
            this.selectedEntryIndex = -1;
        }
    }

    public void setSelectedEntry(@Nullable E selectedEntry) {
        if (selectedEntry == null || this.entryList.stream().anyMatch(n -> n == selectedEntry)) {
            this.selectedEntry = selectedEntry;
            this.selectedEntryIndex = selectedEntry == null ? -1 : this.entryList.indexOf(selectedEntry);
        }
    }

    @Nullable
    public E getSelectedEntry() {
        if (this.entryList.stream().anyMatch(n -> n == this.selectedEntry)) {
            return this.selectedEntry;
        }
        return null;
    }

    public int getSelectedEntryIndex() {
        if (this.getSelectedEntry() == null) {
            return -1;
        }
        return this.selectedEntryIndex;
    }

    protected int getCurrentFirstEntryIndex() {
        if (this.entryList.size() <= this.entryShowCount) {
            return 0;
        }
        return (int)((float)(this.entryList.size() - this.entryShowCount) * this.scrollAmount);
    }

    public boolean isEntryHovered(int lnum) {
        return this.f_93622_ && this.hoveredNumber == lnum && !this.isHoveredScrollBar;
    }

    public boolean isScrollBarHovered() {
        return this.f_93622_ && this.isHoveredScrollBar;
    }

    public Component getMessage(int index) {
        return this.entryName.apply(this.entryList.get(index));
    }

    public void scroll(double mouseY) {
        if (this.canScroll) {
            int cy = (int)(mouseY - (double)this.f_93621_ - 1.0 - (double)(this.getBarHeight() / 2));
            int sa = this.f_93619_ - 2 - this.getBarHeight();
            if (sa > 0) {
                this.setScrollAmount((float)cy / (float)sa);
            }
        }
    }

    public int getBarHeight() {
        return Mth.m_14045_((int)((this.f_93619_ - 2) / (this.entryList.size() / this.entryShowCount + 1)), (int)10, (int)(this.f_93619_ - 2));
    }

    public float getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(float scrollAmount) {
        this.scrollAmount = Mth.m_14036_((float)scrollAmount, (float)0.0f, (float)1.0f);
    }

    public int getIndividualHeight() {
        return this.f_93619_ / this.entryShowCount;
    }

    public int getIndividualWidth() {
        return this.f_93618_ - (9 + (this.border ? 0 : 1));
    }

    @NotNull
    public List<E> getEntryList() {
        return this.entryList;
    }

    public void setEntryList(@NotNull List<E> entryList) {
        this.entryList = entryList;
    }

    public boolean isBorder() {
        return this.border;
    }

    public void setBorder(boolean border) {
        this.border = border;
    }

    public void copyValue(@Nullable FixedListWidget<E> copyValue) {
        if (copyValue != null) {
            this.selectedEntry = copyValue.selectedEntry;
            this.scrollAmount = copyValue.scrollAmount;
            this.selectedEntryIndex = copyValue.selectedEntryIndex;
        }
    }

    public static interface PressEntry<E> {
        public void onPressEntry(FixedListWidget<E> var1, E var2);
    }
}

