/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.util;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.platform.NativeImage;
import dev.felnull.otyacraftengine.client.renderer.texture.DynamicGifTexture;
import dev.felnull.otyacraftengine.client.util.OEClientUtil;
import dev.felnull.otyacraftengine.libs.com.madgag.gif.fmsware.GifDecoder;
import dev.felnull.otyacraftengine.libs.dev.felnull.fnjl.math.FNVec2d;
import dev.felnull.otyacraftengine.libs.dev.felnull.fnjl.util.FNDataUtil;
import dev.felnull.otyacraftengine.libs.dev.felnull.fnjl.util.FNImageUtil;
import dev.felnull.otyacraftengine.libs.dev.felnull.fnjl.util.FNMath;
import dev.felnull.otyacraftengine.libs.dev.felnull.fnjl.util.FNURLUtil;
import dev.felnull.otyacraftengine.util.OEPaths;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OETextureUtil {
    private static final Minecraft mc = Minecraft.m_91087_();
    protected static final Map<UUID, TextureLoadResult> NATIVE_TEXTURES = new HashMap<UUID, TextureLoadResult>();
    protected static final List<UUID> LOAD_TEXTURES = new ArrayList<UUID>();
    protected static ResourceLocation LOADING_ICON;
    protected static final Map<String, String> URL_FILENAME_INDEX;
    protected static final Map<String, UUID> URL_TEXTURES_UUIDS;
    protected static final List<String> URL_LOAD_TEXTURES;

    public static ResourceLocation getLoadingIcon() {
        if (LOADING_ICON == null) {
            ResourceManager rm = mc.m_91098_();
            try {
                LOADING_ICON = OETextureUtil.loadNativeTexture(rm.m_142591_(new ResourceLocation("otyacraftengine", "textures/gui/loading.gif")).m_6679_(), MissingTextureAtlasSprite.m_118071_()).location();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return LOADING_ICON;
    }

    public static ResourceLocation getPlayerSkinTexture(UUID uuid) {
        return OETextureUtil.getPlayerTexture(MinecraftProfileTexture.Type.SKIN, uuid);
    }

    public static ResourceLocation getPlayerCapeTexture(UUID uuid) {
        return OETextureUtil.getPlayerTexture(MinecraftProfileTexture.Type.CAPE, uuid);
    }

    public static ResourceLocation getPlayerElytraTexture(UUID uuid) {
        return OETextureUtil.getPlayerTexture(MinecraftProfileTexture.Type.ELYTRA, uuid);
    }

    public static ResourceLocation getPlayerSkinTexture(String name) {
        return OETextureUtil.getPlayerTexture(MinecraftProfileTexture.Type.SKIN, name);
    }

    public static ResourceLocation getPlayerCapeTexture(String name) {
        return OETextureUtil.getPlayerTexture(MinecraftProfileTexture.Type.CAPE, name);
    }

    public static ResourceLocation getPlayerElytraTexture(String name) {
        return OETextureUtil.getPlayerTexture(MinecraftProfileTexture.Type.ELYTRA, name);
    }

    @Nullable
    public static ResourceLocation getPlayerTexture(MinecraftProfileTexture.Type type, @NotNull String name) {
        PlayerInfo pl;
        if (OETextureUtil.mc.f_91074_ != null && (pl = OETextureUtil.mc.f_91074_.f_108617_.m_104938_(name)) != null) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case MinecraftProfileTexture.Type.SKIN -> pl.m_105337_();
                case MinecraftProfileTexture.Type.CAPE -> pl.m_105338_();
                case MinecraftProfileTexture.Type.ELYTRA -> pl.m_105339_();
            };
        }
        GameProfile gameProfile = OEClientUtil.getClientPlayerProfile(name);
        MinecraftProfileTexture tex = (MinecraftProfileTexture)mc.m_91109_().m_118815_(gameProfile).get(type);
        return tex != null ? mc.m_91109_().m_118825_(tex, type) : (type == MinecraftProfileTexture.Type.SKIN ? DefaultPlayerSkin.m_118627_((UUID)Player.m_36198_((GameProfile)gameProfile)) : null);
    }

    public static ResourceLocation getPlayerTexture(MinecraftProfileTexture.Type type, @NotNull UUID uuid) {
        PlayerInfo pl;
        if (OETextureUtil.mc.f_91074_ != null && (pl = OETextureUtil.mc.f_91074_.f_108617_.m_104949_(uuid)) != null) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case MinecraftProfileTexture.Type.SKIN -> pl.m_105337_();
                case MinecraftProfileTexture.Type.CAPE -> pl.m_105338_();
                case MinecraftProfileTexture.Type.ELYTRA -> pl.m_105339_();
            };
        }
        return OEClientUtil.getPlayerNameByUUID(uuid).map(n -> OETextureUtil.getPlayerTexture(type, n)).orElseGet(() -> type == MinecraftProfileTexture.Type.SKIN ? DefaultPlayerSkin.m_118627_((UUID)uuid) : null);
    }

    public static ResourceLocation getURLTextureAsyncLoad(String url, boolean cash) {
        return OETextureUtil.getURLTextureAsyncLoad(url, cash, MissingTextureAtlasSprite.m_118071_());
    }

    public static ResourceLocation getURLTextureAsyncLoad(String url, boolean cash, ResourceLocation failureTexture) {
        return OETextureUtil.getURLTextureAsyncLoad(url, cash, OETextureUtil.getLoadingIcon(), failureTexture);
    }

    public static ResourceLocation getURLTextureAsyncLoad(String url, boolean cash, ResourceLocation loadTexture, ResourceLocation failureTexture) {
        if (URL_TEXTURES_UUIDS.containsKey(url)) {
            return OETextureUtil.getNativeTexture(URL_TEXTURES_UUIDS.get(url), null);
        }
        if (URL_LOAD_TEXTURES.contains(url)) {
            return loadTexture;
        }
        CompletableFuture.runAsync(() -> {
            URL_LOAD_TEXTURES.add(url);
            TextureLoadResult tex = OETextureUtil.loadURLTexture(url, cash, failureTexture);
            mc.m_18707_(() -> {
                UUID id = UUID.randomUUID();
                NATIVE_TEXTURES.put(id, tex);
                URL_LOAD_TEXTURES.remove(url);
                URL_TEXTURES_UUIDS.put(url, id);
            });
        });
        return loadTexture;
    }

    public static ResourceLocation getURLTexture(String url, boolean cash) {
        return OETextureUtil.getURLTexture(url, cash, MissingTextureAtlasSprite.m_118071_());
    }

    public static ResourceLocation getURLTexture(String url, boolean cash, ResourceLocation failureTexture) {
        if (URL_TEXTURES_UUIDS.containsKey(url)) {
            return OETextureUtil.getNativeTexture(URL_TEXTURES_UUIDS.get(url), null);
        }
        UUID id = UUID.randomUUID();
        TextureLoadResult tx = OETextureUtil.loadURLTexture(url, cash, failureTexture);
        URL_TEXTURES_UUIDS.put(url, id);
        NATIVE_TEXTURES.put(id, tx);
        return tx.location();
    }

    private static TextureLoadResult loadURLTexture(String url, boolean cash, ResourceLocation failureTexture) {
        try {
            InputStream stream;
            byte[] md5 = FNDataUtil.createMD5Hash(url.getBytes(StandardCharsets.UTF_8));
            String identification = Base64.getEncoder().encodeToString(md5);
            Path oep = OEPaths.getClientOEFolderPath().resolve("url_textures");
            if (URL_FILENAME_INDEX.containsKey(identification) && oep.resolve(URL_FILENAME_INDEX.get(identification)).toFile().exists()) {
                stream = new BufferedInputStream(new FileInputStream(oep.resolve(URL_FILENAME_INDEX.get(identification)).toFile()));
            } else {
                long max;
                HttpURLConnection connection = FNURLUtil.getConnection(new URL(url));
                long length = connection.getContentLengthLong();
                if (length > (max = 0x300000L)) {
                    throw new IOException("Size Over: " + max + "byte current: " + length + "byte");
                }
                if (cash) {
                    byte[] data = connection.getInputStream().readAllBytes();
                    UUID uid = UUID.randomUUID();
                    Files.write(oep.resolve(uid.toString()), data, new OpenOption[0]);
                    URL_FILENAME_INDEX.put(identification, uid.toString());
                    stream = new ByteArrayInputStream(data);
                } else {
                    stream = connection.getInputStream();
                }
            }
            return OETextureUtil.loadNativeTexture(stream, failureTexture);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new TextureLoadResult(failureTexture, true);
        }
    }

    public static ResourceLocation getNativeTextureAsyncLoad(UUID id, InputStream stream) {
        return OETextureUtil.getNativeTextureAsyncLoad(id, stream, MissingTextureAtlasSprite.m_118071_());
    }

    public static ResourceLocation getNativeTextureAsyncLoad(UUID id, InputStream stream, ResourceLocation failureTexture) {
        return OETextureUtil.getNativeTextureAsyncLoad(id, stream, OETextureUtil.getLoadingIcon(), failureTexture);
    }

    public static ResourceLocation getNativeTextureAsyncLoad(UUID id, InputStream stream, ResourceLocation loadTexture, ResourceLocation failureTexture) {
        if (NATIVE_TEXTURES.containsKey(id)) {
            return NATIVE_TEXTURES.get(id).location();
        }
        if (LOAD_TEXTURES.contains(id)) {
            return loadTexture;
        }
        CompletableFuture.runAsync(() -> {
            LOAD_TEXTURES.add(id);
            TextureLoadResult tex = OETextureUtil.loadNativeTexture(stream, failureTexture);
            mc.m_18707_(() -> {
                NATIVE_TEXTURES.put(id, tex);
                LOAD_TEXTURES.remove(id);
            });
        });
        return loadTexture;
    }

    public static TextureScale getTextureScale(ResourceLocation location) {
        AbstractTexture abstractTexture;
        if (location != null && (abstractTexture = mc.m_91097_().m_118506_(location)) instanceof DynamicTexture) {
            DynamicTexture texture = (DynamicTexture)abstractTexture;
            int w = texture.m_117991_().m_84982_();
            int h = texture.m_117991_().m_85084_();
            FNVec2d sc = FNMath.scale(w, h);
            return new TextureScale(sc.getX(), sc.getY());
        }
        return null;
    }

    public static ResourceLocation getNativeTexture(UUID id, InputStream stream) {
        return OETextureUtil.getNativeTexture(id, stream, MissingTextureAtlasSprite.m_118071_());
    }

    public static ResourceLocation getNativeTexture(UUID id, InputStream stream, ResourceLocation failureTexture) {
        if (NATIVE_TEXTURES.containsKey(id)) {
            return NATIVE_TEXTURES.get(id).location();
        }
        TextureLoadResult tex = OETextureUtil.loadNativeTexture(stream, failureTexture);
        NATIVE_TEXTURES.put(id, tex);
        return tex.location();
    }

    protected static TextureLoadResult loadNativeTexture(InputStream stream, ResourceLocation failureTexture) {
        try {
            byte[] data = stream.readAllBytes();
            GifDecoder decoder = new GifDecoder();
            boolean gifFlg = decoder.read(new ByteArrayInputStream(data)) == 0;
            AtomicReference tex = new AtomicReference();
            if (!gifFlg) {
                NativeImage ni = NativeImage.m_85058_((InputStream)new ByteArrayInputStream(data));
                mc.m_18707_(() -> tex.set(mc.m_91097_().m_118490_("native_texture", new DynamicTexture(ni)))).get();
            } else {
                DynamicGifTexture.ImageFrame[] frames = new DynamicGifTexture.ImageFrame[decoder.getFrameCount()];
                long duration = 0L;
                for (int i = 0; i < decoder.getFrameCount(); ++i) {
                    frames[i] = new DynamicGifTexture.ImageFrame(NativeImage.m_85058_((InputStream)FNImageUtil.toInputStream(decoder.getFrame(i), "png")), decoder.getDelay(i));
                    duration += (long)decoder.getDelay(i);
                }
                long finalDuration = duration;
                mc.m_18707_(() -> tex.set(mc.m_91097_().m_118490_("native_texture", (DynamicTexture)new DynamicGifTexture(finalDuration, frames)))).get();
            }
            stream.close();
            return new TextureLoadResult((ResourceLocation)tex.get(), false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new TextureLoadResult(failureTexture, true);
        }
    }

    public static void freeNativeTexture(UUID id) {
        if (NATIVE_TEXTURES.containsKey(id)) {
            if (!NATIVE_TEXTURES.get(id).failure()) {
                OETextureUtil.freeTexture(NATIVE_TEXTURES.get(id).location());
            }
            NATIVE_TEXTURES.remove(id);
        }
    }

    public static void freeTexture(ResourceLocation location) {
        TextureManager textureManager = mc.m_91097_();
        AbstractTexture abstractTexture = (AbstractTexture)textureManager.f_118468_.get(location);
        if (abstractTexture != null) {
            if (abstractTexture instanceof Tickable) {
                textureManager.f_118469_.remove(abstractTexture);
            }
            textureManager.m_118508_(location, abstractTexture);
        }
    }

    static {
        URL_FILENAME_INDEX = new HashMap<String, String>();
        URL_TEXTURES_UUIDS = new HashMap<String, UUID>();
        URL_LOAD_TEXTURES = new ArrayList<String>();
    }

    private record TextureLoadResult(ResourceLocation location, boolean failure) {
    }

    public record TextureScale(double w, double h) {
    }
}

