package dev.felnull.otyacraftengine.item;

import dev.architectury.registry.registries.DeferredRegister;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.client.util.OEClientUtil;
import dev.felnull.otyacraftengine.util.OEVoxelShapeUtil;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.VoxelShape;

import java.util.Arrays;

public class TestItem extends Item implements IEquipmentItem {
    public TestItem(Properties properties) {
        super(properties);
    }

    private static final VoxelShape shape = OEVoxelShapeUtil.getShapeFromResource(new ResourceLocation(OtyacraftEngine.MODID, "sample"));

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack stack = player.m_21120_(interactionHand);

        if (level.m_5776_()) {
           // System.out.println(Arrays.toString(OEClientUtil.openFileChooser("TEST", null, "image files", false)));
        }

        return InteractionResultHolder.m_19092_(stack, level.f_46443_);
    }

    public static Item TEST_ITEM;

    public static void init() {
        DeferredRegister<Item> ITEM_REG = DeferredRegister.create(OtyacraftEngine.MODID, Registry.f_122904_);
        TEST_ITEM = new TestItem(new Item.Properties().m_41491_(CreativeModeTab.f_40753_));
        ITEM_REG.register("test_item", () -> TEST_ITEM);
        ITEM_REG.register();
    }

    @Override
    public EquipmentSlot getEquipmentSlotType(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }
}
