/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.otyacraftengine.client.gui.components.IOEBaseComponent;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class FixedButtonsList<E>
extends AbstractWidget
implements IOEBaseComponent {
    private static final Minecraft mc = Minecraft.m_91087_();
    private final List<E> list;
    private final Function<E, Component> listName;
    private final PressEntry<E> onPress;
    private final int xTexStart;
    private final int yTexStart;
    private final int wTex;
    private final int hTex;
    private final ResourceLocation resourceLocation;
    protected int num;
    protected int hoveredNumber;
    protected boolean isHoveredScrollBar;
    private float scrollAmount;
    private boolean canScroll;

    public FixedButtonsList(int x, int y, int w, int h, ResourceLocation resource, int tx, int ty, int tw, int th, int num, Component name, List<E> list, Function<E, Component> listName, PressEntry<E> onPressEntry) {
        super(x, y, w, h, name);
        this.list = list;
        this.listName = listName;
        this.num = num;
        this.onPress = onPressEntry;
        this.resourceLocation = resource;
        this.xTexStart = tx;
        this.yTexStart = ty;
        this.wTex = tw;
        this.hTex = th;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
        this.m_168802_(narrationElementOutput);
    }

    public void m_6305_(PoseStack poseStack, int mx, int my, float parTick) {
        if (this.f_93624_) {
            this.hoveredNumber = (my - this.f_93621_) / this.getOneButtonHeight();
            this.isHoveredScrollBar = mx >= this.f_93620_ + this.getOneButtonWidth() && my >= this.f_93621_ && mx < this.f_93620_ + this.f_93618_ && my < this.f_93621_ + this.f_93619_;
        }
        super.m_6305_(poseStack, mx, my, parTick);
    }

    public void m_6303_(PoseStack poseStack, int mx, int my, float parTick) {
        int cn;
        for (int i = 0; i < this.num && (cn = this.getCurrentFirstNumber() + i) < this.list.size() && cn >= 0; ++i) {
            this.renderOneButton(poseStack, this.getList().get(cn), cn, i, this.f_93620_, this.f_93621_ + this.getOneButtonHeight() * i, mx, my, parTick);
        }
        this.renderScrollbar(poseStack, this.f_93620_ + this.getOneButtonWidth(), this.f_93621_, 9, this.f_93619_);
    }

    protected void renderScrollbar(PoseStack poseStack, int x, int y, int w, int h) {
        boolean hv = this.isHoveredScrollBar();
        OERenderUtil.drawTexture(this.resourceLocation, poseStack, x, y, this.xTexStart + (hv ? 9 : 0), this.yTexStart, 9.0f, 3.0f, this.wTex, this.hTex);
        int bsct = (this.f_93619_ - 6) / 16;
        for (int i = 0; i < bsct; ++i) {
            OERenderUtil.drawTexture(this.resourceLocation, poseStack, x, y + 3 + i * 16, this.xTexStart + (hv ? 9 : 0), this.yTexStart + 3, 9.0f, 16.0f, this.wTex, this.hTex);
        }
        int bsam = (this.f_93619_ - 6) % 16;
        OERenderUtil.drawTexture(this.resourceLocation, poseStack, x, y + 3 + bsct * 16, this.xTexStart + (hv ? 9 : 0), this.yTexStart + 3, 9.0f, bsam, this.wTex, this.hTex);
        OERenderUtil.drawTexture(this.resourceLocation, poseStack, x, y + this.f_93619_ - 3, this.xTexStart + (hv ? 9 : 0), this.yTexStart + 19, 9.0f, 3.0f, this.wTex, this.hTex);
        int barHeight = this.getBarHeight();
        float barY = (float)(this.f_93619_ - 2 - barHeight) * this.scrollAmount;
        OERenderUtil.drawTexture(this.resourceLocation, poseStack, x + 1, (float)(y + 1) + barY, this.xTexStart + (hv ? 7 : 0), this.yTexStart + 22, 7.0f, 3.0f, this.wTex, this.hTex);
        int ssct = (barHeight - 6) / 14;
        for (int i = 0; i < ssct; ++i) {
            OERenderUtil.drawTexture(this.resourceLocation, poseStack, x + 1, (float)(y + 4 + i * 14) + barY, this.xTexStart + (hv ? 7 : 0), this.yTexStart + 25, 7.0f, 14.0f, this.wTex, this.hTex);
        }
        int ssam = (barHeight - 6) % 14;
        OERenderUtil.drawTexture(this.resourceLocation, poseStack, x + 1, (float)(y + 4 + ssct * 14) + barY, this.xTexStart + (hv ? 7 : 0), this.yTexStart + 25, 7.0f, ssam, this.wTex, this.hTex);
        OERenderUtil.drawTexture(this.resourceLocation, poseStack, x + 1, (float)(y + 1 + barHeight - 3) + barY, this.xTexStart + (hv ? 7 : 0), this.yTexStart + 39, 7.0f, 3.0f, this.wTex, this.hTex);
    }

    protected void renderOneButton(PoseStack poseStack, E item, int lnum, int bnum, int x, int y, int mx, int my, float parTick) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93617_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        int k = this.m_7202_(this.isHoveredOrFocused(bnum));
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        this.m_93228_(poseStack, x, y, 0, 46 + k * 20, this.getOneButtonWidth() / 2, this.getOneButtonHeight());
        this.m_93228_(poseStack, x + this.getOneButtonWidth() / 2, y, 200 - this.getOneButtonWidth() / 2, 46 + k * 20, this.getOneButtonWidth() / 2, this.getOneButtonHeight());
        this.m_7906_(poseStack, mc, mx, my);
        int l = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
        FixedButtonsList.m_93215_((PoseStack)poseStack, (Font)FixedButtonsList.mc.f_91062_, (Component)this.getMessage(lnum), (int)(this.f_93620_ + this.getOneButtonWidth() / 2), (int)(y + (this.getOneButtonHeight() - 8) / 2), (int)(l | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
    }

    public List<E> getList() {
        return this.list;
    }

    public boolean isHoveredOrFocused(int lnum) {
        return this.m_198029_() && this.hoveredNumber == lnum && !this.isHoveredScrollBar;
    }

    public Component getMessage(int index) {
        return this.listName.apply(this.list.get(index));
    }

    public int getOneButtonHeight() {
        return this.f_93619_ / this.num;
    }

    public int getOneButtonWidth() {
        return this.f_93618_ - 9;
    }

    public float getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(float d) {
        this.scrollAmount = Mth.m_14036_((float)d, (float)0.0f, (float)1.0f);
    }

    public void m_5716_(double mx, double my) {
        this.onPress((int)((my - (double)this.f_93621_) / (double)this.getOneButtonHeight()));
    }

    public boolean isHoveredScrollBar() {
        return this.m_198029_() && this.isHoveredScrollBar;
    }

    public void onPress(int num) {
        int cn = this.getCurrentFirstNumber() + num;
        if (cn < this.list.size() && this.isHoveredOrFocused(num)) {
            this.onPress.onPressEntry(this, this.list.get(cn), cn, num);
        }
    }

    public int getBarHeight() {
        return Mth.m_14045_((int)((this.f_93619_ - 2) / (this.list.size() / this.num + 1)), (int)10, (int)(this.f_93619_ - 2));
    }

    protected int getCurrentFirstNumber() {
        if (this.list.size() <= this.num) {
            return 0;
        }
        return (int)((float)(this.list.size() - this.num) * this.scrollAmount);
    }

    public boolean m_6375_(double mx, double my, int i) {
        this.canScroll = this.isHoveredScrollBar();
        this.scroll(my);
        return super.m_6375_(mx, my, i);
    }

    public boolean m_7979_(double mx, double my, int i, double f, double g) {
        this.scroll(my);
        return super.m_7979_(mx, my, i, f, g);
    }

    public boolean m_6050_(double d, double e, double f) {
        this.setScrollAmount(this.getScrollAmount() - (float)f * ((float)this.num / (float)this.f_93619_));
        return true;
    }

    public void scroll(double mouseY) {
        if (this.canScroll) {
            int cy = (int)(mouseY - (double)this.f_93621_ - 1.0 - (double)(this.getBarHeight() / 2));
            int sa = this.f_93619_ - 2 - this.getBarHeight();
            if (sa > 0) {
                this.setScrollAmount((float)cy / (float)sa);
            }
        }
    }

    public static interface PressEntry<E> {
        public void onPressEntry(FixedButtonsList<E> var1, E var2, int var3, int var4);
    }
}

