package dev.felnull.otyacraftengine.block;

import dev.architectury.registry.registries.DeferredRegister;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.blockentity.TestBlockEntity;
import dev.felnull.otyacraftengine.util.OEVoxelShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TestBlock extends HorizontalDirectionalEntityBlock {

    public TestBlock(Properties properties) {
        super(properties);
    }

    public static Block TEST_BLOCK;

    public static void init() {
        DeferredRegister<Block> BLOCK_REG = DeferredRegister.create(OtyacraftEngine.MODID, Registry.f_122901_);
        DeferredRegister<Item> ITEM_REG = DeferredRegister.create(OtyacraftEngine.MODID, Registry.f_122904_);
        TEST_BLOCK = new TestBlock(BlockBehaviour.Properties.m_60939_(Material.f_76279_).m_60918_(SoundType.f_56743_));
        BLOCK_REG.register("test_block", () -> TEST_BLOCK);
        ITEM_REG.register("test_block", () -> new BlockItem(TEST_BLOCK, new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
        ITEM_REG.register();
        BLOCK_REG.register();
    }

    @Nullable
    @Override
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new TestBlockEntity(blockPos, blockState);
    }

    @Override
    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.INVISIBLE;
    }

    private static final VoxelShape testShape = Shapes.m_83048_(0.3, 0.3, 0.3, 0.7, 0.7, 0.7);

    @Override
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return testShape;
    }

    private static final VoxelShape shape = OEVoxelShapeUtil.rotateBoxY90(OEVoxelShapeUtil.getShapeFromResource(new ResourceLocation(OtyacraftEngine.MODID, "sample")));

    /*@Override
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return shape;
    }*/

    @Override
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (!level.m_5776_()) {
            openContainer(level, blockPos, (ServerPlayer) player, blockState, blockHitResult.m_82434_());
        }
        return InteractionResult.m_19078_(level.m_5776_());
    }

    @Nullable
    @Override
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return m_152132_(blockEntityType, TestBlockEntity.TEST_BLOCKENTITY, TestBlockEntity::tick);
    }
}
