package dev.felnull.otyacraftengine.client.gui.screen.debug;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.client.gui.screen.OEBaseScreen;
import dev.felnull.otyacraftengine.client.gui.screen.debug.rendertest.BakedModelRenderTest;
import dev.felnull.otyacraftengine.client.gui.screen.debug.rendertest.IRenderTest;
import dev.felnull.otyacraftengine.client.gui.screen.debug.rendertest.ItemRenderTest;
import dev.felnull.otyacraftengine.client.util.OEClientUtil;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.ArrayList;
import java.util.List;

public class RenderTestScreen extends OEBaseScreen {
    private static final List<IRenderTest> renderTests = new ArrayList<>();
    private int currentTest;
    private long eqAll;
    private long lastTime = -1;
    private long rtAll;
    private int sampleCount;
    private int testCount = 1;
    private Motion motion = Motion.FIX;
    private Vector3f cameraPos = new Vector3f(0, 0, 1);
    private Vector3f cameraRot = new Vector3f();

    private EditBox countBox;

    public RenderTestScreen(@Nullable Screen parent) {
        super(new TextComponent("Render Test"), parent);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_(new Button(3, f_96544_ - 23, 100, 20, CommonComponents.f_130660_, n -> mc.m_91152_(getParentScreen())));
        this.m_142416_(new Button(106, f_96544_ - 23, 100, 20, new TextComponent("Reset"), n -> reset()));

        this.countBox = this.m_142416_(new EditBox(mc.f_91062_, 209, f_96544_ - 23, 70, 20, new TextComponent("Count")));
        this.countBox.m_94144_(String.valueOf(testCount));
        this.countBox.m_94151_(n -> {
            if (!n.isEmpty()) {
                try {
                    int val = Integer.parseInt(n);
                    if (val < 0) {
                        this.countBox.m_94144_("0");
                    } else {
                        setCount(val);
                    }
                } catch (NumberFormatException e) {
                    this.countBox.m_94144_("0");
                }
            } else {
                this.countBox.m_94144_("0");
            }
        });

        this.m_142416_(new Button(282, f_96544_ - 23, 20, 20, new TextComponent("-1"), n -> this.countBox.m_94144_(String.valueOf(testCount - 1))));
        this.m_142416_(new Button(305, f_96544_ - 23, 20, 20, new TextComponent("+1"), n -> this.countBox.m_94144_(String.valueOf(testCount + 1))));

        this.m_142416_(new Button(328, f_96544_ - 23, 100, 20, new TextComponent("Motion: " + motion.name()), n -> {
            motion = Motion.values()[(motion.ordinal() + 1) % Motion.values().length];
            n.m_93666_(new TextComponent("Motion: " + motion.name()));
        }));

        if (!renderTests.isEmpty()) {
            this.m_142416_(new Button(f_96543_ - 23, 3, 20, 20, new TextComponent("->"), n -> {
                currentTest = (currentTest + 1) % renderTests.size();
                reset();
            }));
            this.m_142416_(new Button(f_96543_ - 46, 3, 20, 20, new TextComponent("<-"), n -> {
                currentTest = (currentTest - 1) % renderTests.size();
                if (currentTest < 0)
                    currentTest = renderTests.size() - 1;
                reset();
            }));
        }

        reset();
    }

    private void setCount(int count) {
        testCount = count;
    }

    @Override
    public void m_6305_(@NotNull PoseStack poseStack, int mx, int my, float f) {
        long rt = System.nanoTime() - lastTime;
        if (lastTime >= 0)
            rtAll += rt;

        this.m_96626_(0);
        float sy = f_96544_ - f_96544_ / 4f;
        drawRelativeFill(poseStack, 0, 0, f_96543_, sy, 0xFFFFFFFF);
        drawRelativeFill(poseStack, 0, 0, f_96543_, sy - 1f, 0xFF000000);
        super.m_6305_(poseStack, mx, my, f);

        if (renderTests.isEmpty()) return;

        MultiBufferSource.BufferSource buf = mc.m_91269_().m_110104_();

        long st = System.nanoTime();
        renderTest(poseStack, buf, f, testCount);
        long eq = System.nanoTime() - st;

        buf.m_109911_();

        eqAll += eq;
        sampleCount++;
        float eqAvg = (float) eqAll / (float) sampleCount;
        float rtAvg = (float) rtAll / (float) (sampleCount - 1);

        drawTextBase(poseStack, mc.f_90977_, 3f, sy, 0xFFFFFF);

        drawTextBase(poseStack, String.format("Rendering Time: %.3fms %06dns", eq / 1000000f, eq), 3f, sy + mc.f_91062_.f_92710_ + 1, 0xFFFFFF);
        drawTextBase(poseStack, String.format("Rendering Average Time: %.3fms %06dns", eqAvg / 1000000f, (int) eqAvg), 3f, sy + (mc.f_91062_.f_92710_ + 1) * 2, 0xFFFFFF);

        drawTextBase(poseStack, String.format("Return Time: %.3fms %06dns", rt / 1000000f, rt), 3f + f_96543_ / 2f, sy + mc.f_91062_.f_92710_ + 1, 0xFFFFFF);
        drawTextBase(poseStack, String.format("Return Average Time: %.3fms %06dns", rtAvg / 1000000f, (int) rtAvg), 3f + f_96543_ / 2f, sy + (mc.f_91062_.f_92710_ + 1) * 2, 0xFFFFFF);

        lastTime = System.nanoTime();
    }

    @Override
    public void m_96624_() {
        super.m_96624_();
        if (motion == Motion.FREE_LOOK) {
            float speed = 1;
            if (OEClientUtil.isKeyInput(mc.f_91066_.f_92085_)) {
                cameraPos.m_122272_(0, -speed, 0);
            }
            if (OEClientUtil.isKeyInput(mc.f_91066_.f_92087_)) {
                cameraPos.m_122272_(0, speed, 0);
            }
            if (OEClientUtil.isKeyInput(mc.f_91066_.f_92088_)) {
                cameraPos.m_122272_(speed, 0, 0);
            }
            if (OEClientUtil.isKeyInput(mc.f_91066_.f_92086_)) {
                cameraPos.m_122272_(-speed, 0, 0);
            }
            if (OEClientUtil.isKeyInput(mc.f_91066_.f_92091_)) {
                cameraPos = new Vector3f(0, 0, 1);
                cameraRot = new Vector3f();
            }
        }
    }

    @Override
    public boolean m_7979_(double d, double e, int i, double f, double g) {
        if (motion == Motion.FREE_LOOK)
            cameraRot.m_122272_(-(float) g, (float) f, 0);
        return super.m_7979_(d, e, i, f, g);
    }

    @Override
    public boolean m_6050_(double d, double e, double f) {
        if (motion == Motion.FREE_LOOK) {
            cameraPos.m_122272_(0, 0, (float) f * (OEClientUtil.isKeyInput(mc.f_91066_.f_92090_) ? 0.5f : 1f));
            cameraPos.m_122245_(cameraPos.m_122239_(), cameraPos.m_122260_(), Math.max(cameraPos.m_122269_(), 1));
        }
        return super.m_6050_(d, e, f);
    }

    private void reset() {
        eqAll = 0;
        sampleCount = 0;
        lastTime = -1;
        rtAll = 0;
    }

    private void renderTest(@NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, float f, int count) {
        float sy = f_96544_ - f_96544_ / 4f;

        poseStack.m_85836_();

        if (motion != Motion.TRANSLATED && motion != Motion.ROTED && motion != Motion.BOTH) {
            double x = f_96543_ / 2f;
            double y = sy / 2f;

            if (motion == Motion.FREE_LOOK) {
                x += cameraPos.m_122239_() * cameraPos.m_122269_();
                y += cameraPos.m_122260_() * cameraPos.m_122269_();


                poseStack.m_85837_(x, y, 30);
                OERenderUtil.poseRotateAll(poseStack, cameraRot.m_122239_(), cameraRot.m_122260_(), cameraRot.m_122269_());
                poseStack.m_85837_(-x, -y, -30);
            }

            poseStack.m_85837_(x, y, 1050.0D);
            poseStack.m_85841_(1, 1, -1);
            poseStack.m_85837_(0.0D, 0.0D, 1000);
            poseStack.m_85841_((float) 30, (float) -30, (float) 30);

            if (motion == Motion.FREE_LOOK)
                OERenderUtil.poseScaleAll(poseStack, cameraPos.m_122269_());
        }

        for (int i = 0; i < count; i++) {
            float sp = OERenderUtil.getParSecond(5000) + (1f / count) * i;
            if (sp > 1)
                sp -= 1;
            poseStack.m_85836_();

            double x = f_96543_ / 2f;
            double y = sy / 2f;

            if (motion == Motion.TRANSLATED || motion == Motion.BOTH) {
                float par = (float) (sp * Math.toRadians(360));
                x += Math.sin(par) * ((f_96543_ / 2f) - 30);
                y += Math.sin(2 * par) * ((sy / 2) - 30);
            }

            if (motion == Motion.ROTED || motion == Motion.BOTH) {
                poseStack.m_85837_(x, y, 30);
                OERenderUtil.poseRotateX(poseStack, sp * 360);
                OERenderUtil.poseRotateY(poseStack, sp * 360);
                OERenderUtil.poseRotateZ(poseStack, sp * 360);
                poseStack.m_85837_(-x, -y, -30);
            }

            if (motion == Motion.TRANSLATED || motion == Motion.ROTED || motion == Motion.BOTH) {
                poseStack.m_85837_(x, y, 1050.0D);
                poseStack.m_85841_(1, 1, -1);
                poseStack.m_85837_(0.0D, 0.0D, 1000);
                poseStack.m_85841_((float) 30, (float) -30, (float) 30);
            }

            renderTest(poseStack, multiBufferSource, f);

            poseStack.m_85849_();
        }

        poseStack.m_85849_();
    }

    private void renderTest(@NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, float f) {
        var rt = renderTests.get(currentTest);
        rt.renderTest(poseStack, multiBufferSource, f);
    }

    public static void addRenderTest(IRenderTest renderTest) {
        renderTests.add(renderTest);
    }

    public static void fInit() {
        // for (Item item : Registry.ITEM) {
        //      addRenderTest(new ItemRenderTest(item));
        //  }
        //10000
        addRenderTest(new BakedModelRenderTest(new ResourceLocation(OtyacraftEngine.MODID, "block/test_model")));//23.5 26.7
        addRenderTest(new BakedModelRenderTest(new ResourceLocation(OtyacraftEngine.MODID, "item/test_item_kame")));//144.5*10 32.6*10
        addRenderTest(new ItemRenderTest(Items.f_42410_));//44.2 56.5
        addRenderTest(new ItemRenderTest(Items.f_41913_));//13.0 17.7
    }

    private static enum Motion {
        FIX, TRANSLATED, ROTED, BOTH, FREE_LOOK;
    }
}
