package dev.felnull.otyacraftengine.blockentity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface IClientSyncableBlockEntity {
    boolean isSyncUpdate();

    void saveToUpdateTag(CompoundTag tag);

    default void loadToUpdateTag(CompoundTag tag) {
        if (this instanceof BlockEntity blockEntity)
            blockEntity.m_142466_(tag);
    }

    default void syncToClient() {
        if (this instanceof BlockEntity blockEntity && isSyncUpdate())
            blockEntity.m_58904_().m_7260_(blockEntity.m_58899_(), blockEntity.m_58900_(), blockEntity.m_58900_(), Block.f_152394_);
    }
}
