/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import dev.felnull.fnjl.util.FNURLUtil;
import dev.felnull.otyacraftengine.explatform.OEExpectPlatform;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class OEUtils {
    private static final Gson GSON = new Gson();

    public static JsonObject getURLJson(URL url) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(new BufferedInputStream(FNURLUtil.getStream(url)));){
            JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            return jsonObject;
        }
    }

    public static CompletableFuture<JsonObject> getURLJsonAsync(URL url) {
        return FNURLUtil.getStreamAsync(url).thenApplyAsync(ret -> {
            JsonObject jsonObject;
            if (ret == null) {
                return null;
            }
            InputStreamReader reader = new InputStreamReader(new BufferedInputStream((InputStream)ret));
            try {
                jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return null;
                }
            }
            ((Reader)reader).close();
            return jsonObject;
        });
    }

    public static <T> List<T> getCallPoints(@NotNull String name, @NotNull Class<?> annotationClass, @NotNull Class<T> interfaceClass) {
        return OEExpectPlatform.getCallPoints(name, annotationClass, interfaceClass);
    }
}

