/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.util;

import dev.felnull.otyacraftengine.server.level.TagSerializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OENbtUtils {
    public static final int TAG_UUID = 11;

    @NotNull
    public static <T> CompoundTag writeList(@NotNull CompoundTag tag, @NotNull String name, @Nullable List<T> list, @NotNull Function<T, Tag> writer) {
        if (list != null) {
            ListTag listTag = new ListTag();
            list.forEach(n -> listTag.add((Object)((Tag)writer.apply(n))));
            tag.m_128365_(name, (Tag)listTag);
        }
        return tag;
    }

    @NotNull
    public static CompoundTag writeUUIDList(@NotNull CompoundTag tag, @NotNull String name, @Nullable List<UUID> uuids) {
        return OENbtUtils.writeList(tag, name, uuids, NbtUtils::m_129226_);
    }

    @NotNull
    public static <T> List<T> readList(@NotNull CompoundTag tag, @NotNull String name, @Nullable List<T> list, @NotNull Function<Tag, T> reader, int num) {
        if (list != null) {
            list.clear();
        } else {
            list = new ArrayList<T>();
        }
        ListTag listTag = tag.m_128437_(name, num);
        for (Tag lstag : listTag) {
            list.add(reader.apply(lstag));
        }
        return list;
    }

    @NotNull
    public static List<UUID> readUUIDList(@NotNull CompoundTag tag, @NotNull String name, @Nullable List<UUID> uuids) {
        return OENbtUtils.readList(tag, name, uuids, NbtUtils::m_129233_, 11);
    }

    @NotNull
    public static <T extends TagSerializable> CompoundTag writeSerializableList(@NotNull CompoundTag tag, @NotNull String name, @Nullable List<T> serializableList) {
        return OENbtUtils.writeList(tag, name, serializableList, TagSerializable::createSavedTag);
    }

    @NotNull
    public static <T extends TagSerializable> List<T> readSerializableList(@NotNull CompoundTag tag, @NotNull String name, @Nullable List<T> serializableList, @NotNull Supplier<T> initSerializable) {
        return OENbtUtils.readList(tag, name, serializableList, tag1 -> TagSerializable.loadSavedTag((CompoundTag)tag1, (TagSerializable)initSerializable.get()), 10);
    }

    @NotNull
    public static <T, M> CompoundTag writeMap(@NotNull CompoundTag tag, @NotNull String name, @Nullable Map<T, M> map, @NotNull Function<T, Tag> keyWriter, @NotNull Function<M, Tag> valueWriter) {
        if (map != null) {
            ArrayList<T> key = new ArrayList<T>(map.keySet());
            ArrayList<M> value = new ArrayList<M>(map.values());
            CompoundTag mt = new CompoundTag();
            OENbtUtils.writeList(mt, "k", key, keyWriter);
            OENbtUtils.writeList(mt, "v", value, valueWriter);
            tag.m_128365_(name, (Tag)mt);
        }
        return tag;
    }

    @NotNull
    public static <T, M> Map<T, M> readMap(@NotNull CompoundTag tag, @NotNull String name, @Nullable Map<T, M> map, @NotNull Function<Tag, T> keyReader, @NotNull Function<Tag, M> valueReader, int keyNum, int valueNum) {
        if (map != null) {
            map.clear();
        } else {
            map = new HashMap<T, M>();
        }
        CompoundTag mt = tag.m_128469_(name);
        List<T> kr = OENbtUtils.readList(mt, "k", null, keyReader, keyNum);
        List<M> vr = OENbtUtils.readList(mt, "v", null, valueReader, valueNum);
        if (kr.size() != vr.size()) {
            throw new IllegalArgumentException("The count of key and value do not match.");
        }
        for (int i = 0; i < kr.size(); ++i) {
            T k = kr.get(i);
            M v = vr.get(i);
            map.put(k, v);
        }
        return map;
    }

    @NotNull
    public static <T> CompoundTag writeUUIDKeyMap(@NotNull CompoundTag tag, @NotNull String name, @Nullable Map<UUID, T> map, @NotNull Function<T, Tag> valueWriter) {
        return OENbtUtils.writeMap(tag, name, map, NbtUtils::m_129226_, valueWriter);
    }

    @NotNull
    public static <T> Map<UUID, T> readUUIDKeyMap(@NotNull CompoundTag tag, @NotNull String name, @Nullable Map<UUID, T> map, @NotNull Function<Tag, T> valueReader, int valueNum) {
        return OENbtUtils.readMap(tag, name, map, NbtUtils::m_129233_, valueReader, 11, valueNum);
    }

    @NotNull
    public static CompoundTag writeUUIDMap(@NotNull CompoundTag tag, @NotNull String name, @Nullable Map<UUID, UUID> map) {
        return OENbtUtils.writeUUIDKeyMap(tag, name, map, NbtUtils::m_129226_);
    }

    @NotNull
    public static Map<UUID, UUID> readUUIDMap(@NotNull CompoundTag tag, @NotNull String name, @Nullable Map<UUID, UUID> map) {
        return OENbtUtils.readUUIDKeyMap(tag, name, map, NbtUtils::m_129233_, 11);
    }

    @NotNull
    public static CompoundTag writeUUIDTagMap(@NotNull CompoundTag tag, @NotNull String name, @Nullable Map<UUID, CompoundTag> map) {
        return OENbtUtils.writeUUIDKeyMap(tag, name, map, tag1 -> tag1);
    }

    @NotNull
    public static Map<UUID, CompoundTag> readUUIDTagMap(@NotNull CompoundTag tag, @NotNull String name, @Nullable Map<UUID, CompoundTag> map) {
        return OENbtUtils.readUUIDKeyMap(tag, name, map, tag1 -> (CompoundTag)tag1, 10);
    }

    @NotNull
    public static <T extends TagSerializable> CompoundTag writeUUIDSerializableMap(@NotNull CompoundTag tag, @NotNull String name, @Nullable Map<UUID, T> map) {
        return OENbtUtils.writeUUIDKeyMap(tag, name, map, TagSerializable::createSavedTag);
    }

    @NotNull
    public static <T extends TagSerializable> Map<UUID, T> readUUIDSerializableMap(@NotNull CompoundTag tag, @NotNull String name, @Nullable Map<UUID, T> map, @NotNull Supplier<T> initSerializable) {
        return OENbtUtils.readUUIDKeyMap(tag, name, map, tag1 -> TagSerializable.loadSavedTag((CompoundTag)tag1, (TagSerializable)initSerializable.get()), 10);
    }

    @NotNull
    public static CompoundTag writeEnumByOrdinal(@NotNull CompoundTag tag, @NotNull String name, @NotNull Enum<?> enum_) {
        tag.m_128405_(name, enum_.ordinal());
        return tag;
    }

    public static <T extends Enum<T>> T readEnumByOrdinal(@NotNull CompoundTag tag, @NotNull String name, @NotNull Class<T> enumClass, @Nullable T defaultEnum) {
        Enum[] ens = (Enum[])enumClass.getEnumConstants();
        int num = tag.m_128451_(name);
        if (num < 0 || ens.length <= num) {
            return defaultEnum;
        }
        return (T)ens[num];
    }

    @NotNull
    public static CompoundTag writeEnum(@NotNull CompoundTag tag, @NotNull String name, @NotNull Enum<? extends StringRepresentable> enum_) {
        tag.m_128359_(name, ((StringRepresentable)enum_).m_7912_());
        return tag;
    }

    public static <T extends Enum<T>> T readEnum(@NotNull CompoundTag tag, @NotNull String name, @NotNull Class<T> enumClass, @Nullable T defaultEnum) {
        Enum[] ens = (Enum[])enumClass.getEnumConstants();
        String n = tag.m_128461_(name);
        for (Enum en : ens) {
            if (!((StringRepresentable)en).m_7912_().equals(n)) continue;
            return (T)en;
        }
        return defaultEnum;
    }
}

