package dev.felnull.otyacraftengine.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.otyacraftengine.client.gui.TextureSpecify;
import dev.felnull.otyacraftengine.client.gui.components.base.OEBaseWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

import java.util.function.Consumer;

public class IconButton extends OEBaseWidget {
    @NotNull
    private final Consumer<IconButton> onPress;
    @NotNull
    protected TextureSpecify iconTexture;

    public IconButton(int x, int y, int width, int height, @NotNull Component message, @NotNull TextureSpecify iconTexture, @NotNull Consumer<IconButton> onPress) {
        super(x, y, width, height, "button", message);
        this.onPress = onPress;
        this.iconTexture = iconTexture;
    }

    @Override
    public void onPress() {
        onPress.accept(this);
    }

    public @NotNull
    TextureSpecify getIconTexture() {
        return iconTexture;
    }

    public void setIconTexture(@NotNull TextureSpecify iconTexture) {
        this.iconTexture = iconTexture;
    }

    @Override
    public void m_6303_(@NotNull PoseStack poseStack, int i, int j, float f) {
        Minecraft minecraft = Minecraft.m_91087_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_(0, f_93617_);
        RenderSystem.m_157429_(1.0F, 1.0F, 1.0F, this.f_93625_);
        int k = this.m_7202_(this.m_198029_());
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        this.m_93228_(poseStack, this.f_93620_, this.f_93621_, 0, 46 + k * 20, this.f_93618_ / 2, this.f_93619_);
        this.m_93228_(poseStack, this.f_93620_ + this.f_93618_ / 2, this.f_93621_, 200 - this.f_93618_ / 2, 46 + k * 20, this.f_93618_ / 2, this.f_93619_);
        this.m_7906_(poseStack, minecraft, i, j);
        renderIcon(poseStack, i, j, f);
    }

    protected void renderIcon(@NotNull PoseStack poseStack, int i, int j, float f) {
        iconTexture.draw(poseStack, f_93620_ + (f_93618_ - iconTexture.getWidth()) / 2f, f_93621_ + (f_93619_ - iconTexture.getHeight()) / 2f);
    }
}
