package dev.felnull.otyacraftengine.client.handler;

import dev.architectury.networking.NetworkManager;
import dev.felnull.otyacraftengine.client.gui.screen.IInstructionBEScreen;
import dev.felnull.otyacraftengine.client.gui.screen.IInstructionItemScreen;
import dev.felnull.otyacraftengine.networking.OEPackets;
import net.minecraft.client.Minecraft;

public class ClientMessageHandler {
    private static final Minecraft mc = Minecraft.m_91087_();

    public static void onBlockEntityInstructionReturn(OEPackets.BlockEntityInstructionMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            if (!message.blockEntityExistence().check(mc.f_91073_))
                return;
            if (mc.f_91080_ instanceof IInstructionBEScreen insScreen && insScreen.getInstructionID().equals(message.instructionScreenID()))
                insScreen.onInstructionReturn(message.name(), message.data());
        });
    }

    public static void onItemInstructionReturn(OEPackets.ItemInstructionMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            if (!message.itemExistence().check(mc.f_91074_))
                return;
            if (mc.f_91080_ instanceof IInstructionItemScreen insScreen && insScreen.getInstructionID().equals(message.instructionScreenID()))
                insScreen.onInstructionReturn(message.name(), message.data());
        });
    }
}
