package dev.felnull.otyacraftengine.block;

import com.google.common.collect.ImmutableList;
import dev.felnull.otyacraftengine.blockentity.IDroppedBlockEntity;
import dev.felnull.otyacraftengine.util.OEItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;
import java.util.Collection;
import java.util.List;

public abstract class OEBaseEntityBlock extends BaseEntityBlock {
    protected OEBaseEntityBlock(Properties properties) {
        super(properties);
    }

    @Override
    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        super.m_6402_(level, blockPos, blockState, livingEntity, itemStack);
        if (itemStack.m_41788_()) {
            if (level.m_7702_(blockPos) instanceof BaseContainerBlockEntity container) {
                container.m_58638_(itemStack.m_41786_());
            }
        }
    }

    @Override
    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (!blockState.m_60713_(blockState2.m_60734_())) {
            var be = level.m_7702_(blockPos);
            if (!level.m_5776_() && level instanceof ServerLevel) {
                if (be instanceof IDroppedBlockEntity droppedBlockEntity) {
                    if (!droppedBlockEntity.isRetainDrop()) {
                        var drops = droppedBlockEntity.getDroppedItems();
                        NonNullList<ItemStack> items = NonNullList.m_122779_();
                        items.addAll(drops);
                        Containers.m_19010_(level, blockPos, items);
                    }
                } else if (be instanceof Container container) {
                    Containers.m_19002_(level, blockPos, container);
                }
            }
        }
        super.m_6810_(blockState, level, blockPos, blockState2, bl);
    }

    @Override
    public void m_5707_(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        var be = level.m_7702_(blockPos);
        if (be instanceof IDroppedBlockEntity droppedBlockEntity && droppedBlockEntity.isRetainDrop()) {
            if (!level.f_46443_ && player.m_7500_()) {
                var dropItem = droppedBlockEntity.createRetainDropItem();
                if (!dropItem.m_41619_()) {
                    if (be instanceof BaseContainerBlockEntity named) {
                        if (named.m_8077_())
                            dropItem.m_41714_(named.m_7770_());
                    }

                    var itemEntity = OEItemUtils.createItemEntity(dropItem, level, (double) blockPos.m_123341_() + 0.5D, (double) blockPos.m_123342_() + 0.5D, (double) blockPos.m_123343_() + 0.5D);
                    level.m_7967_(itemEntity);
                }
            }
        }
        super.m_5707_(level, blockPos, blockState, player);
    }

    @Override
    public List<ItemStack> m_7381_(BlockState blockState, LootContext.Builder builder) {
        var blockEntity = builder.m_78982_(LootContextParams.f_81462_);
        if (blockEntity instanceof IDroppedBlockEntity icbe && icbe.isRetainDrop())
            return ImmutableList.of(icbe.createRetainDropItem());

        return super.m_7381_(blockState, builder);
    }
}
