/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.blockentity;

import dev.felnull.otyacraftengine.blockentity.IDroppedBlockEntity;
import dev.felnull.otyacraftengine.blockentity.IOEBaseFuncBlockEntity;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OEBaseContainerBlockEntity
extends BaseContainerBlockEntity
implements IDroppedBlockEntity,
IOEBaseFuncBlockEntity {
    private boolean updateMark;

    protected OEBaseContainerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public void setUpdateMarked(boolean marked) {
        this.updateMark = marked;
    }

    @Override
    public boolean isUpdateMarked() {
        return this.updateMark;
    }

    @NotNull
    public abstract NonNullList<ItemStack> getItems();

    public int m_6643_() {
        return this.getItems().size();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        if (!this.isSyncUpdate()) {
            return null;
        }
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.saveToUpdateTag(tag);
        return tag;
    }

    @Override
    public void saveToUpdateTag(CompoundTag tag) {
        ContainerHelper.m_18973_((CompoundTag)tag, this.getItems());
    }

    @Override
    public boolean isSyncUpdate() {
        return true;
    }

    public boolean m_7983_() {
        return this.getItems().stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int i) {
        return (ItemStack)this.getItems().get(i);
    }

    public ItemStack m_7407_(int i, int j) {
        return ContainerHelper.m_18969_(this.getItems(), (int)i, (int)j);
    }

    public ItemStack m_8016_(int i) {
        return ContainerHelper.m_18966_(this.getItems(), (int)i);
    }

    public void m_6836_(int i, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.getItems().get(i);
        boolean flag = !stack.m_41619_() && stack.m_41656_(itemstack) && ItemStack.m_41658_((ItemStack)stack, (ItemStack)itemstack);
        this.getItems().set(i, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (flag) {
            this.m_6596_();
        }
        this.syncToClient();
    }

    public boolean m_6542_(@NotNull Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return this.isUsableByPlayer(player);
    }

    public void m_6211_() {
        this.getItems().clear();
    }

    public boolean isUsableByPlayer(Player player) {
        return this.m_58904_().m_7702_(this.m_58899_()) == this && player.m_20275_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5) <= 64.0;
    }

    @Override
    public Collection<ItemStack> getDroppedItems() {
        return this.getItems();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ContainerHelper.m_18980_((CompoundTag)tag, this.getItems());
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.getItems());
    }

    protected ItemStack getDropItem() {
        return ItemStack.f_41583_;
    }

    @Override
    public ItemStack createRetainDropItem() {
        ItemStack itm = this.getDropItem();
        if (itm.m_41619_()) {
            return itm;
        }
        itm = itm.m_41777_();
        this.m_187476_(itm);
        return itm;
    }
}

