/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.util;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.platform.NativeImage;
import dev.felnull.otyacraftengine.client.entity.ClientPlayerInfoManager;
import dev.felnull.otyacraftengine.client.renderer.texture.DynamicGifTexture;
import dev.felnull.otyacraftengine.client.renderer.texture.NativeTextureLoadResult;
import dev.felnull.otyacraftengine.client.renderer.texture.NativeTextureManager;
import dev.felnull.otyacraftengine.client.renderer.texture.TextureLoadProgress;
import dev.felnull.otyacraftengine.client.renderer.texture.TextureLoadProgressImpl;
import dev.felnull.otyacraftengine.client.renderer.texture.TextureScale;
import dev.felnull.otyacraftengine.client.renderer.texture.URLTextureLoadResult;
import dev.felnull.otyacraftengine.client.renderer.texture.URLTextureManager;
import dev.felnull.otyacraftengine.include.com.madgag.gif.fmsware.GifDecoder;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.math.FNVec2d;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNMath;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OETextureUtils {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final ResourceLocation ERROR_ICON = new ResourceLocation("otyacraftengine", "textures/gui/error_icon.png");
    private static ResourceLocation LOADING_ICON;

    @NotNull
    public static DynamicTexture createNativeTexture(@NotNull InputStream stream, @Nullable Consumer<TextureLoadProgress> progress) throws IOException {
        if (progress != null) {
            progress.accept(new TextureLoadProgressImpl("Image loading", 1, 0));
        }
        byte[] data = stream.readAllBytes();
        if (progress != null) {
            progress.accept(new TextureLoadProgressImpl("Image loading", 1, 1));
        }
        try (ByteArrayInputStream istream = new ByteArrayInputStream(data);){
            GifDecoder decoder = new GifDecoder();
            if (decoder.read(istream) == 0) {
                DynamicGifTexture dynamicGifTexture = DynamicGifTexture.create(decoder, progress);
                return dynamicGifTexture;
            }
        }
        istream = new ByteArrayInputStream(data);
        try {
            DynamicTexture dynamicTexture = new DynamicTexture(NativeImage.m_85058_((InputStream)istream));
            return dynamicTexture;
        }
        finally {
            istream.close();
        }
    }

    public static synchronized void freeTexture(@NotNull ResourceLocation location) {
        TextureManager textureManager = mc.m_91097_();
        AbstractTexture abstractTexture = (AbstractTexture)textureManager.f_118468_.get(location);
        if (abstractTexture != null) {
            if (abstractTexture instanceof Tickable) {
                textureManager.f_118469_.remove(abstractTexture);
            }
            textureManager.m_118508_(location, abstractTexture);
        }
    }

    @NotNull
    public static NativeTextureLoadResult getAndLoadNativeTextureAsync(@NotNull UUID uuid, @NotNull InputStream stream) {
        return NativeTextureManager.getInstance().getAndLoadTextureAsync(uuid, stream);
    }

    @NotNull
    public static NativeTextureLoadResult getAndLoadNativeTexture(@NotNull UUID uuid, @NotNull InputStream stream) {
        return NativeTextureManager.getInstance().getAndLoadTexture(uuid, stream);
    }

    @Nullable
    public static NativeTextureLoadResult getNativeTexture(@NotNull UUID uuid) {
        return NativeTextureManager.getInstance().getTexture(uuid);
    }

    @NotNull
    public static URLTextureLoadResult getAndLoadURLTextureAsync(@NotNull String url, boolean cached) {
        return URLTextureManager.getInstance().getAndLoadUrlTextureAsync(url, cached);
    }

    @NotNull
    public static ResourceLocation getLoadingIcon() {
        if (LOADING_ICON == null) {
            ResourceManager rm = mc.m_91098_();
            Optional r = rm.m_213713_(new ResourceLocation("otyacraftengine", "textures/gui/loading_icon.gif"));
            if (r.isPresent()) {
                try (InputStream st = ((Resource)r.get()).m_215507_();){
                    NativeTextureLoadResult ret = OETextureUtils.getAndLoadNativeTexture(UUID.randomUUID(), st);
                    if (ret.isSuccess()) {
                        LOADING_ICON = ret.getLocation();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (LOADING_ICON == null) {
                throw new IllegalStateException("Failed to loading icon being loaded.");
            }
        }
        return LOADING_ICON;
    }

    @NotNull
    public static ResourceLocation getErrorIcon() {
        return ERROR_ICON;
    }

    @Nullable
    public static ResourceLocation getPlayerTexture(MinecraftProfileTexture.Type type, @NotNull UUID uuid) {
        return ClientPlayerInfoManager.getInstance().getPlayerTexture(type, uuid);
    }

    @Nullable
    public static ResourceLocation getPlayerTexture(MinecraftProfileTexture.Type type, @NotNull String name) {
        return ClientPlayerInfoManager.getInstance().getPlayerTexture(type, name);
    }

    @Nullable
    public static ResourceLocation getPlayerElytraTexture(@NotNull String name) {
        return OETextureUtils.getPlayerTexture(MinecraftProfileTexture.Type.ELYTRA, name);
    }

    @Nullable
    public static ResourceLocation getPlayerCapeTexture(@NotNull String name) {
        return OETextureUtils.getPlayerTexture(MinecraftProfileTexture.Type.CAPE, name);
    }

    @NotNull
    public static ResourceLocation getPlayerSkinTexture(@NotNull String name) {
        return Objects.requireNonNull(OETextureUtils.getPlayerTexture(MinecraftProfileTexture.Type.SKIN, name));
    }

    @Nullable
    public static ResourceLocation getPlayerElytraTexture(@NotNull UUID uuid) {
        return OETextureUtils.getPlayerTexture(MinecraftProfileTexture.Type.ELYTRA, uuid);
    }

    @Nullable
    public static ResourceLocation getPlayerCapeTexture(@NotNull UUID uuid) {
        return OETextureUtils.getPlayerTexture(MinecraftProfileTexture.Type.CAPE, uuid);
    }

    @NotNull
    public static ResourceLocation getPlayerSkinTexture(@NotNull UUID uuid) {
        return Objects.requireNonNull(OETextureUtils.getPlayerTexture(MinecraftProfileTexture.Type.SKIN, uuid));
    }

    public static TextureScale getTextureScale(ResourceLocation location) {
        AbstractTexture abstractTexture;
        if (location != null && (abstractTexture = mc.m_91097_().m_118506_(location)) instanceof DynamicTexture) {
            DynamicTexture texture = (DynamicTexture)abstractTexture;
            int w = texture.m_117991_().m_84982_();
            int h = texture.m_117991_().m_85084_();
            FNVec2d sc = FNMath.scale(w, h);
            return new TextureScale(sc.getX(), sc.getY());
        }
        return null;
    }
}

