package dev.felnull.otyacraftengine.client.handler;

import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.platform.Platform;
import dev.felnull.otyacraftengine.client.debug.OtyacraftEngineClientDebug;
import dev.felnull.otyacraftengine.util.OEEntityUtils;
import dev.felnull.otyacraftengine.util.OEItemUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.*;

import java.util.*;


public class ClientDebugHandler {
    public static void init() {
        ClientTooltipEvent.ITEM.register(ClientDebugHandler::onTooltip);
    }

    private static void onTooltip(ItemStack stack, List<Component> lines, TooltipFlag flag) {
        if (stack.m_41619_()) return;
        var oed = OtyacraftEngineClientDebug.getInstance();
        if (oed.isShowTagInTooltip()) {
            var itemTags = new ArrayList<>(stack.m_204131_().map(TagKey::f_203868_).toList());

            if (stack.m_41720_() instanceof BlockItem blockItem) {
                var blockTags = new ArrayList<>(blockItem.m_40614_().m_49966_().m_204343_().map(TagKey::f_203868_).toList());
                Set<ResourceLocation> bothTags = new TreeSet<>();
                for (ResourceLocation tag : itemTags) {
                    if (blockTags.contains(tag))
                        bothTags.add(tag);
                }
                itemTags.removeAll(bothTags);
                blockTags.removeAll(bothTags);
                addTagList(lines, "Item tags", itemTags);
                addTagList(lines, "Block tags", blockTags);
                addTagList(lines, "Both tags", bothTags);
            } else {
                addTagList(lines, "Item tags", itemTags);
            }

            var entityTypes = getEntityTypesByItem(stack);
            var entityTypeTags = entityTypes.stream().flatMap(OEEntityUtils::getTags).map(TagKey::f_203868_).toList();
            addTagList(lines, "Entity tags", entityTypeTags);
        }

        if (oed.isShowModNameInTooltip()) {
            var modid = OEItemUtils.getCreatorModId(stack);
            lines.add(Component.m_237113_(Platform.getMod(modid).getName()).m_130940_(ChatFormatting.DARK_GREEN));
        }
    }

    private static void addTagList(List<Component> lines, String text, Collection<ResourceLocation> tags) {
        if (tags.isEmpty()) return;
        lines.add(Component.m_237113_(text).m_130940_(ChatFormatting.GRAY));
        for (ResourceLocation tag : tags) {
            lines.add(Component.m_237113_("- " + tag));
        }
    }

    private static Set<EntityType<?>> getEntityTypesByItem(ItemStack stack) {
        var item = stack.m_41720_();
        if (item instanceof SpawnEggItem spawnEggItem) {
            return Set.of(spawnEggItem.m_43228_(stack.m_41783_()));
        } else if (item instanceof MobBucketItem mobBucketItem) {
            return Set.of(OEItemUtils.getMobBucketEntity(mobBucketItem));
        }
        return Set.of();
    }
}
