/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.renderer.texture;

import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.client.renderer.texture.TextureLoadProgress;
import dev.felnull.otyacraftengine.client.renderer.texture.impl.NativeTextureLoadResult;
import dev.felnull.otyacraftengine.client.renderer.texture.impl.TextureLoadProgressImpl;
import dev.felnull.otyacraftengine.client.util.OETextureUtils;
import dev.felnull.otyacraftengine.util.FlagThread;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeTextureManager {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final NativeTextureManager INSTANCE = new NativeTextureManager();
    private final Map<UUID, NativeTextureLoadResult> NATIVE_TEXTURE_LOADS = new HashMap<UUID, NativeTextureLoadResult>();
    private final Map<UUID, NativeTextureLoader> NATIVE_TEXTURE_LOADERS = new HashMap<UUID, NativeTextureLoader>();

    public static NativeTextureManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public NativeTextureLoadResult getAndLoadTextureAsync(@NotNull UUID uuid, @NotNull InputStream stream) {
        NativeTextureLoadResult r;
        Map<UUID, NativeTextureLoadResult> map = this.NATIVE_TEXTURE_LOADS;
        synchronized (map) {
            r = this.NATIVE_TEXTURE_LOADS.get(uuid);
        }
        if (r == null) {
            r = new NativeTextureLoadResult();
            map = this.NATIVE_TEXTURE_LOADS;
            synchronized (map) {
                this.NATIVE_TEXTURE_LOADS.put(uuid, r);
            }
            NativeTextureLoader loader = new NativeTextureLoader(uuid, stream, r);
            Map<UUID, NativeTextureLoader> map2 = this.NATIVE_TEXTURE_LOADERS;
            synchronized (map2) {
                this.NATIVE_TEXTURE_LOADERS.put(uuid, loader);
            }
            loader.start();
        }
        return r;
    }

    public NativeTextureLoadResult getAndLoadTexture(@NotNull UUID uuid, @NotNull InputStream stream) {
        return this.getAndLoadTexture(uuid, stream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeTextureLoadResult getAndLoadTexture(@NotNull UUID uuid, @NotNull InputStream stream, @Nullable Consumer<TextureLoadProgress> progress) {
        NativeTextureLoadResult r;
        Map<UUID, NativeTextureLoadResult> map = this.NATIVE_TEXTURE_LOADS;
        synchronized (map) {
            r = this.NATIVE_TEXTURE_LOADS.get(uuid);
        }
        if (r == null) {
            r = NativeTextureManager.loadNativeTexture(stream, progress);
            map = this.NATIVE_TEXTURE_LOADS;
            synchronized (map) {
                this.NATIVE_TEXTURE_LOADS.put(uuid, r);
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public NativeTextureLoadResult getTexture(@NotNull UUID uuid) {
        Map<UUID, NativeTextureLoadResult> map = this.NATIVE_TEXTURE_LOADS;
        synchronized (map) {
            return this.NATIVE_TEXTURE_LOADS.get(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeNativeTexture(@NotNull UUID id) {
        Map<UUID, Object> map = this.NATIVE_TEXTURE_LOADERS;
        synchronized (map) {
            NativeTextureLoader l = this.NATIVE_TEXTURE_LOADERS.get(id);
            if (l != null) {
                l.stopped();
                this.NATIVE_TEXTURE_LOADERS.remove(id);
                return;
            }
        }
        map = this.NATIVE_TEXTURE_LOADS;
        synchronized (map) {
            NativeTextureLoadResult r = this.NATIVE_TEXTURE_LOADS.get(id);
            if (r != null) {
                if (r.isSuccess()) {
                    OETextureUtils.freeTexture(r.getLocation());
                }
                this.NATIVE_TEXTURE_LOADS.remove(id);
            }
        }
    }

    private static NativeTextureLoadResult loadNativeTexture(InputStream stream, Consumer<TextureLoadProgress> progress) {
        ResourceLocation[] loc = new ResourceLocation[1];
        try (BufferedInputStream bufstream = new BufferedInputStream(stream);){
            DynamicTexture tx = OETextureUtils.createNativeTexture(bufstream, progress);
            if (progress != null) {
                progress.accept(new TextureLoadProgressImpl("Texture registering", 1, 0));
            }
            mc.m_18707_(() -> {
                loc[0] = mc.m_91097_().m_118490_("native_texture", tx);
            }).get();
            if (progress != null) {
                progress.accept(new TextureLoadProgressImpl("Texture registering", 1, 1));
            }
        }
        catch (Exception ex) {
            return new NativeTextureLoadResult(null, ex);
        }
        return new NativeTextureLoadResult(loc[0], null);
    }

    private class NativeTextureLoader
    extends FlagThread {
        private final UUID uuid;
        private final InputStream stream;
        private final NativeTextureLoadResult result;

        private NativeTextureLoader(UUID uuid, InputStream stream, NativeTextureLoadResult result) {
            this.uuid = uuid;
            this.stream = stream;
            this.result = result;
            this.setName(OtyacraftEngine.getModName() + "-Native texture loader thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.isStopped()) {
                this.finish();
                return;
            }
            NativeTextureLoadResult ret = NativeTextureManager.loadNativeTexture(this.stream, this.result::setProgress);
            if (this.isStopped()) {
                if (ret.getLocation() != null) {
                    OETextureUtils.freeTexture(ret.getLocation());
                }
                this.finish();
                return;
            }
            Map<UUID, NativeTextureLoadResult> map = NativeTextureManager.this.NATIVE_TEXTURE_LOADS;
            synchronized (map) {
                NativeTextureManager.this.NATIVE_TEXTURE_LOADS.put(this.uuid, ret);
            }
            this.finish();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finish() {
            Map<UUID, NativeTextureLoader> map = NativeTextureManager.this.NATIVE_TEXTURE_LOADERS;
            synchronized (map) {
                NativeTextureManager.this.NATIVE_TEXTURE_LOADERS.remove(this.uuid);
            }
        }
    }
}

