/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.handler;

import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.platform.Platform;
import dev.felnull.otyacraftengine.client.debug.OtyacraftEngineClientDebug;
import dev.felnull.otyacraftengine.util.OEEntityUtils;
import dev.felnull.otyacraftengine.util.OEItemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;

public class ClientDebugHandler {
    public static void init() {
        ClientTooltipEvent.ITEM.register(ClientDebugHandler::onTooltip);
    }

    private static void onTooltip(ItemStack stack, List<Component> lines, TooltipFlag flag) {
        if (stack.m_41619_()) {
            return;
        }
        OtyacraftEngineClientDebug oed = OtyacraftEngineClientDebug.getInstance();
        if (oed.isShowTagInTooltip()) {
            ArrayList<ResourceLocation> itemTags = new ArrayList<ResourceLocation>(stack.m_204131_().map(TagKey::f_203868_).toList());
            Item item = stack.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                ArrayList<ResourceLocation> blockTags = new ArrayList<ResourceLocation>(blockItem.m_40614_().m_49966_().m_204343_().map(TagKey::f_203868_).toList());
                TreeSet<ResourceLocation> bothTags = new TreeSet<ResourceLocation>();
                for (ResourceLocation tag : itemTags) {
                    if (!blockTags.contains(tag)) continue;
                    bothTags.add(tag);
                }
                itemTags.removeAll(bothTags);
                blockTags.removeAll(bothTags);
                ClientDebugHandler.addTagList(lines, "Item tags", itemTags);
                ClientDebugHandler.addTagList(lines, "Block tags", blockTags);
                ClientDebugHandler.addTagList(lines, "Both tags", bothTags);
            } else {
                ClientDebugHandler.addTagList(lines, "Item tags", itemTags);
            }
            Set<EntityType<?>> entityTypes = ClientDebugHandler.getEntityTypesByItem(stack);
            List<ResourceLocation> entityTypeTags = entityTypes.stream().flatMap(OEEntityUtils::getTags).map(TagKey::f_203868_).toList();
            ClientDebugHandler.addTagList(lines, "Entity tags", entityTypeTags);
        }
        if (oed.isShowModNameInTooltip()) {
            String modid = OEItemUtils.getCreatorModId(stack);
            lines.add((Component)Component.m_237113_((String)Platform.getMod((String)modid).getName()).m_130940_(ChatFormatting.DARK_GREEN));
        }
    }

    private static void addTagList(List<Component> lines, String text, Collection<ResourceLocation> tags) {
        if (tags.isEmpty()) {
            return;
        }
        lines.add((Component)Component.m_237113_((String)text).m_130940_(ChatFormatting.GRAY));
        for (ResourceLocation tag : tags) {
            lines.add((Component)Component.m_237113_((String)("- " + tag)));
        }
    }

    private static Set<EntityType<?>> getEntityTypesByItem(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof SpawnEggItem) {
            SpawnEggItem spawnEggItem = (SpawnEggItem)item;
            return Set.of(spawnEggItem.m_43228_(stack.m_41783_()));
        }
        if (item instanceof MobBucketItem) {
            MobBucketItem mobBucketItem = (MobBucketItem)item;
            return Set.of(OEItemUtils.getMobBucketEntity(mobBucketItem));
        }
        return Set.of();
    }
}

