package dev.felnull.otyacraftengine.networking;

import dev.architectury.networking.NetworkManager;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.client.handler.ClientMessageHandler;
import dev.felnull.otyacraftengine.networking.existence.BlockEntityExistence;
import dev.felnull.otyacraftengine.networking.existence.ItemExistence;
import dev.felnull.otyacraftengine.server.handler.ServerMessageHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import record;
import java.util.UUID;

public class OEPackets {
    public static final ResourceLocation BLOCK_ENTITY_INSTRUCTION = new ResourceLocation(OtyacraftEngine.MODID, "block_entity_instruction");
    public static final ResourceLocation BLOCK_ENTITY_INSTRUCTION_RETURN = new ResourceLocation(OtyacraftEngine.MODID, "block_entity_instruction_return");
    public static final ResourceLocation ITEM_INSTRUCTION = new ResourceLocation(OtyacraftEngine.MODID, "item_instruction");
    public static final ResourceLocation ITEM_INSTRUCTION_RETURN = new ResourceLocation(OtyacraftEngine.MODID, "item_instruction_return");

    public static void init() {
        NetworkManager.registerReceiver(NetworkManager.c2s(), BLOCK_ENTITY_INSTRUCTION, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onBlockEntityInstructionMessage(new BlockEntityInstructionMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver(NetworkManager.c2s(), ITEM_INSTRUCTION, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onItemInstructionMessage(new ItemInstructionMessage(friendlyByteBuf), packetContext));
    }

    public static void clientInit() {
        NetworkManager.registerReceiver(NetworkManager.s2c(), BLOCK_ENTITY_INSTRUCTION_RETURN, (friendlyByteBuf, packetContext) -> ClientMessageHandler.onBlockEntityInstructionReturn(new BlockEntityInstructionMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver(NetworkManager.s2c(), ITEM_INSTRUCTION_RETURN, (friendlyByteBuf, packetContext) -> ClientMessageHandler.onItemInstructionReturn(new ItemInstructionMessage(friendlyByteBuf), packetContext));
    }

    public static record BlockEntityInstructionMessage(UUID instructionScreenID,
                                                       BlockEntityExistence blockEntityExistence, String name, int num,
                                                       CompoundTag data) implements PacketMessage {
        public BlockEntityInstructionMessage(FriendlyByteBuf bf) {
            this(bf.m_130259_(), BlockEntityExistence.read(bf), bf.m_130277_(), bf.readInt(), bf.m_130260_());
        }

        @Override
        public FriendlyByteBuf toFBB(FriendlyByteBuf buf) {
            buf.m_130077_(instructionScreenID);
            blockEntityExistence.write(buf);
            buf.m_130070_(name);
            buf.writeInt(num);
            buf.m_130079_(data);
            return buf;
        }
    }

    public static record ItemInstructionMessage(UUID instructionScreenID, ItemExistence itemExistence, String name,
                                                int num, CompoundTag data) implements PacketMessage {
        public ItemInstructionMessage(FriendlyByteBuf bf) {
            this(bf.m_130259_(), ItemExistence.read(bf), bf.m_130277_(), bf.readInt(), bf.m_130260_());
        }

        @Override
        public FriendlyByteBuf toFBB(FriendlyByteBuf buf) {
            buf.m_130077_(instructionScreenID);
            itemExistence.write(buf);
            buf.m_130070_(name);
            buf.writeInt(num);
            buf.m_130079_(data);
            return buf;
        }
    }

}
