/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.renderer.texture.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.client.event.OEClientEventHooks;
import dev.felnull.otyacraftengine.client.renderer.texture.NativeTextureManager;
import dev.felnull.otyacraftengine.client.renderer.texture.TextureLoadProgress;
import dev.felnull.otyacraftengine.client.renderer.texture.TextureLoadResult;
import dev.felnull.otyacraftengine.client.renderer.texture.URLTextureManager;
import dev.felnull.otyacraftengine.client.renderer.texture.impl.NativeTextureLoadResult;
import dev.felnull.otyacraftengine.client.renderer.texture.impl.TextureLoadProgressImpl;
import dev.felnull.otyacraftengine.client.renderer.texture.impl.URLTextureLoadResult;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNDataUtil;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNStringUtil;
import dev.felnull.otyacraftengine.util.OEPaths;
import dev.felnull.otyacraftengine.util.OEUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.lang3.tuple.Pair;

public class URLTextureManagerNewImpl
implements URLTextureManager {
    public static final URLTextureManagerNewImpl INSTANCE = new URLTextureManagerNewImpl();
    private final Map<String, UUID> caches = new HashMap<String, UUID>();
    private final Map<String, URLTextureEntry> loadURLTextures = new HashMap<String, URLTextureEntry>();
    private ExecutorService executorService = this.createExecutor();
    private Function<String, String> hashCache = this.createHashCache();
    private UUID runtimeId = UUID.randomUUID();

    @Override
    public void init() {
        this.load();
        this.optimize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        JsonObject index;
        long st = System.currentTimeMillis();
        File urlIndex = this.getIndexPath().toFile();
        if (!urlIndex.exists()) {
            return;
        }
        try {
            index = OEUtils.readJson(urlIndex, JsonObject.class);
        }
        catch (IOException e) {
            OtyacraftEngine.LOGGER.error("Failed to load url texture cache indexes", (Throwable)e);
            return;
        }
        Map<String, UUID> map = this.caches;
        synchronized (map) {
            this.caches.clear();
            index.entrySet().forEach(entry -> {
                File file;
                UUID uuid;
                JsonElement v = (JsonElement)entry.getValue();
                if (v != null && v.isJsonPrimitive() && v.getAsJsonPrimitive().isString() && (uuid = FNStringUtil.getUUIDFromNoHyphenStringNonThrow(v.getAsString())) != null && (file = this.getCacheFolderPath().resolve(v.getAsString()).toFile()).exists()) {
                    this.caches.put((String)entry.getKey(), uuid);
                }
            });
        }
        if (this.caches.size() > 0) {
            OtyacraftEngine.LOGGER.info(String.format("Loaded %s URL texture cache indexes in %s ms.", this.caches.size(), System.currentTimeMillis() - st));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void optimize() {
        long st = System.currentTimeMillis();
        File urlIndex = this.getIndexPath().toFile();
        if (!urlIndex.exists()) {
            return;
        }
        File fol = this.getCacheFolderPath().toFile();
        if (!fol.exists() || !fol.isDirectory()) {
            return;
        }
        File[] fils = fol.listFiles();
        if (fils == null) {
            return;
        }
        ArrayList<File> noExistFiles = new ArrayList<File>();
        Map<String, UUID> map = this.caches;
        synchronized (map) {
            for (File fil : fils) {
                String name = fil.getName();
                boolean flg = false;
                UUID uuid = FNStringUtil.getUUIDFromNoHyphenStringNonThrow(name);
                if (uuid != null) {
                    flg = this.caches.containsValue(uuid);
                }
                if (flg) continue;
                noExistFiles.add(fil);
            }
        }
        int ct = 0;
        for (File neFile : noExistFiles) {
            if (!neFile.delete()) continue;
            ++ct;
        }
        if (ct > 0) {
            OtyacraftEngine.LOGGER.info(String.format("Removed %s unnecessary URL Texture Cache files in %sms.", ct, System.currentTimeMillis() - st));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void save() {
        long st = System.currentTimeMillis();
        File fol = this.getCacheFolderPath().toFile();
        if (!FNDataUtil.wishMkdir(fol, f -> OtyacraftEngine.LOGGER.error("Failed to create url textures folder"))) {
            return;
        }
        File urlIndex = this.getIndexPath().toFile();
        JsonObject index = new JsonObject();
        Map<String, UUID> map = this.caches;
        synchronized (map) {
            this.caches.forEach((url, id) -> {
                String idStr = id.toString().replace("-", "");
                File file = this.getCacheFolderPath().resolve(idStr).toFile();
                if (file.exists()) {
                    index.addProperty(url, idStr);
                }
            });
        }
        if (!FNDataUtil.wishMkdir(urlIndex.getParentFile(), f -> OtyacraftEngine.LOGGER.error("Failed to create url textures folder"))) {
            return;
        }
        try {
            OEUtils.writeJson(urlIndex, (JsonElement)index);
        }
        catch (IOException e) {
            OtyacraftEngine.LOGGER.error("Failed to save url textures index", (Throwable)e);
            return;
        }
        if (this.caches.size() > 0) {
            OtyacraftEngine.LOGGER.info(String.format("Saved %s URL texture cache indexes in %s ms.", this.caches.size(), System.currentTimeMillis() - st));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void release() {
        this.executorService.shutdown();
        this.executorService = this.createExecutor();
        this.hashCache = this.createHashCache();
        this.runtimeId = UUID.randomUUID();
        Map<String, URLTextureEntry> map = this.loadURLTextures;
        synchronized (map) {
            NativeTextureManager ntm = NativeTextureManager.getInstance();
            for (URLTextureEntry entry : this.loadURLTextures.values()) {
                UUID u = entry.result.getUUID();
                if (u == null) continue;
                ntm.freeNativeTexture(u);
            }
            this.loadURLTextures.clear();
        }
    }

    @Override
    public void tick() {
    }

    private ExecutorService createExecutor() {
        return Executors.newFixedThreadPool(OtyacraftEngine.getConfig().getClientConfig().getUrlTextureConfig().getMaxLoaderCount(), (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("otyacraftengine-url-texture-loader-%d").daemon(true).build());
    }

    private Function<String, String> createHashCache() {
        return FNDataUtil.memoize(n -> {
            try {
                byte[] md5 = FNDataUtil.createMD5Hash(n.getBytes(StandardCharsets.UTF_8));
                return new String(Hex.encodeHex((byte[])md5));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private Path getIndexPath() {
        return OEPaths.getClientOEFolderPath().resolve("url_textures_index.json");
    }

    private Path getCacheFolderPath() {
        return OEPaths.getClientOEFolderPath().resolve("url_texture_cache");
    }

    private Path getCachePath(UUID uuid) {
        return this.getCacheFolderPath().resolve(uuid.toString().replace("-", ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TextureLoadResult getAndAsyncLoad(String url, boolean cached) {
        URLTextureEntry entry;
        String hash = this.hashCache.apply(url);
        Map<String, URLTextureEntry> map = this.loadURLTextures;
        synchronized (map) {
            entry = this.loadURLTextures.computeIfAbsent(hash, h -> this.loadStart((String)h, url, cached));
            if (!entry.cached && cached) {
                entry.cached = true;
                if (entry.cachedEnd) {
                    this.loadCacheOnly(hash, url, entry.uuid);
                }
            }
        }
        return entry.result;
    }

    private URLTextureEntry loadStart(String hash, String url, boolean cached) {
        URLTextureEntry entry = new URLTextureEntry(new URLTextureLoadResult(null, false, -1L, null, null), cached);
        entry.result.setProgress(new TextureLoadProgressImpl("Load waiting", 0, 0));
        UUID ruid = this.runtimeId;
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(() -> {
            try {
                this.checkUrl(url);
            }
            catch (Exception ex) {
                throw new URLNotReloadException(ex);
            }
        }, this.executorService).thenApplyAsync(n -> {
            try {
                return this.loadTexture(hash, url);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, (Executor)this.executorService)).thenApplyAsync(ret -> {
            try {
                entry.uuid = ret.uuid;
                entry.cachedEnd = true;
                if (entry.cached && ret.cached) {
                    return this.writeCache(hash, (TextureLoadedPipe)ret, entry.result::setProgress);
                }
                return new TextureCachedPipe(ret.stream, ret.uuid);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, (Executor)this.executorService)).thenApplyAsync(ret -> {
            NativeTextureManager ntm = NativeTextureManager.getInstance();
            NativeTextureLoadResult r = ntm.getAndLoadTexture(ret.uuid, ret.stream, entry.result::setProgress);
            if (ruid != this.runtimeId) {
                NativeTextureManager.getInstance().freeNativeTexture(ret.uuid);
                throw new RuntimeException("Released");
            }
            return new URLTextureLoadResult(null, false, r, ret.uuid());
        }, (Executor)this.executorService)).whenCompleteAsync((ret, e) -> {
            if (e != null) {
                ret = new URLTextureLoadResult((Throwable)e, !(e instanceof URLNotReloadException), null, null);
            }
            entry.result = ret;
        }, (Executor)this.executorService);
        return entry;
    }

    private void loadCacheOnly(String hash, String url, UUID uuid) {
        CompletableFuture.supplyAsync(() -> {
            try {
                Pair<InputStream, Long> r = this.connect(url);
                return new TextureLoadedPipe((InputStream)r.getLeft(), (Long)r.getRight(), true, uuid);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, this.executorService).thenApplyAsync(ret -> {
            try {
                return this.writeCache(hash, (TextureLoadedPipe)ret, r -> {});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextureCachedPipe writeCache(String hash, TextureLoadedPipe pipe, Consumer<TextureLoadProgress> progress) throws IOException {
        File fil = this.getCachePath(pipe.uuid).toFile();
        FNDataUtil.wishMkdir(fil.getParentFile());
        progress.accept(new TextureLoadProgressImpl("Cache getting", (int)pipe.length, 0));
        try (InputStream inputStream = pipe.stream;){
            FNDataUtil.fileWriteToProgress(inputStream, pipe.length, fil, progressListener -> progress.accept(new TextureLoadProgressImpl("Cache getting", (int)progressListener.getWrittenLength(), (int)progressListener.getLength())));
        }
        progress.accept(new TextureLoadProgressImpl("Cache getting", (int)pipe.length, (int)pipe.length));
        Map<String, UUID> map = this.caches;
        synchronized (map) {
            this.caches.put(hash, pipe.uuid);
        }
        return new TextureCachedPipe(new BufferedInputStream(new FileInputStream(fil)), pipe.uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextureLoadedPipe loadTexture(String hash, String url) throws IOException {
        File cf;
        UUID fileCache;
        Map<String, UUID> map = this.caches;
        synchronized (map) {
            fileCache = this.caches.get(hash);
        }
        if (fileCache != null && (cf = this.getCachePath(fileCache).toFile()).exists()) {
            return new TextureLoadedPipe(new BufferedInputStream(new FileInputStream(cf)), -1L, false, fileCache);
        }
        Pair<InputStream, Long> c = this.connect(url);
        return new TextureLoadedPipe((InputStream)c.getLeft(), (Long)c.getRight(), true, UUID.randomUUID());
    }

    /*
     * Exception decompiling
     */
    private Pair<InputStream, Long> connect(String url) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkUrl(String url) {
        boolean aflg;
        if (url.length() > 300) {
            throw new IllegalArgumentException("URL is too long");
        }
        boolean oea = Pattern.compile(OtyacraftEngine.getConfig().getClientConfig().getUrlTextureConfig().getUrlRegex()).matcher(url).matches();
        boolean eva = OEClientEventHooks.onCheckTextureURL(url);
        boolean bl = aflg = oea || eva;
        if (!aflg) {
            throw new IllegalArgumentException("Not allowed URL");
        }
    }

    private class URLTextureEntry {
        private URLTextureLoadResult result;
        private boolean cached;
        private boolean cachedEnd;
        private UUID uuid;

        private URLTextureEntry(URLTextureLoadResult result, boolean cached) {
            this.result = result;
            this.cached = cached;
        }
    }

    private record TextureLoadedPipe(InputStream stream, long length, boolean cached, UUID uuid) {
    }

    private record TextureCachedPipe(InputStream stream, UUID uuid) {
    }

    private static class URLNotReloadException
    extends RuntimeException {
        public URLNotReloadException(Throwable throwable) {
            super(throwable);
        }
    }
}

