/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.entity;

import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import dev.felnull.otyacraftengine.client.entity.PlayerNameByUUIDResult;
import dev.felnull.otyacraftengine.client.entity.PlayerUUIDByNameResult;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNDataUtil;
import dev.felnull.otyacraftengine.util.OEPlayerUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientPlayerInfoManager {
    private static final ClientPlayerInfoManager INSTANCE = new ClientPlayerInfoManager();
    private static final Minecraft mc = Minecraft.m_91087_();
    private final Map<String, GameProfile> PLAYER_PROFILES = new HashMap<String, GameProfile>();
    private final Map<String, PlayerUUIDByNameResult> UUID_BY_NAME_ENTRY = new HashMap<String, PlayerUUIDByNameResult>();
    private final Map<UUID, PlayerNameByUUIDResult> NAME_BY_UUID_ENTRY = new HashMap<UUID, PlayerNameByUUIDResult>();
    private Function<String, ResourceLocation> SKIN_TEXTURE_LOCATION_CACHE = this.createSkinTextureLocationCache();

    public static ClientPlayerInfoManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, GameProfile> map = this.PLAYER_PROFILES;
        synchronized (map) {
            this.PLAYER_PROFILES.clear();
        }
        this.SKIN_TEXTURE_LOCATION_CACHE = this.createSkinTextureLocationCache();
    }

    private Function<String, ResourceLocation> createSkinTextureLocationCache() {
        return FNDataUtil.memoize(url -> {
            String hashStr = Hashing.sha1().hashUnencodedChars((CharSequence)FilenameUtils.getBaseName((String)url)).toString();
            return new ResourceLocation("skins/" + hashStr);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public GameProfile getLackProfileTolerance(@NotNull String name) {
        Map<String, GameProfile> map = this.PLAYER_PROFILES;
        synchronized (map) {
            if (this.PLAYER_PROFILES.containsKey(name)) {
                return this.PLAYER_PROFILES.get(name);
            }
            GameProfile gp = new GameProfile(null, name);
            this.PLAYER_PROFILES.put(name, gp);
            SkullBlockEntity.m_155738_((GameProfile)gp, p -> {
                Map<String, GameProfile> map = this.PLAYER_PROFILES;
                synchronized (map) {
                    this.PLAYER_PROFILES.put(name, (GameProfile)p);
                }
            });
            return gp;
        }
    }

    @NotNull
    public Optional<UUID> getUUIDByName(@NotNull String name) {
        UUID cr = this.getUUIDByNameClient(name);
        if (cr != null) {
            return Optional.of(cr);
        }
        return OEPlayerUtils.getUUIDByName(name);
    }

    @NotNull
    public CompletableFuture<Optional<UUID>> getUUIDByNameAsync(@NotNull String name) {
        UUID cr = this.getUUIDByNameClient(name);
        if (cr != null) {
            return CompletableFuture.completedFuture(Optional.of(cr));
        }
        return OEPlayerUtils.getUUIDByNameAsync(name);
    }

    private UUID getUUIDByNameClient(String name) {
        if (ClientPlayerInfoManager.mc.f_91074_ != null) {
            if (ClientPlayerInfoManager.mc.f_91074_.m_36316_().getName().equals(name)) {
                return ClientPlayerInfoManager.mc.f_91074_.m_36316_().getId();
            }
            PlayerInfo pl = ClientPlayerInfoManager.mc.f_91074_.f_108617_.m_104938_(name);
            if (pl != null && pl.m_105312_() != null) {
                return pl.m_105312_().getId();
            }
        }
        return null;
    }

    @NotNull
    public Optional<String> getNameByUUID(@NotNull UUID uuid) {
        String cr = this.getNameByUUIDClient(uuid);
        if (cr != null) {
            return Optional.of(cr);
        }
        return OEPlayerUtils.getNameByUUID(uuid);
    }

    @NotNull
    public CompletableFuture<Optional<String>> getNameByUUIDAsync(@NotNull UUID uuid) {
        String cr = this.getNameByUUIDClient(uuid);
        if (cr != null) {
            return CompletableFuture.completedFuture(Optional.of(cr));
        }
        return OEPlayerUtils.getNameByUUIDAsync(uuid);
    }

    private String getNameByUUIDClient(UUID uuid) {
        if (ClientPlayerInfoManager.mc.f_91074_ != null) {
            if (ClientPlayerInfoManager.mc.f_91074_.m_36316_().getId().equals(uuid)) {
                return ClientPlayerInfoManager.mc.f_91074_.m_36316_().getName();
            }
            PlayerInfo pl = ClientPlayerInfoManager.mc.f_91074_.f_108617_.m_104949_(uuid);
            if (pl != null && pl.m_105312_() != null) {
                return pl.m_105312_().getName();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public PlayerUUIDByNameResult getUUIDByNameTolerance(@NotNull String name) {
        Map<String, PlayerUUIDByNameResult> map = this.UUID_BY_NAME_ENTRY;
        synchronized (map) {
            PlayerUUIDByNameResult ret = this.UUID_BY_NAME_ENTRY.get(name);
            if (ret == null) {
                ret = new PlayerUUIDByNameResult(null, true);
                this.UUID_BY_NAME_ENTRY.put(name, ret);
                this.getUUIDByNameAsync(name).thenAcceptAsync(uuid -> {
                    Map<String, PlayerUUIDByNameResult> map = this.UUID_BY_NAME_ENTRY;
                    synchronized (map) {
                        this.UUID_BY_NAME_ENTRY.put(name, new PlayerUUIDByNameResult(uuid.orElse(null), false));
                    }
                });
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public PlayerNameByUUIDResult getNameByUUIDTolerance(@NotNull UUID uuid) {
        Map<UUID, PlayerNameByUUIDResult> map = this.NAME_BY_UUID_ENTRY;
        synchronized (map) {
            PlayerNameByUUIDResult ret = this.NAME_BY_UUID_ENTRY.get(uuid);
            if (ret == null) {
                ret = new PlayerNameByUUIDResult(null, true);
                this.NAME_BY_UUID_ENTRY.put(uuid, ret);
                this.getNameByUUIDAsync(uuid).thenAcceptAsync(name -> {
                    Map<UUID, PlayerNameByUUIDResult> map = this.NAME_BY_UUID_ENTRY;
                    synchronized (map) {
                        this.NAME_BY_UUID_ENTRY.put(uuid, new PlayerNameByUUIDResult(name.orElse(null), false));
                    }
                });
            }
            return ret;
        }
    }

    @Nullable
    public ResourceLocation getPlayerTexture(@NotNull MinecraftProfileTexture.Type type, @NotNull String name) {
        PlayerInfo pl;
        if (ClientPlayerInfoManager.mc.f_91074_ != null && (pl = ClientPlayerInfoManager.mc.f_91074_.f_108617_.m_104938_(name)) != null) {
            return this.getTexture(pl, type);
        }
        GameProfile gp = this.getLackProfileTolerance(name);
        MinecraftProfileTexture tex = (MinecraftProfileTexture)mc.m_91109_().m_118815_(gp).get(type);
        if (tex != null) {
            ResourceLocation hr = this.SKIN_TEXTURE_LOCATION_CACHE.apply(tex.getUrl());
            DynamicTexture mt = MissingTextureAtlasSprite.m_118080_();
            AbstractTexture at = mc.m_91097_().m_174786_(hr, (AbstractTexture)mt);
            if (at == mt) {
                return mc.m_91109_().m_118825_(tex, type);
            }
            return hr;
        }
        return type == MinecraftProfileTexture.Type.SKIN ? DefaultPlayerSkin.m_118627_((UUID)UUIDUtil.m_235879_((String)name)) : null;
    }

    @Nullable
    public ResourceLocation getPlayerTexture(@NotNull MinecraftProfileTexture.Type type, @NotNull UUID uuid) {
        PlayerInfo pl;
        if (ClientPlayerInfoManager.mc.f_91074_ != null && (pl = ClientPlayerInfoManager.mc.f_91074_.f_108617_.m_104949_(uuid)) != null) {
            return this.getTexture(pl, type);
        }
        String name = this.getNameByUUIDTolerance(uuid).name();
        if (name != null) {
            return this.getPlayerTexture(type, name);
        }
        return type == MinecraftProfileTexture.Type.SKIN ? DefaultPlayerSkin.m_118627_((UUID)uuid) : null;
    }

    private ResourceLocation getTexture(PlayerInfo playerInfo, MinecraftProfileTexture.Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case MinecraftProfileTexture.Type.SKIN -> playerInfo.m_105337_();
            case MinecraftProfileTexture.Type.CAPE -> playerInfo.m_105338_();
            case MinecraftProfileTexture.Type.ELYTRA -> playerInfo.m_105339_();
        };
    }
}

