/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine;

import dev.felnull.otyacraftengine.client.debug.HighlightVoxelShapeType;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;

@Config(name="otyacraftengine")
@Config.Gui.Background(value="otyacraftengine:textures/gui/config_background.png")
public class OEConfig
extends PartitioningSerializer.GlobalData {
    @ConfigEntry.Category(value="client")
    @ConfigEntry.Gui.TransitiveObject
    private ClientConfig clientConfig = new ClientConfig();
    @ConfigEntry.Category(value="client_debug")
    @ConfigEntry.Gui.TransitiveObject
    private DebugConfig debugConfig = new DebugConfig();

    public DebugConfig getDebugConfig() {
        return this.debugConfig;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    @Config(name="client")
    public static class ClientConfig
    implements ConfigData {
        @ConfigEntry.Gui.CollapsibleObject
        private URLTextureConfig urlTextureConfig = new URLTextureConfig();

        public URLTextureConfig getUrlTextureConfig() {
            return this.urlTextureConfig;
        }

        public static class URLTextureConfig {
            private int maxLoaderCount = 3;
            private String urlRegex = "https://(i.imgur.com|imgur.com)/.*";

            public int getMaxLoaderCount() {
                return Math.max(1, this.maxLoaderCount);
            }

            public String getUrlRegex() {
                return this.urlRegex;
            }
        }
    }

    @Config(name="client_debug")
    public static class DebugConfig
    implements ConfigData {
        private HighlightVoxelShapeType highlightVoxelShape = HighlightVoxelShapeType.OFF;
        private boolean showTagTooltip = false;
        private boolean showModNameTooltip = false;
        private boolean showWidgetData = false;

        public HighlightVoxelShapeType getHighlightVoxelShape() {
            return this.highlightVoxelShape;
        }

        public boolean isShowWidgetData() {
            return this.showWidgetData;
        }

        public boolean isShowTagTooltip() {
            return this.showTagTooltip;
        }

        public boolean isShowModNameTooltip() {
            return this.showModNameTooltip;
        }
    }
}

