/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.include.dev.felnull.fnjl.math;

import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.math.FNVec3d;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.math.FNVec4f;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.math.FNVec4i;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.tuple.FNTriple;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNMath;
import java.util.Objects;

public class FNVec4d {
    private double x;
    private double y;
    private double z;
    private double w;

    public FNVec4d() {
    }

    public FNVec4d(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public FNVec4d copy() {
        return new FNVec4d(this.x, this.y, this.z, this.w);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getW() {
        return this.w;
    }

    public double distance(FNVec4d vec) {
        return Math.sqrt(Math.pow(this.x - vec.getX(), 2.0) + Math.pow(this.y - vec.getY(), 2.0) + Math.pow(this.z - vec.getZ(), 2.0) + Math.pow(this.w - vec.getW(), 2.0));
    }

    public FNVec4d add(FNVec4d vec) {
        this.x += vec.getX();
        this.y += vec.getY();
        this.z += vec.getZ();
        this.w += vec.getW();
        return this;
    }

    public FNVec4d sub(FNVec4d vec) {
        this.x -= vec.getX();
        this.y -= vec.getY();
        this.z -= vec.getZ();
        this.w -= vec.getW();
        return this;
    }

    public String toString() {
        return "FNVec4d{x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FNVec4d fnVec4d = (FNVec4d)o;
        return Double.compare(fnVec4d.x, this.x) == 0 && Double.compare(fnVec4d.y, this.y) == 0 && Double.compare(fnVec4d.z, this.z) == 0 && Double.compare(fnVec4d.w, this.w) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z, this.w);
    }

    public FNVec4f convertFloat() {
        return new FNVec4f((float)this.x, (float)this.y, (float)this.z, (float)this.w);
    }

    public FNVec4i convertInt() {
        return new FNVec4i((int)this.x, (int)this.y, (int)this.z, (int)this.w);
    }

    public FNVec3d toEulerAngle() {
        FNTriple<Double, Double, Double> e = FNMath.toEulerAngle(this.x, this.y, this.z, this.w);
        return new FNVec3d(e.getLeft(), e.getCenter(), e.getRight());
    }
}

