package dev.felnull.otyacraftengine.block;

import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import org.jetbrains.annotations.Nullable;

public abstract class HorizontalDirectionalEntityBlock extends OEBaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public HorizontalDirectionalEntityBlock(Properties properties) {
        super(properties);
        this.m_49959_(this.m_49966_().m_61124_(FACING, Direction.NORTH));
    }

    @Override
    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return blockState.m_61124_(FACING, rotation.m_55954_(blockState.m_61143_(FACING)));
    }

    @Override
    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_(blockState.m_61143_(FACING)));
    }

    @Nullable
    @Override
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        return super.m_5573_(blockPlaceContext).m_61124_(FACING, blockPlaceContext.m_8125_().m_122424_());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(FACING);
    }
}
