/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.forge.data;

import com.google.common.collect.ImmutableList;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.DataGeneratorType;
import dev.felnull.otyacraftengine.data.provider.AdvancementProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.BlockLootTableProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.BlockTagProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.DevToolProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.ItemTagProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.PoiTypeTagProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.RecipeProviderWrapper;
import dev.felnull.otyacraftengine.forge.data.provider.WrappedAdvancementProvider;
import dev.felnull.otyacraftengine.forge.data.provider.WrappedBlockLootTableProvider;
import dev.felnull.otyacraftengine.forge.data.provider.WrappedBlockTagsProvider;
import dev.felnull.otyacraftengine.forge.data.provider.WrappedDevToolProvider;
import dev.felnull.otyacraftengine.forge.data.provider.WrappedItemTagsProvider;
import dev.felnull.otyacraftengine.forge.data.provider.WrappedPoiTypeTagsProvider;
import dev.felnull.otyacraftengine.forge.data.provider.WrappedRecipeProvider;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class CrossDataGeneratorAccessImpl
implements CrossDataGeneratorAccess {
    private final List<Path> resourceInputFolders = new ArrayList<Path>();
    private final GatherDataEvent gatherDataEvent;

    protected CrossDataGeneratorAccessImpl(GatherDataEvent gatherDataEvent) {
        this.gatherDataEvent = gatherDataEvent;
    }

    @Override
    @NotNull
    public DataGenerator getVanillaGenerator() {
        return this.gatherDataEvent.getGenerator();
    }

    @Override
    public void addProvider(@NotNull DataGeneratorType dataGeneratorType, @NotNull DataProvider dataProvider) {
        DataGenerator gen = this.gatherDataEvent.getGenerator();
        gen.m_236039_(this.isInclude(dataGeneratorType), dataProvider);
    }

    @Override
    public Mod getMod() {
        return Platform.getMod((String)this.gatherDataEvent.getModContainer().getModId());
    }

    @Override
    public RecipeProvider createRecipeProvider(RecipeProviderWrapper recipeProviderWrapper) {
        return new WrappedRecipeProvider(this.gatherDataEvent.getGenerator(), recipeProviderWrapper);
    }

    @Override
    public TagsProvider<Item> createItemTagProvider(ItemTagProviderWrapper itemTagProviderWrapper, @NotNull BlockTagProviderWrapper blockTagProviderWrapper) {
        TagsProvider<Block> tagsProvider = blockTagProviderWrapper.getProvider();
        if (!(tagsProvider instanceof BlockTagsProvider)) {
            throw new IllegalArgumentException("Not BlockTagsProvider");
        }
        BlockTagsProvider blockTagsProvider = (BlockTagsProvider)tagsProvider;
        return new WrappedItemTagsProvider(this.getVanillaGenerator(), blockTagsProvider, this.gatherDataEvent.getModContainer().getModId(), this.gatherDataEvent.getExistingFileHelper(), itemTagProviderWrapper);
    }

    @Override
    public TagsProvider<Block> createBlockTagProvider(BlockTagProviderWrapper blockTagProviderWrapper) {
        return new WrappedBlockTagsProvider(this.getVanillaGenerator(), this.gatherDataEvent.getModContainer().getModId(), this.gatherDataEvent.getExistingFileHelper(), blockTagProviderWrapper);
    }

    @Override
    public TagsProvider<PoiType> createPoiTypeTagProvider(PoiTypeTagProviderWrapper poiTypeTagProviderWrapper) {
        return new WrappedPoiTypeTagsProvider(this.getVanillaGenerator(), this.gatherDataEvent.getModContainer().getModId(), this.gatherDataEvent.getExistingFileHelper(), poiTypeTagProviderWrapper);
    }

    @Override
    public DataProvider createDevToolProvider(DevToolProviderWrapper devToolProviderWrapper) {
        return new WrappedDevToolProvider(devToolProviderWrapper);
    }

    @Override
    public DataProvider createBlockLootTableProvider(BlockLootTableProviderWrapper blockLootTableProviderWrapper) {
        return new WrappedBlockLootTableProvider(this.getVanillaGenerator(), blockLootTableProviderWrapper);
    }

    @Override
    public DataProvider createAdvancementProvider(AdvancementProviderWrapper advancementProviderWrapper) {
        return new WrappedAdvancementProvider(this.getVanillaGenerator(), this.gatherDataEvent.getExistingFileHelper(), advancementProviderWrapper);
    }

    @Override
    public boolean isInclude(DataGeneratorType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case DataGeneratorType.CLIENT -> this.gatherDataEvent.includeClient();
            case DataGeneratorType.SERVER -> this.gatherDataEvent.includeServer();
            case DataGeneratorType.DEV -> this.gatherDataEvent.includeDev();
            case DataGeneratorType.REPORT -> this.gatherDataEvent.includeReports();
        };
    }

    @Override
    public Collection<Path> getResourceInputFolders() {
        return ImmutableList.copyOf(this.resourceInputFolders);
    }

    @Override
    public void addResourceInputFolders(Path path) {
        this.resourceInputFolders.add(path);
    }
}

