/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.renderer.texture;

import dev.felnull.otyacraftengine.client.renderer.texture.TextureLoadProgress;
import dev.felnull.otyacraftengine.client.util.OETextureUtils;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public interface TextureLoadResult {
    public ResourceLocation getLocation();

    public boolean isLoading();

    public boolean isError();

    public boolean isSuccess();

    public Exception getException();

    @NotNull
    default public ResourceLocation of(@NotNull ResourceLocation loading, @NotNull ResourceLocation error) {
        if (this.isLoading()) {
            return loading;
        }
        if (this.isError()) {
            return error;
        }
        return this.getLocation();
    }

    @NotNull
    default public ResourceLocation of(@NotNull ResourceLocation error) {
        return this.of(OETextureUtils.getLoadingIcon(), error);
    }

    @NotNull
    default public ResourceLocation of() {
        return this.of(OETextureUtils.getLoadingIcon(), OETextureUtils.getErrorIcon());
    }

    public TextureLoadProgress getProgress();
}

