package dev.felnull.otyacraftengine.client.renderer;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.client.renderer.shader.OEShaders;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

import java.util.function.Function;

public class OERenderTypes extends RenderType {
    private static final ShaderStateShard SIMPLE_SPRITE_SOLID_SHADER = new ShaderStateShard(OEShaders::getRendertypeSimpleSpriteSolidShader);
    private static final ShaderStateShard SIMPLE_SPRITE_CUTOUT_SHADER = new ShaderStateShard(OEShaders::getRendertypeSimpleSpriteCutoutShader);
    private static final ShaderStateShard WAVE_SHADER = new ShaderStateShard(OEShaders::getRendertypeWave);

    private static final Function<ResourceLocation, RenderType> SIMPLE_SPRITE_SOLID = Util.m_143827_((resourceLocation) -> {
        RenderType.CompositeState compositeState = RenderType.CompositeState.m_110628_().m_173292_(SIMPLE_SPRITE_SOLID_SHADER).m_173290_(new RenderStateShard.TextureStateShard(resourceLocation, false, false)).m_110685_(f_110134_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(true);
        return OERenderTypes.m_173215_(OtyacraftEngine.MODID + "_simple_sprite_solid", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, true, false, compositeState);
    });

    private static final Function<ResourceLocation, RenderType> SIMPLE_SPRITE_CUTOUT = Util.m_143827_((resourceLocation) -> {
        RenderType.CompositeState compositeState = RenderType.CompositeState.m_110628_().m_173292_(SIMPLE_SPRITE_CUTOUT_SHADER).m_173290_(new RenderStateShard.TextureStateShard(resourceLocation, false, false)).m_110685_(f_110134_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(true);
        return OERenderTypes.m_173215_(OtyacraftEngine.MODID + "_simple_sprite_cutout", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, true, false, compositeState);
    });

    private static final Function<ResourceLocation, RenderType> WAVE = Util.m_143827_((resourceLocation) -> {
        RenderType.CompositeState compositeState = RenderType.CompositeState.m_110628_().m_173292_(WAVE_SHADER).m_173290_(new RenderStateShard.TextureStateShard(resourceLocation, false, false)).m_110685_(f_110134_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(true);
        return OERenderTypes.m_173215_(OtyacraftEngine.MODID + "_wave", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, true, false, compositeState);
    });

    public OERenderTypes(String string, VertexFormat vertexFormat, VertexFormat.Mode mode, int i, boolean bl, boolean bl2, Runnable runnable, Runnable runnable2) {
        super(string, vertexFormat, mode, i, bl, bl2, runnable, runnable2);
    }

    public static RenderType simpleSpriteSolid(ResourceLocation location) {
        return SIMPLE_SPRITE_SOLID.apply(location);
    }

    public static RenderType simpleSpriteCutout(ResourceLocation location) {
        return SIMPLE_SPRITE_CUTOUT.apply(location);
    }

    public static RenderType wave(ResourceLocation location) {
        return WAVE.apply(location);
    }

    public static ShaderStateShard getSimpleSpriteCutoutShader() {
        return SIMPLE_SPRITE_CUTOUT_SHADER;
    }

    public static ShaderStateShard getSimpleSpriteSolidShader() {
        return SIMPLE_SPRITE_SOLID_SHADER;
    }

    public static ShaderStateShard getWaveShader() {
        return WAVE_SHADER;
    }
}
