package dev.felnull.otyacraftengine.advancement;

import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.OtyacraftEngine;
import dev.felnull.otyacraftengine.util.OEItemUtils;
import net.minecraft.advancements.critereon.*;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ModInvolvementTrigger extends SimpleCriterionTrigger<ModInvolvementTrigger.TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation(OtyacraftEngine.MODID, "mod_involvement");

    @Override
    public ResourceLocation m_7295_() {
        return ID;
    }

    @Override
    protected TriggerInstance m_7214_(JsonObject jsonObject, EntityPredicate.@NotNull Composite composite, @NotNull DeserializationContext deserializationContext) {
        String mid = jsonObject.has("modid") ? jsonObject.get("modid").getAsString() : "";
        return new TriggerInstance(composite, mid);
    }

    public static void trigger(ServerPlayer serverPlayer, ItemStack itemStack) {
        OECriteriaTriggers.MOD_INVOLVEMENT_TRIGGER.trigger_(serverPlayer, itemStack);
    }

    public static void trigger(ServerPlayer serverPlayer, String modId) {
        OECriteriaTriggers.MOD_INVOLVEMENT_TRIGGER.trigger_(serverPlayer, modId);
    }

    private void trigger_(ServerPlayer serverPlayer, ItemStack itemStack) {
        this.m_66234_(serverPlayer, (triggerInstance) -> triggerInstance.matches(itemStack));
    }

    private void trigger_(ServerPlayer serverPlayer, String modId) {
        this.m_66234_(serverPlayer, (triggerInstance) -> triggerInstance.matches(modId));
    }

    public static class TriggerInstance extends AbstractCriterionTriggerInstance {
        @NotNull
        private final String modId;

        public TriggerInstance(EntityPredicate.Composite composite, @NotNull String modId) {
            super(ID, composite);
            this.modId = modId;
        }

        public static TriggerInstance involvedMod(String modId) {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, modId);
        }

        private boolean matches(ItemStack stack) {
            var id = OEItemUtils.getCreatorModId(stack);
            return matches(id);
        }

        private boolean matches(String modId) {
            return this.modId.equals(modId);
        }

        @Override
        public JsonObject m_7683_(@NotNull SerializationContext serializationContext) {
            var jo = super.m_7683_(serializationContext);
            jo.addProperty("modid", modId);
            return jo;
        }
    }
}
