/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.fnjln;

import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.os.OSs;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNDataUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FelNullJavaLibraryNatives {
    private static boolean init;
    private static boolean loaded;

    public static synchronized void init() {
        String tempDir = System.getProperty("java.io.tmpdir");
        Path path = Paths.get(tempDir, new String[0]).resolve("fnjl_natives");
        FNDataUtil.wishMkdir(path.toFile());
        FelNullJavaLibraryNatives.init(path);
    }

    public static synchronized void init(Path libraryPath) {
        FelNullJavaLibraryNatives.init("dev/felnull/fnjln/natives/", libraryPath);
    }

    public static synchronized void init(String libraryLocation, Path libraryPath) {
        if (init) {
            return;
        }
        if (libraryPath == null) {
            init = true;
            return;
        }
        OSs.Type os = OSs.getOS();
        String arch = OSs.getArch();
        String libName = String.format("FNJLNative_%s.%s", arch, os.getLibName());
        String outLibName = String.format("FNJLNative_%s%s.%s", FelNullJavaLibraryNatives.getNativeLibraryVersion(), arch, os.getLibName());
        File outLibFIle = libraryPath.resolve(outLibName).toFile();
        if (outLibFIle.exists() && FelNullJavaLibraryNatives.loadLibrary(outLibFIle)) {
            loaded = true;
            init = true;
            return;
        }
        try (InputStream stream = FNDataUtil.resourceExtractor(FelNullJavaLibraryNatives.class, libraryLocation + libName);){
            if (stream != null) {
                byte[] data = FNDataUtil.readAllBytes(stream);
                outLibFIle.delete();
                Files.write(outLibFIle.toPath(), data, new OpenOption[0]);
                loaded = FelNullJavaLibraryNatives.loadLibrary(outLibFIle);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            init = true;
        }
    }

    private static boolean loadLibrary(File file) {
        try {
            System.load(file.getAbsolutePath());
            return true;
        }
        catch (UnsatisfiedLinkError er) {
            er.printStackTrace();
            return false;
        }
    }

    public static boolean isInitialized() {
        return init;
    }

    public static boolean isLoadedSuccess() {
        return init && loaded;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static String getVersion() {
        return "1.69";
    }

    public static int getNativeLibraryVersion() {
        return 1;
    }

    public static void check() {
        if (!FelNullJavaLibraryNatives.isInitialized()) {
            throw new RuntimeException("Library not initialized");
        }
        if (!FelNullJavaLibraryNatives.isLoaded()) {
            throw new RuntimeException("Library not loaded");
        }
    }
}

