/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.renderer.texture;

import dev.felnull.otyacraftengine.client.renderer.texture.TextureLoadProgress;
import dev.felnull.otyacraftengine.client.util.OETextureUtils;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public interface TextureLoadResult {
    public ResourceLocation getLocation();

    public boolean isLoading();

    public boolean isError();

    public boolean isSuccess();

    public Throwable getThrowable();

    @NotNull
    default public ResourceLocation of(@NotNull ResourceLocation loadingLocation, @NotNull ResourceLocation errorlLocation) {
        if (this.isLoading()) {
            return loadingLocation;
        }
        if (this.isError()) {
            return errorlLocation;
        }
        return this.getLocation();
    }

    @NotNull
    default public ResourceLocation of(@NotNull ResourceLocation errorLocation) {
        return this.of(OETextureUtils.getLoadingIcon(), errorLocation);
    }

    @NotNull
    default public ResourceLocation of() {
        return this.of(OETextureUtils.getLoadingIcon(), OETextureUtils.getErrorIcon());
    }

    public TextureLoadProgress getProgress();
}

