/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.block.IIkisugiVoxelShape;
import dev.felnull.otyacraftengine.block.IkisugiVoxelShape;
import dev.felnull.otyacraftengine.block.RotateAngledAxis;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import org.apache.commons.lang3.ArrayUtils;

public class OEVoxelShapeUtil {
    private static final Gson gson = new Gson();

    public static class_265 makeBox(double x1, double y1, double z1, double x2, double y2, double z2) {
        return class_2248.method_9541((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public static class_265 makeBoxY90(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBox(z1, y1, 16.0 - x1, z2, y2, 16.0 - x2);
    }

    public static class_265 makeBoxY180(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBox(16.0 - x1, y1, 16.0 - z1, 16.0 - x2, y2, 16.0 - z2);
    }

    public static class_265 makeBoxY270(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBoxY180(z1, y1, 16.0 - x1, z2, y2, 16.0 - x2);
    }

    public static class_265 addBoxY0(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBox(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static class_265 addBoxY90(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBoxY90(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static class_265 addBoxY180(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBoxY180(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static class_265 addBoxY270(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBoxY270(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static class_265 uniteBox(class_265 ... shapes) {
        class_265 shape = class_259.method_17786((class_265)shapes[0], (class_265[])((class_265[])ArrayUtils.remove((Object[])shapes, (int)0)));
        return IkisugiVoxelShape.getInstance().unite(shape, shapes);
    }

    public static class_265 uniteBox(List<class_265> shapes) {
        if (shapes.isEmpty()) {
            return class_259.method_1073();
        }
        ArrayList<class_265> shapesCp = new ArrayList<class_265>(shapes);
        class_265 voxelShape = (class_265)shapesCp.remove(0);
        class_265 shape = shapesCp.stream().reduce(voxelShape, class_259::method_1084);
        return IkisugiVoxelShape.getInstance().unite(shape, shapes.stream().map(n -> (IIkisugiVoxelShape)n).toList());
    }

    public static class_265 moveBox(class_265 shape, double x, double y, double z) {
        ArrayList<class_265> shapes = new ArrayList<class_265>();
        for (class_238 aabb : shape.method_1090()) {
            shapes.add(class_259.method_1078((class_238)aabb.method_989(0.0625 * x, 0.0625 * y, 0.0625 * z)));
        }
        class_265 ushape = OEVoxelShapeUtil.uniteBox(shapes);
        return IkisugiVoxelShape.getInstance().move(ushape, (IIkisugiVoxelShape)shape, x, y, z);
    }

    public static class_265 rotateBox(class_265 shape, RotateAngledAxis angledAxis) {
        ArrayList<class_265> shapes = new ArrayList<class_265>();
        for (class_238 aabb : shape.method_1090()) {
            shapes.add(class_259.method_1078((class_238)angledAxis.convertAABB(aabb)));
        }
        class_265 ushape = OEVoxelShapeUtil.uniteBox(shapes);
        return IkisugiVoxelShape.getInstance().rotate(ushape, (IIkisugiVoxelShape)shape, angledAxis);
    }

    public static class_265 rotateBoxY90(class_265 shape) {
        return OEVoxelShapeUtil.rotateBox(shape, RotateAngledAxis.Y90);
    }

    public static class_265 rotateBoxY180(class_265 shape) {
        return OEVoxelShapeUtil.rotateBox(shape, RotateAngledAxis.Y180);
    }

    public static class_265 rotateBoxY270(class_265 shape) {
        return OEVoxelShapeUtil.rotateBox(shape, RotateAngledAxis.Y270);
    }

    public static class_265 rotateBoxX90(class_265 shape) {
        return OEVoxelShapeUtil.rotateBox(shape, RotateAngledAxis.X90);
    }

    public static class_265 rotateBoxX180(class_265 shape) {
        return OEVoxelShapeUtil.rotateBox(shape, RotateAngledAxis.X180);
    }

    public static class_265 rotateBoxX270(class_265 shape) {
        return OEVoxelShapeUtil.rotateBox(shape, RotateAngledAxis.X270);
    }

    public static class_265 rotateBoxZ90(class_265 shape) {
        return OEVoxelShapeUtil.rotateBox(shape, RotateAngledAxis.Z90);
    }

    public static class_265 rotateBoxZ180(class_265 shape) {
        return OEVoxelShapeUtil.rotateBox(shape, RotateAngledAxis.Z180);
    }

    public static class_265 rotateBoxDirection(class_265 shape, class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11035 -> OEVoxelShapeUtil.rotateBoxY180(shape);
            case class_2350.field_11034 -> OEVoxelShapeUtil.rotateBoxY270(shape);
            case class_2350.field_11039 -> OEVoxelShapeUtil.rotateBoxY90(shape);
            default -> shape;
        };
    }

    public static class_265 getShapeFromResource(class_2960 location) {
        InputStream stream = OEVoxelShapeUtil.class.getResourceAsStream("/data/" + location.method_12836() + "/shape/" + location.method_12832() + ".json");
        if (stream == null) {
            return OEVoxelShapeUtil.makeBox(16.0, 16.0, 16.0, 16.0, 16.0, 16.0);
        }
        return IkisugiVoxelShape.getInstance().getShapeFromJson((JsonObject)gson.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), JsonObject.class));
    }

    public static DirectionVoxelShapes makeAllDirection(class_265 shape) {
        return new DirectionVoxelShapes(shape, OEVoxelShapeUtil.rotateBoxDirection(shape, class_2350.field_11035), OEVoxelShapeUtil.rotateBoxDirection(shape, class_2350.field_11034), OEVoxelShapeUtil.rotateBoxDirection(shape, class_2350.field_11039));
    }

    public record DirectionVoxelShapes(class_265 north, class_265 south, class_265 east, class_265 west) {
        public class_265 getShape(class_2350 direction) {
            return switch (direction) {
                case class_2350.field_11035 -> this.south;
                case class_2350.field_11034 -> this.east;
                case class_2350.field_11039 -> this.west;
                default -> this.north;
            };
        }
    }
}

