/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.felnull.fnjl.util.FNColorUtil;
import dev.felnull.otyacraftengine.client.util.OETextureUtil;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import net.minecraft.class_778;

@Environment(value=EnvType.CLIENT)
public class OERenderUtil {
    private static final class_310 mc = class_310.method_1551();

    public static void renderCenterTextSprite(class_4587 poseStack, class_4597 multiBufferSource, class_2561 text, float x, float y, float z, float size, float textX, float textY) {
        poseStack.method_22903();
        poseStack.method_22904((double)x, (double)y, (double)z);
        poseStack.method_22905(0.010416667f * size, -0.010416667f * size, 0.010416667f * size);
        class_327 class_3272 = OERenderUtil.mc.field_1772;
        float f = (float)(-OERenderUtil.mc.field_1772.method_27525((class_5348)text)) / 2.0f + textX;
        Objects.requireNonNull(OERenderUtil.mc.field_1772);
        class_3272.method_30882(text, f, (float)(-9) + textY, 0, false, poseStack.method_23760().method_23761(), multiBufferSource, false, 0, 0);
        poseStack.method_22909();
    }

    public static void renderTextSprite(class_4587 poseStack, class_4597 multiBufferSource, class_2561 text, float x, float y, float z, float size, float textX, float textY) {
        poseStack.method_22903();
        poseStack.method_22904((double)x, (double)y, (double)z);
        poseStack.method_22905(0.010416667f * size, -0.010416667f * size, 0.010416667f * size);
        class_327 class_3272 = OERenderUtil.mc.field_1772;
        Objects.requireNonNull(OERenderUtil.mc.field_1772);
        class_3272.method_30882(text, textX, (float)(-9) + textY, 0, false, poseStack.method_23760().method_23761(), multiBufferSource, false, 0, 0);
        poseStack.method_22909();
    }

    public static void drawCenterText(class_4587 poseStack, class_2561 text, float x, float y, int color) {
        OERenderUtil.mc.field_1772.method_30883(poseStack, text, x - (float)OERenderUtil.mc.field_1772.method_27525((class_5348)text) / 2.0f, y, color);
    }

    public static void drawCenterText(class_4587 poseStack, String str, float x, float y, int color) {
        OERenderUtil.mc.field_1772.method_1729(poseStack, str, x - (float)OERenderUtil.mc.field_1772.method_1727(str) / 2.0f, y, color);
    }

    public static void drawPlayerFace(class_4587 poseStack, UUID uuid, float x, float y) {
        OERenderUtil.drawPlayerFace(poseStack, uuid, x, y, 8.0f);
    }

    public static void drawPlayerFace(class_4587 poseStack, UUID uuid, float x, float y, float size) {
        poseStack.method_22903();
        float sc = size / 8.0f;
        class_2960 plskin = OETextureUtil.getPlayerSkinTexture(uuid);
        OERenderUtil.drawTexture(plskin, poseStack, x, y, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc);
        OERenderUtil.drawTexture(plskin, poseStack, x, y, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc);
        poseStack.method_22909();
    }

    public static void drawPlayerFace(class_4587 poseStack, String name, float x, float y) {
        OERenderUtil.drawPlayerFace(poseStack, name, x, y, 8.0f);
    }

    public static void drawPlayerFace(class_4587 poseStack, String name, float x, float y, float size) {
        poseStack.method_22903();
        float sc = size / 8.0f;
        class_2960 plskin = OETextureUtil.getPlayerSkinTexture(name);
        OERenderUtil.drawTexture(plskin, poseStack, x, y, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc);
        OERenderUtil.drawTexture(plskin, poseStack, x, y, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc);
        poseStack.method_22909();
    }

    public static void drawTexture(class_2960 location, class_4587 poseStack, float x, float y, float textureStartX, float textureStartY, float textureFinishWidth, float textureFinishHeight) {
        OERenderUtil.drawTexture(location, poseStack, x, y, textureStartX, textureStartY, textureFinishWidth, textureFinishHeight, 256.0f, 256.0f);
    }

    public static void drawTexture(class_2960 location, class_4587 poseStack, float x, float y, float textureStartX, float textureStartY, float textureFinishWidth, float textureFinishHeight, float textureSizeX, float textureSizeY) {
        poseStack.method_22903();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)location);
        OERenderUtil.fBlit(poseStack, x, y, textureStartX, textureStartY, textureFinishWidth, textureFinishHeight, textureSizeX, textureSizeY);
        poseStack.method_22909();
    }

    public static void drawColorTexture(class_2960 location, class_4587 poseStack, float x, float y, float textureStartX, float textureStartY, float textureFinishWidth, float textureFinishHeight, int color) {
        OERenderUtil.drawColorTexture(location, poseStack, x, y, textureStartX, textureStartY, textureFinishWidth, textureFinishHeight, 256.0f, 256.0f, color);
    }

    public static void drawColorTexture(class_2960 location, class_4587 poseStack, float x, float y, float textureStartX, float textureStartY, float textureFinishWidth, float textureFinishHeight, float textureSizeX, float textureSizeY, int color) {
        float r = (float)FNColorUtil.getRed((int)color) / 255.0f;
        float g = (float)FNColorUtil.getGreen((int)color) / 255.0f;
        float b = (float)FNColorUtil.getBlue((int)color) / 255.0f;
        float a = (float)FNColorUtil.getAlpha((int)color) / 255.0f;
        poseStack.method_22903();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        RenderSystem.setShaderTexture((int)0, (class_2960)location);
        OERenderUtil.fBlit(poseStack, x, y, textureStartX, textureStartY, textureFinishWidth, textureFinishHeight, textureSizeX, textureSizeY);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        poseStack.method_22909();
    }

    private static void fBlit(class_4587 poseStack, float ix, float iy, float tsx, float tsy, float tw, float th, float tssx, float tssy) {
        class_1159 matrix4f = poseStack.method_23760().method_23761();
        float x = ix;
        float y = ix + tw;
        float w = iy;
        float h = iy + th;
        float u1 = tsx / tssx;
        float u2 = (tsx + tw) / tssx;
        float v1 = tsy / tssy;
        float v2 = (tsy + th) / tssy;
        RenderSystem.setShader(class_757::method_34542);
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f, x, h, 0.0f).method_22913(u1, v2).method_1344();
        bufferBuilder.method_22918(matrix4f, y, h, 0.0f).method_22913(u2, v2).method_1344();
        bufferBuilder.method_22918(matrix4f, y, w, 0.0f).method_22913(u2, v1).method_1344();
        bufferBuilder.method_22918(matrix4f, x, w, 0.0f).method_22913(u1, v1).method_1344();
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
    }

    public static void poseTrans16(class_4587 poseStack, double x, double y, double z) {
        float pix = 0.0625f;
        poseStack.method_22904((double)pix * x, (double)pix * y, (double)pix * z);
    }

    public static void poseScaleAll(class_4587 poseStack, float scale) {
        poseStack.method_22905(scale, scale, scale);
    }

    public static void poseRotateAll(class_4587 poseStack, float x, float y, float z) {
        OERenderUtil.poseRotateX(poseStack, x);
        OERenderUtil.poseRotateY(poseStack, y);
        OERenderUtil.poseRotateZ(poseStack, z);
    }

    public static void poseRotateX(class_4587 poseStack, float angle) {
        poseStack.method_22907(class_1160.field_20703.method_23214(angle));
    }

    public static void poseRotateY(class_4587 poseStack, float angle) {
        poseStack.method_22907(class_1160.field_20705.method_23214(angle));
    }

    public static void poseRotateZ(class_4587 poseStack, float angle) {
        poseStack.method_22907(class_1160.field_20707.method_23214(angle));
    }

    public static void poseRotateHorizontalState(class_4587 poseStack, class_2680 state, int roted) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
        OERenderUtil.poseRotateDirection(poseStack, direction, roted);
    }

    public static void poseRotateDirection(class_4587 poseStack, class_2350 direction, int roted) {
        for (int i = 0; i < roted; ++i) {
            direction = direction.method_10170();
        }
        if (direction == class_2350.field_11039) {
            OERenderUtil.poseRotateY(poseStack, 180.0f);
            poseStack.method_22904(-1.0, 0.0, -1.0);
        } else if (direction == class_2350.field_11043) {
            OERenderUtil.poseRotateY(poseStack, 90.0f);
            poseStack.method_22904(-1.0, 0.0, 0.0);
        } else if (direction == class_2350.field_11035) {
            OERenderUtil.poseRotateY(poseStack, 270.0f);
            poseStack.method_22904(0.0, 0.0, -1.0);
        }
    }

    public static void renderPlayerFaceSprite(class_4587 poseStack, class_4597 multiBufferSource, UUID uuid, float x, float y, float z, float pitch, float yaw, float roll, float size, int combinedLightIn, int combinedOverlayIn) {
        float sc = size / 8.0f;
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(uuid), poseStack, multiBufferSource, x, y, z, pitch, yaw, roll, size, size, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(uuid), poseStack, multiBufferSource, x, y, z + 1.0E-5f, pitch, yaw, roll, size, size, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
    }

    public static void renderPlayerFaceSprite(class_4587 poseStack, class_4597 multiBufferSource, String name, float x, float y, float z, float pitch, float yaw, float roll, float size, int combinedLightIn, int combinedOverlayIn) {
        float sc = size / 8.0f;
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(name), poseStack, multiBufferSource, x, y, z, pitch, yaw, roll, size, size, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(name), poseStack, multiBufferSource, x, y, z + 1.0E-5f, pitch, yaw, roll, size, size, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
    }

    public static void renderPlayerFaceSpriteSides(class_4587 poseStack, class_4597 multiBufferSource, UUID uuid, float x, float y, float z, float pitch, float yaw, float roll, float size, int combinedLightIn, int combinedOverlayIn) {
        float sc = size / 8.0f;
        OERenderUtil.renderTextureSpriteSides(OETextureUtil.getPlayerSkinTexture(uuid), poseStack, multiBufferSource, x, y, z, pitch, yaw, roll, size, size, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(uuid), poseStack, multiBufferSource, x, y, z + 1.0E-5f, pitch, yaw, roll, size, size, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(uuid), poseStack, multiBufferSource, x + 1.0f, y, z - 2.0E-5f, pitch, yaw + 180.0f, roll, size, size, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
    }

    public static void renderPlayerFaceSpriteSides(class_4587 poseStack, class_4597 multiBufferSource, String name, float x, float y, float z, float pitch, float yaw, float roll, float size, int combinedLightIn, int combinedOverlayIn) {
        float sc = size / 8.0f;
        OERenderUtil.renderTextureSpriteSides(OETextureUtil.getPlayerSkinTexture(name), poseStack, multiBufferSource, x, y, z, pitch, yaw, roll, size, size, 8.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(name), poseStack, multiBufferSource, x, y, z + 1.0E-5f, pitch, yaw, roll, size, size, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
        OERenderUtil.renderTextureSprite(OETextureUtil.getPlayerSkinTexture(name), poseStack, multiBufferSource, x + 1.0f, y, z - 2.0E-5f, pitch, yaw + 180.0f, roll, size, size, 40.0f * sc, 8.0f * sc, 8.0f * sc, 8.0f * sc, 64.0f * sc, 64.0f * sc, combinedLightIn, combinedOverlayIn);
    }

    public static void renderTextureSprite(class_2960 location, class_4587 poseStack, class_4597 multiBufferSource, float x, float y, float z, float pitch, float yaw, float roll, float w, float h, float texStartX, float texStartY, float texFinishX, float texFinishY, float texSizeW, float texSizeH, int combinedLightIn, int combinedOverlayIn) {
        OERenderUtil.renderColorTextureSprite(location, poseStack, multiBufferSource, x, y, z, 1.0f, 1.0f, 1.0f, 1.0f, pitch, yaw, roll, w, h, texStartX, texStartY, texFinishX, texFinishY, texSizeW, texSizeH, combinedLightIn, combinedOverlayIn);
    }

    public static void renderColorTextureSprite(class_2960 location, class_4587 poseStack, class_4597 multiBufferSource, float x, float y, float z, float r, float g, float b, float a, float pitch, float yaw, float roll, float w, float h, float texStartX, float texStartY, float texFinishX, float texFinishY, float texSizeW, float texSizeH, int combinedLightIn, int combinedOverlayIn) {
        poseStack.method_22903();
        poseStack.method_22904((double)x, (double)y, (double)z);
        OERenderUtil.poseRotateY(poseStack, yaw);
        OERenderUtil.poseRotateX(poseStack, pitch);
        OERenderUtil.poseRotateZ(poseStack, roll);
        class_4588 vc = multiBufferSource.getBuffer(class_1921.method_23028((class_2960)location));
        float wst = texStartX / texSizeW;
        float wft = texFinishX / texSizeW + wst;
        float hst = texStartY / texSizeH;
        float hft = texFinishY / texSizeH + hst;
        class_4587.class_4665 pose = poseStack.method_23760();
        OERenderUtil.vertex(vc, pose, 0.0f, 0.0f, 0.0f, wst, hft, r, g, b, a, combinedOverlayIn, combinedLightIn);
        OERenderUtil.vertex(vc, pose, w, 0.0f, 0.0f, wft, hft, r, g, b, a, combinedOverlayIn, combinedLightIn);
        OERenderUtil.vertex(vc, pose, w, h, 0.0f, wft, hst, r, g, b, a, combinedOverlayIn, combinedLightIn);
        OERenderUtil.vertex(vc, pose, 0.0f, h, 0.0f, wst, hst, r, g, b, a, combinedOverlayIn, combinedLightIn);
        poseStack.method_22909();
    }

    public static void renderTextureSpriteSides(class_2960 location, class_4587 poseStack, class_4597 multiBufferSource, float x, float y, float z, float pitch, float yaw, float roll, float w, float h, float texStartX, float texStartY, float texFinishX, float texFinishY, float texSizeW, float texSizeH, int combinedLightIn, int combinedOverlayIn) {
        OERenderUtil.renderTextureSprite(location, poseStack, multiBufferSource, x, y, z, pitch, yaw, roll, w, h, texStartX, texStartY, texFinishX, texFinishY, texSizeW, texSizeH, combinedLightIn, combinedOverlayIn);
        OERenderUtil.renderTextureSprite(location, poseStack, multiBufferSource, x + 1.0f, y, z - 1.0E-5f, pitch, yaw + 180.0f, roll, w, h, texStartX, texStartY, texFinishX, texFinishY, texSizeW, texSizeH, combinedLightIn, combinedOverlayIn);
    }

    private static void vertex(class_4588 builder, class_4587.class_4665 pose, float x, float y, float z, float u, float v, float r, float g, float b, float a, int combinedOverlayIn, int combinedLightIn) {
        builder.method_22918(pose.method_23761(), x, y, z).method_22915(r, g, b, a).method_22913(u, v).method_22922(combinedOverlayIn).method_22916(combinedLightIn).method_23763(pose.method_23762(), 0.0f, 0.0f, 0.0f).method_1344();
    }

    public static class_1087 getModel(class_1091 location) {
        return mc.method_1554().method_4742(location);
    }

    public static class_1087 getBlockModel(class_2680 state) {
        return mc.method_1554().method_4743().method_3335(state);
    }

    public static void renderModel(class_4587 poseStack, class_4588 vertexConsumer, class_1087 bakedModel, int combinedLight, int combinedOverlay) {
        class_778 bmr = mc.method_1541().method_3350();
        bmr.method_3367(poseStack.method_23760(), vertexConsumer, null, bakedModel, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay);
    }

    public static void renderModel(class_4587 poseStack, class_4588 vertexConsumer, class_1087 bakedModel, int combinedLight, int combinedOverlay, int color) {
        class_778 bmr = mc.method_1541().method_3350();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        bmr.method_3367(poseStack.method_23760(), vertexConsumer, null, bakedModel, r, g, b, combinedLight, combinedOverlay);
    }
}

