/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import org.apache.commons.lang3.ArrayUtils;

public class OEVoxelShapeUtil {
    private static final Gson gson = new Gson();

    public static class_265 makeBox(double x1, double y1, double z1, double x2, double y2, double z2) {
        return class_2248.method_9541((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public static class_265 makeBoxY90(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBox(z1, y1, 16.0 - x1, z2, y2, 16.0 - x2);
    }

    public static class_265 makeBoxY180(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBox(16.0 - x1, y1, 16.0 - z1, 16.0 - x2, y2, 16.0 - z2);
    }

    public static class_265 makeBoxY270(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBoxY180(z1, y1, 16.0 - x1, z2, y2, 16.0 - x2);
    }

    public static class_265 addBoxY0(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBox(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static class_265 addBoxY90(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBoxY90(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static class_265 addBoxY180(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBoxY180(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static class_265 addBoxY270(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtil.makeBoxY270(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static class_265 uniteBox(class_265 ... shapes) {
        return class_259.method_17786((class_265)shapes[0], (class_265[])((class_265[])ArrayUtils.remove((Object[])shapes, (int)0)));
    }

    public static class_265 moveBox(class_265 shape, double x, double y, double z) {
        Object[] shapes = new class_265[]{};
        for (class_238 aabb : shape.method_1090()) {
            shapes = (class_265[])ArrayUtils.add((Object[])shapes, (Object)class_259.method_1078((class_238)aabb.method_989(0.0625 * x, 0.0625 * y, 0.0625 * z)));
        }
        return OEVoxelShapeUtil.uniteBox((class_265[])shapes);
    }

    public static class_265 rotateBoxY90(class_265 shape) {
        Object[] shapes = new class_265[]{};
        for (class_238 aabb : shape.method_1090()) {
            shapes = (class_265[])ArrayUtils.add((Object[])shapes, (Object)class_259.method_1078((class_238)new class_238(aabb.field_1321, aabb.field_1322, 1.0 - aabb.field_1323, aabb.field_1324, aabb.field_1325, 1.0 - aabb.field_1320)));
        }
        return OEVoxelShapeUtil.uniteBox((class_265[])shapes);
    }

    public static class_265 rotateBoxY180(class_265 shape) {
        Object[] shapes = new class_265[]{};
        for (class_238 aabb : shape.method_1090()) {
            shapes = (class_265[])ArrayUtils.add((Object[])shapes, (Object)class_259.method_1078((class_238)new class_238(1.0 - aabb.field_1323, aabb.field_1322, 1.0 - aabb.field_1321, 1.0 - aabb.field_1320, aabb.field_1325, 1.0 - aabb.field_1324)));
        }
        return OEVoxelShapeUtil.uniteBox((class_265[])shapes);
    }

    public static class_265 rotateBoxY270(class_265 shape) {
        Object[] shapes = new class_265[]{};
        for (class_238 aabb : OEVoxelShapeUtil.rotateBoxY180(shape).method_1090()) {
            shapes = (class_265[])ArrayUtils.add((Object[])shapes, (Object)class_259.method_1078((class_238)new class_238(aabb.field_1321, aabb.field_1322, 1.0 - aabb.field_1323, aabb.field_1324, aabb.field_1325, 1.0 - aabb.field_1320)));
        }
        return OEVoxelShapeUtil.uniteBox((class_265[])shapes);
    }

    public static class_265 rotateBoxX90(class_265 shape) {
        Object[] shapes = new class_265[]{};
        for (class_238 aabb : shape.method_1090()) {
            shapes = (class_265[])ArrayUtils.add((Object[])shapes, (Object)class_259.method_1078((class_238)new class_238(aabb.field_1322, aabb.field_1323, aabb.field_1321, aabb.field_1325, aabb.field_1320, aabb.field_1324)));
        }
        return OEVoxelShapeUtil.uniteBox((class_265[])shapes);
    }

    public static class_265 rotateBoxX180(class_265 shape) {
        Object[] shapes = new class_265[]{};
        for (class_238 aabb : shape.method_1090()) {
            shapes = (class_265[])ArrayUtils.add((Object[])shapes, (Object)class_259.method_1078((class_238)new class_238(1.0 - aabb.field_1323, 1.0 - aabb.field_1322, aabb.field_1321, 1.0 - aabb.field_1320, 1.0 - aabb.field_1325, aabb.field_1324)));
        }
        return OEVoxelShapeUtil.uniteBox((class_265[])shapes);
    }

    public static class_265 rotateBoxX270(class_265 shape) {
        Object[] shapes = new class_265[]{};
        for (class_238 aabb : OEVoxelShapeUtil.rotateBoxY180(shape).method_1090()) {
            shapes = (class_265[])ArrayUtils.add((Object[])shapes, (Object)class_259.method_1078((class_238)new class_238(1.0 - aabb.field_1322, aabb.field_1323, aabb.field_1321, 1.0 - aabb.field_1325, aabb.field_1320, aabb.field_1324)));
        }
        return OEVoxelShapeUtil.uniteBox((class_265[])shapes);
    }

    public static class_265 rotateBoxZ90(class_265 shape) {
        Object[] shapes = new class_265[]{};
        for (class_238 aabb : shape.method_1090()) {
            shapes = (class_265[])ArrayUtils.add((Object[])shapes, (Object)class_259.method_1078((class_238)new class_238(aabb.field_1323, aabb.field_1321, aabb.field_1322, aabb.field_1320, aabb.field_1324, aabb.field_1325)));
        }
        return OEVoxelShapeUtil.uniteBox((class_265[])shapes);
    }

    public static class_265 rotateBoxZ180(class_265 shape) {
        Object[] shapes = new class_265[]{};
        for (class_238 aabb : shape.method_1090()) {
            shapes = (class_265[])ArrayUtils.add((Object[])shapes, (Object)class_259.method_1078((class_238)new class_238(aabb.field_1323, 1.0 - aabb.field_1322, 1.0 - aabb.field_1321, aabb.field_1320, 1.0 - aabb.field_1325, 1.0 - aabb.field_1324)));
        }
        return OEVoxelShapeUtil.uniteBox((class_265[])shapes);
    }

    public static class_265 rotateBoxDirection(class_265 shape, class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11035 -> OEVoxelShapeUtil.rotateBoxY180(shape);
            case class_2350.field_11034 -> OEVoxelShapeUtil.rotateBoxY270(shape);
            case class_2350.field_11039 -> OEVoxelShapeUtil.rotateBoxY90(shape);
            default -> shape;
        };
    }

    public static class_265 getShapeFromJson(JsonObject shapeJ) {
        class_265[] shapes = null;
        for (JsonElement jshape : shapeJ.getAsJsonArray("shapes")) {
            JsonArray ja = jshape.getAsJsonArray();
            class_265 shape = OEVoxelShapeUtil.makeBox(ja.get(0).getAsDouble(), ja.get(1).getAsDouble(), ja.get(2).getAsDouble(), ja.get(3).getAsDouble(), ja.get(4).getAsDouble(), ja.get(5).getAsDouble());
            shapes = (class_265[])ArrayUtils.add(shapes, (Object)shape);
        }
        return OEVoxelShapeUtil.uniteBox(shapes);
    }

    public static class_265 getShapeFromResource(class_2960 location) {
        InputStream stream = OEVoxelShapeUtil.class.getResourceAsStream("/data/" + location.method_12836() + "/shape/" + location.method_12832() + ".json");
        if (stream == null) {
            return OEVoxelShapeUtil.makeBox(16.0, 16.0, 16.0, 16.0, 16.0, 16.0);
        }
        return OEVoxelShapeUtil.getShapeFromJson((JsonObject)gson.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), JsonObject.class));
    }
}

