/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.util;

import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.util.OEURLUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2818;
import net.minecraft.class_3215;
import net.minecraft.class_3222;

public class OEPlayerUtil {
    private static final String UUID_PLAYER_URL = "https://sessionserver.mojang.com/session/minecraft/profile/%s";

    public static Optional<String> getNameByUUID(UUID uuid) {
        try {
            JsonObject jo = OEURLUtil.getJson(new URL(String.format(UUID_PLAYER_URL, uuid.toString())));
            String name = jo.get("name").getAsString();
            return Optional.ofNullable(name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Optional.empty();
        }
    }

    public static CompletableFuture<Void> getNameByUUIDAsync(UUID id, Consumer<Optional<String>> name) {
        try {
            return OEURLUtil.getJsonAsync(new URL(String.format(UUID_PLAYER_URL, id.toString())), n -> {
                String na = null;
                try {
                    na = n.get("name").getAsString();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                name.accept(Optional.ofNullable(na));
            });
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return CompletableFuture.completedFuture(null);
        }
    }

    public static void giveItem(class_1657 player, class_1799 stack) {
        if (!player.method_7270(stack)) {
            player.method_7329(stack, false, true);
        }
    }

    public static void changeOrGiveItem(class_1657 player, class_1268 hand, class_1799 stack) {
        class_1799 heldItem = player.method_5998(hand);
        if (!player.method_31549().field_7477) {
            heldItem.method_7934(1);
        }
        if (heldItem.method_7960()) {
            player.method_6122(hand, stack);
        } else {
            OEPlayerUtil.giveItem(player, stack);
        }
    }

    public static void doPlayers(class_2818 chunk, Consumer<class_3222> playerConsumer) {
        ((class_3215)chunk.method_12200().method_8398()).field_17254.method_17210(chunk.method_12004(), false).forEach(playerConsumer);
    }
}

