package dev.felnull.otyacraftengine.block;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.util.OEVoxelShapeUtil;
import java.util.*;
import net.minecraft.class_265;
import var;

public class IkisugiVoxelShape {
    private static final IkisugiVoxelShape INSTANCE = new IkisugiVoxelShape();

    public static IkisugiVoxelShape getInstance() {
        return INSTANCE;
    }

    public class_265 getShapeFromJson(JsonObject shapeJson) {
        var version = shapeJson.get("version");
        if (version != null && version.getAsInt() == 2)
            return getShapeFromJsonV2(shapeJson);
        return getShapeFromJsonV1(shapeJson);
    }

    private class_265 getShapeFromJsonV1(JsonObject shapeJ) {
        List<class_265> shapes = new ArrayList<>();
        for (JsonElement jshape : shapeJ.getAsJsonArray("shapes")) {
            JsonArray ja = jshape.getAsJsonArray();
            class_265 shape = OEVoxelShapeUtil.makeBox(ja.get(0).getAsDouble(), ja.get(1).getAsDouble(), ja.get(2).getAsDouble(), ja.get(3).getAsDouble(), ja.get(4).getAsDouble(), ja.get(5).getAsDouble());
            shapes.add(shape);
        }
        return OEVoxelShapeUtil.uniteBox(shapes);
    }

    private class_265 getShapeFromJsonV2(JsonObject shapeJ) {
        List<class_265> shapes = new ArrayList<>();
        for (JsonElement jshape : shapeJ.getAsJsonArray("shapes")) {
            JsonArray ja = jshape.getAsJsonArray();
            class_265 shape = OEVoxelShapeUtil.makeBox(ja.get(0).getAsDouble() * 16, ja.get(1).getAsDouble() * 16, ja.get(2).getAsDouble() * 16, ja.get(3).getAsDouble() * 16, ja.get(4).getAsDouble() * 16, ja.get(5).getAsDouble() * 16);
            shapes.add(shape);
        }
        var shape = OEVoxelShapeUtil.uniteBox(shapes);
        Set<IIkisugiVoxelShape.Edge> edges = new HashSet<>();
        for (JsonElement jshape : shapeJ.getAsJsonArray("edges")) {
            JsonArray ja = jshape.getAsJsonArray();
            edges.add(new IIkisugiVoxelShape.Edge(ja.get(0).getAsDouble(), ja.get(1).getAsDouble(), ja.get(2).getAsDouble(), ja.get(3).getAsDouble(), ja.get(4).getAsDouble(), ja.get(5).getAsDouble()));
        }
        ((IIkisugiVoxelShape) shape).setEdges(Collections.unmodifiableSet(edges));
        return shape;
    }

    public class_265 copy(class_265 target, IIkisugiVoxelShape source) {
        ((IIkisugiVoxelShape) target).setEdges(source.getEdges());
        return target;
    }

    public class_265 unite(class_265 target, class_265... shapes) {
        Set<IIkisugiVoxelShape.Edge> edges = new HashSet<>();
        for (class_265 shape : shapes) {
            var shp = ((IIkisugiVoxelShape) shape).getEdges();
            if (shp != null)
                edges.addAll(shp);
        }
        ((IIkisugiVoxelShape) target).setEdges(Collections.unmodifiableSet(edges));
        return target;
    }

    public class_265 unite(class_265 target, List<IIkisugiVoxelShape> shapes) {
        Set<IIkisugiVoxelShape.Edge> edges = new HashSet<>();
        shapes.forEach(n -> {
            var shp = n.getEdges();
            if (shp != null)
                edges.addAll(shp);
        });
        ((IIkisugiVoxelShape) target).setEdges(Collections.unmodifiableSet(edges));
        return target;
    }

    public class_265 move(class_265 target, IIkisugiVoxelShape source, double x, double y, double z) {
        x /= 16;
        y /= 16;
        z /= 16;
        Set<IIkisugiVoxelShape.Edge> edges = new HashSet<>();
        if (source.getEdges() == null) return target;
        for (IIkisugiVoxelShape.Edge edge : source.getEdges()) {
            edges.add(new IIkisugiVoxelShape.Edge(edge.stX() + x, edge.stY() + y, edge.stZ() + z, edge.enX() + x, edge.enY() + y, edge.enZ() + z));
        }
        ((IIkisugiVoxelShape) target).setEdges(Collections.unmodifiableSet(edges));
        return target;
    }

    public class_265 rotate(class_265 target, IIkisugiVoxelShape source, RotateAngledAxis angledAxis) {
        Set<IIkisugiVoxelShape.Edge> edges = new HashSet<>();
        if (source.getEdges() == null) return target;
        for (IIkisugiVoxelShape.Edge edge : source.getEdges()) {
            edges.add(angledAxis.convertEdge(edge));
        }
        ((IIkisugiVoxelShape) target).setEdges(Collections.unmodifiableSet(edges));
        return target;
    }

}
