package dev.felnull.otyacraftengine.blockentity;

import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public abstract class OEBaseContainerBlockEntity extends class_2624 implements IClientSyncbleBlockEntity, IInstructionBlockEntity, ItemDroppedBlockEntity {

    protected OEBaseContainerBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public class_2487 getSyncData(class_3222 player, class_2487 tag) {
        class_1262.method_5426(tag, getItems());
        return tag;
    }

    @Override
    public void onSync(class_2487 tag) {
        getItems().clear();
        class_1262.method_5429(tag, getItems());
    }

    @Override
    public void sync() {
        IClientSyncbleBlockEntity.syncBlockEntity(this);
    }

    @Override
    public class_2487 onInstruction(class_3222 player, String name, int num, class_2487 data) {
        return null;
    }

    @Override
    public boolean canInstructionWith(class_3222 player, String name, int num, class_2487 data) {
        return method_5443(player);
    }

    @NotNull
    abstract public class_2371<class_1799> getItems();

    @Override
    public int method_5439() {
        return getItems().size();
    }

    @Override
    public boolean method_5442() {
        return getItems().stream().allMatch(class_1799::method_7960);
    }

    @Override
    public class_1799 method_5438(int i) {
        return getItems().get(i);
    }

    @Override
    public class_1799 method_5434(int i, int j) {
        return class_1262.method_5430(getItems(), i, j);
    }

    @Override
    public class_1799 method_5441(int i) {
        return class_1262.method_5428(getItems(), i);
    }

    @Override
    public void method_5447(int i, class_1799 stack) {
        class_1799 itemstack = getItems().get(i);
        boolean flag = !stack.method_7960() && stack.method_7962(itemstack) && class_1799.method_7975(stack, itemstack);
        getItems().set(i, stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        if (flag)
            this.method_5431();
    }

    @Override
    public boolean method_5443(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this)
            return false;
        return isUsableByPlayer(player);
    }

    @Override
    public void method_5448() {
        getItems().clear();
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        class_1262.method_5429(tag, getItems());
    }

    @Override
    public class_2487 method_11007(class_2487 tag) {
        class_1262.method_5426(tag, getItems());
        return super.method_11007(tag);
    }

    public boolean isUsableByPlayer(class_1657 player) {
        return method_10997().method_8321(method_11016()) == this && player.method_5649((double) method_11016().method_10263() + 0.5D, (double) method_11016().method_10264() + 0.5D, (double) method_11016().method_10260() + 0.5D) <= 64.0D;
    }

    @Override
    public class_2371<class_1799> getDroppedItems() {
        return getItems();
    }

    @Override
    public boolean isRetainEmpty() {
        return method_5442();
    }
}
